/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.time.LocalDateTime;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.base.BootTaskRes;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtes.business.bill.BillIncCalHelper;
import kd.wtc.wtes.business.bill.BillIncrCalcService;

public class BillIncrCalcConsumer
implements MessageConsumer {
    private static final Log LOG = LogFactory.getLog(BillIncrCalcConsumer.class);

    public void onMessage(Object data, String messageId, boolean resend, MessageAcker acker) {
        if (!(data instanceof BillApply)) {
            LOG.warn("incrCalc.scene=onMessage.illegalArgument,data={},messageId={},resend={}", new Object[]{data, messageId, resend});
            acker.discard(messageId);
            return;
        }
        BillApply billApply = (BillApply)data;
        long billId = billApply.getId();
        String billNo = billApply.getBillNo();
        long attFileBoid = billApply.getAttFileBoId();
        long attFileBoVid = billApply.getAttFileVId();
        long orgId = billApply.getOrgId();
        LOG.debug("incrCalc.billNo={},billId={},scene=onMessage,messageId={},resend={}", new Object[]{billNo, billId, messageId, resend});
        BillIncrCalcService service = new BillIncrCalcService();
        LocalDateTime startTime = LocalDateTime.now();
        service.saveValidLog(billId, billNo, startTime, null, null, "A", attFileBoid, attFileBoVid, orgId);
        BootTaskRes bootTaskRes = null;
        try {
            bootTaskRes = BillIncCalHelper.runTaskForBill(billApply);
        }
        catch (Exception exp) {
            LOG.warn("incrCalc.billNo=" + billNo, (Throwable)exp);
            bootTaskRes = new BootTaskRes();
            bootTaskRes.markSysError(exp.getMessage());
        }
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("wtte_billincrcalclog");
        DynamicObject log = logHelper.loadDynamicObject(new QFilter[]{new QFilter("billid", "=", (Object)billId).and(new QFilter("calcstatus", "=", (Object)"A"))});
        if (bootTaskRes.isSuccess()) {
            log.set("calcstatus", (Object)"C");
        } else if (bootTaskRes.isSysError()) {
            log.set("errcode", (Object)"sys");
            String errMsg = bootTaskRes.getRequestTaskId() + ":" + bootTaskRes.getSysErrMsg();
            if (errMsg.length() > 2000) {
                errMsg = errMsg.substring(0, 1999);
            }
            log.set("errdesc", (Object)errMsg);
            log.set("calcstatus", (Object)"B");
        } else if (bootTaskRes.isBizError()) {
            log.set("errcode", (Object)"biz");
            String errMsg = bootTaskRes.getRequestTaskId() + ":" + bootTaskRes.getBizErrMsg();
            if (errMsg.length() > 2000) {
                errMsg = errMsg.substring(0, 1999);
            }
            log.set("errdesc", (Object)errMsg);
            log.set("calcstatus", (Object)"B");
        }
        service.setEndTime(log, startTime);
        logHelper.saveOne(log);
    }
}

