/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtes.business.core.TieAlarm;
import kd.wtc.wtes.business.core.TieException;
import kd.wtc.wtes.business.core.TieInterruptingException;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.TieStateful;
import kd.wtc.wtes.business.core.TieTerminable;
import kd.wtc.wtes.business.core.engine.AbstractTieEngine;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.log.TieLogFactory;
import kd.wtc.wtes.business.service.ICalFinishAfterProcessService;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;

public abstract class AbstractTieRunner
implements TieStateful,
TieTerminable,
Runnable,
TieAlarm {
    private static final int MAX_EXPORT_SIZE = 150;
    private static final int MAX_EXPORT_LINE = 20;
    private volatile TieState state = TieState.NEW;
    private final Object stateChangeMonitor = new Object();
    protected final Log log = TieLogFactory.getLog(this.getClass());
    protected String exceptionStr;
    private RequestContext requestContext;

    public abstract TieRequest getTieRequest();

    public TaskDesc getTaskDesc(TieRequest request) {
        return null;
    }

    private void caughtException() {
        Thread.currentThread().setUncaughtExceptionHandler((t, throwable) -> {
            this.log.warn("[TIE] InstanceId: %s, TieEngineTag: %s error", new Object[]{Instance.getInstanceId(), this.getRunnerTag(), throwable});
            try {
                this.stateChanged(TieState.ERROR);
            }
            catch (Exception e) {
                this.log.warn("[TIE] InstanceId: %s, TieEngineTag: %s, state could not changed to error", new Object[]{Instance.getInstanceId(), this.getRunnerTag(), e});
            }
        });
    }

    private void logStep(String step) {
        if (this instanceof AbstractTieEngine) {
            String version = "";
            if (this.getTieRequest() != null && this.getTieRequest().getVersion() != null) {
                version = this.getTieRequest().getVersion();
            }
            if (this.getTieRequest() != null) {
                version = version + this.getTieRequest().getSubTaskId();
            }
            this.log.warn("engine.run, {} p{} {}", new Object[]{version, step, WTCDateUtils.date2Str((Date)new Date(), (String)"HH:mm:ss")});
        }
    }

    @Override
    public void run() {
        if (this.requestContext != null) {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
        }
        this.caughtException();
        try {
            this.beforeRun();
            this.logStep("1");
            this.checkAndSetState(TieState.INIT);
            this.logStep("2");
            this.init();
            this.logStep("3");
            this.validate();
            this.logStep("4");
            this.checkAndSetState(TieState.RUNNING);
            this.logStep("5");
            this.beforeDoRun();
            this.logStep("6");
            this.doRun();
            this.logStep("7");
            this.doRunAfter();
            this.logStep("8");
            this.checkAndSetState(TieState.SUCCESS);
            this.logStep("9");
        }
        catch (TieInterruptingException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e3b\u52a8\u68c0\u6d4b\u5230\u7ec8\u6b62\uff1a", (String)"AbstractTieRunner_0", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true);
            this.stateChanged(TieState.TERMINATED);
        }
        catch (InterruptedException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u7ebf\u7a0b\u68c0\u67e5\u4e2d\u65ad\u88ab\u7ec8\u6b62\uff1a", (String)"AbstractTieRunner_1", (String)"wtc-wtes-business", (Object[])new Object[0]), e, false);
            this.stateChanged(TieState.TERMINATING);
            this.stateChanged(TieState.TERMINATED);
        }
        catch (CancellationException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u68c0\u67e5\u4e2d\u65ad\u88ab\u53d6\u6d88\uff1a", (String)"AbstractTieRunner_2", (String)"wtc-wtes-business", (Object[])new Object[0]), e, false);
            this.stateChanged(TieState.TERMINATED);
        }
        catch (WtesBizException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u53d1\u751f\u9519\u8bef\u7ec8\u6b62\uff1a", (String)"AbstractTieRunner_3", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, true, false);
            this.stateChanged(TieState.ERROR);
        }
        catch (WtesException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u53d1\u751f\u9519\u8bef\u7ec8\u6b62\uff1a", (String)"AbstractTieRunner_3", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, true, false);
            this.stateChanged(TieState.ERROR);
        }
        catch (TieException e) {
            this.log.warn("AbstractTieRunner error:TieException", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractTieRunner_5", (String)"wtc-wtes-business", (Object[])new Object[0]), e.getCause(), true, false, false);
            this.stateChanged(TieState.ERROR);
        }
        catch (KDException e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractTieRunner_5", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, false, false);
            this.stateChanged(TieState.ERROR);
        }
        catch (Exception e) {
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractTieRunner_5", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, false, false);
            this.stateChanged(TieState.ERROR);
        }
        finally {
            try {
                this.logStep("10");
                this.afterRun();
                this.logStep("11");
            }
            catch (Exception e) {
                this.log.warn("TieEngine after run error", (Throwable)e);
            }
        }
    }

    protected abstract void doRunAfter();

    private void checkAndSetState(TieState state) throws TieInterruptingException, InterruptedException {
        this.checkInterrupt();
        this.stateChanged(state);
    }

    protected void beforeRun() throws TieException, InterruptedException {
    }

    protected void init() throws TieException, InterruptedException {
    }

    protected abstract void beforeDoRun();

    protected abstract void doRun() throws TieException, InterruptedException;

    protected void afterRun() {
    }

    protected void validate() throws WtesException {
    }

    @Override
    public void terminate() {
        this.stateChanged(TieState.TERMINATING);
    }

    @Override
    public TieState getState() {
        return this.state;
    }

    private void stateChanged(TieState state) {
        TieState oldState = this.syncChange(state);
        if (oldState != null) {
            this.stateChanged(oldState, state);
        }
    }

    protected abstract String getRunnerTag();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TieState syncChange(TieState state) {
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (state.isAfter(this.state)) {
                TieState oldState = this.state;
                this.state = state;
                return oldState;
            }
            return null;
        }
    }

    protected abstract void stateChanged(TieState var1, TieState var2);

    protected final void checkInterrupt() throws TieInterruptingException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (TieState.TERMINATING == this.state) {
            throw new TieInterruptingException();
        }
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    private String getStackTraceMessage(Throwable exception) {
        if (exception == null) {
            return "";
        }
        this.log.warn("AbstractTieRunner.run error message:", exception);
        StackTraceElement[] traceArray = exception.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(exception.getMessage());
        sb.append(WTCSymbolMultiLanguageUtil.getColonSymbol());
        if (null != traceArray) {
            for (int i = 0; i < traceArray.length; ++i) {
                sb.append(traceArray[i]);
                if (i > 20) break;
            }
        }
        return sb.toString();
    }

    private void setReportExceptionStr(String preMark, Throwable exception, boolean stackFlag) {
        this.setReportExceptionStr(preMark, exception, stackFlag, true, true);
    }

    private void setReportExceptionStr(String preMark, Throwable exception, boolean stackFlag, boolean alarmException, boolean preMarkException) {
        this.log.warn(preMark, exception);
        String exceptionRemark = stackFlag ? this.getStackTraceMessage(exception) : exception.getMessage();
        this.exceptionStr = preMark + exceptionRemark;
        if (alarmException) {
            if (preMarkException) {
                this.alarm(TieMsgLevel.ERROR, this.getAlarmMessage(preMark, exception));
            } else {
                this.alarm(TieMsgLevel.ERROR, this.getExceptSubMsesage(exception));
            }
        } else {
            this.alarm(TieMsgLevel.ERROR, preMark);
        }
    }

    private String getExceptSubMsesage(Throwable exception) {
        if (exception == null) {
            return null;
        }
        String errMsg = null != exception.getMessage() ? exception.getMessage().substring(0, Math.min(150, exception.getMessage().length())) : "";
        String splite = WTCSymbolMultiLanguageUtil.getColonSymbol();
        if (!HRStringUtils.isEmpty((String)errMsg)) {
            int index = errMsg.indexOf(splite);
            int startIndex = index + 1;
            if (index >= 0 && errMsg.length() > startIndex) {
                return errMsg.substring(startIndex);
            }
            return errMsg;
        }
        return errMsg;
    }

    private String getAlarmMessage(String preMark, Throwable exception) {
        if (exception == null) {
            return preMark;
        }
        return preMark + (null != exception.getMessage() ? exception.getMessage().substring(0, Math.min(150, exception.getMessage().length())) : "");
    }

    protected void doCalDataClean(List<AttSubject> attSubjects, String version) {
        try (Span doRunAfterSpan = TaskTracer.newSpan((String)TieReportKDStrings.ENGINE_BEFORE_RUN_DATE_CLEAN.loadKDString());){
            DataPackageStoreManager.getInstance().doCalDataClean(attSubjects, version);
        }
    }

    protected void doCalFinishAfterProcess(TieEngineCallbackEvent callbackEvent) {
        List<ICalFinishAfterProcessService> callbackList = this.getCalFinishAfterProcessServiceList();
        if (WTCCollections.isNotEmpty(callbackList)) {
            try (Span doRunAfterSpan = TaskTracer.newSpan((String)TieReportKDStrings.ENGINE_DO_RUN_AFTER.loadKDString());){
                for (ICalFinishAfterProcessService callBackService : callbackList) {
                    String callbackTag = callBackService.getClass().getName();
                    this.log.debug("TieEngine_doCalFinishCallBack_try_to_call_{}", (Object)callbackTag);
                    Span callbackTagSpan = TaskTracer.newSpan((String)callbackTag);
                    Throwable throwable = null;
                    try {
                        callBackService.completedCallback(callbackEvent);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (callbackTagSpan == null) continue;
                        if (throwable != null) {
                            try {
                                callbackTagSpan.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        callbackTagSpan.close();
                    }
                }
            }
        }
    }

    private List<ICalFinishAfterProcessService> getCalFinishAfterProcessServiceList() {
        Object initialises = WTCAppContextHelper.getProjectParams().get("tie.init.cal.finish.callBackList");
        if (initialises == null) {
            return Collections.emptyList();
        }
        List initializerList = (List)initialises;
        return initializerList.stream().map(initializerBeanName -> (ICalFinishAfterProcessService)WTCAppContextHelper.getBean((String)initializerBeanName, ICalFinishAfterProcessService.class)).collect(Collectors.toList());
    }
}

