/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.AbstractTieExecutorsExecutor;
import kd.wtc.wtes.business.core.chain.TieChainExecutor;
import kd.wtc.wtes.business.core.chain.TieExecutionException;
import kd.wtc.wtes.business.core.chain.TieExecutor;
import kd.wtc.wtes.business.core.chain.TiePhaseExecutor;
import kd.wtc.wtes.business.core.chain.TieStatusDecision;
import kd.wtc.wtes.business.core.chain.TieStepExecutor;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.std.chain.TieStepExecutorStd;
import kd.wtc.wtes.common.util.Assert;

public class TiePhaseExecutorDefault<T extends ITieDataNode<T>>
extends AbstractTieExecutorsExecutor<T>
implements TiePhaseExecutor<T> {
    private TiePhaseConfig phaseConfig;
    private TieChainExecutor<T> chainExecutor;
    private TiePhaseIdentity phaseIdentity;

    @Override
    protected void init() throws TieExecutionException {
        super.init();
        Assert.nonNull((Object)this.phaseConfig, (String)"phaseConfig");
        Assert.nonNull(this.chainExecutor, (String)"chainExecutor");
        this.phaseIdentity = new TiePhaseIdentity(this.phaseConfig.getNumber(), this.chainExecutor.getSchemeIdentity(), this.phaseConfig.getIndex(), this.phaseConfig.getSaveFlag(), this.phaseConfig.getResult(), this.phaseConfig.getId());
    }

    @Override
    protected int getExecutorSize() {
        return this.phaseConfig.getStepConfigsByDate(this.chainExecutor.getChainDate()).size();
    }

    @Override
    protected TieExecutor<T> makeExecutor(int executorIndex) {
        List<TieStepConfig> stepConfigs = this.phaseConfig.getStepConfigsByDate(this.chainExecutor.getChainDate());
        TieStepConfig stepConfig = stepConfigs.get(executorIndex);
        TieStepExecutor executor = (TieStepExecutor)WTCAppContextHelper.getBean(TieStepExecutorStd.class);
        executor.setPhaseExecutor(this);
        executor.setStepConfig(stepConfig);
        CalReportParaHolder reportPara = this.getReportPara();
        executor.setReportPara(reportPara);
        return executor;
    }

    @Override
    public String getExecutorTag() {
        return this.phaseIdentity.getNumber();
    }

    @Override
    public String getExecutorName() {
        return this.phaseConfig.getName();
    }

    @Override
    protected TieStatusDecision makeDecision() {
        TieStatusDecision tieStatusDecision = (TieStatusDecision)WTCAppContextHelper.getBean(TieStatusDecision.class);
        tieStatusDecision.mackDecisionMap(this.phaseConfig.getExecutorDecision());
        return tieStatusDecision;
    }

    @Override
    public void setChainExecutor(TieChainExecutor<T> chainExecutor) {
        this.chainExecutor = chainExecutor;
    }

    @Override
    public TieChainExecutor<T> getChainExecutor() {
        return this.chainExecutor;
    }

    @Override
    public void setPhaseConfig(TiePhaseConfig phaseConfig) {
        this.phaseConfig = phaseConfig;
    }

    @Override
    public TiePhaseIdentity getPhaseIdentity() {
        return this.phaseIdentity;
    }

    @Override
    public void setPhaseIdentity(TiePhaseIdentity phaseIdentity) {
        this.phaseIdentity = phaseIdentity;
    }

    @Override
    public PhaseDataResult<T> getPhaseDataResult() {
        List stepDataResults = this.getExecutedExecutors().stream().map(TieStepExecutor::getStepDataResult).collect(Collectors.toList());
        return new TiePhaseDataResult(stepDataResults, this.getResultStatus(), this.phaseConfig.getNumber(), this.phaseConfig.getName(), this.phaseConfig.getId());
    }

    @Override
    public List<TieStepExecutor<T>> getExecutedExecutors() {
        return super.getExecutedExecutors();
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.chainExecutor.getAlarm().alarm(msgLevel, msg);
    }

    private static class TiePhaseDataResult<T extends ITieDataNode<T>>
    implements PhaseDataResult<T> {
        private final List<StepDataResult<T>> stepDataResults;
        private final TieStatus resultStatus;
        private final String number;
        private final String name;
        private final Long id;

        public TiePhaseDataResult(List<StepDataResult<T>> stepDataResults, TieStatus resultStatus, String number, String name, Long id) {
            this.stepDataResults = stepDataResults;
            this.resultStatus = resultStatus;
            this.number = number;
            this.name = name;
            this.id = id;
        }

        @Override
        public List<StepDataResult<T>> getStepDataResults() {
            return this.stepDataResults;
        }

        @Override
        public String getNumber() {
            return this.number;
        }

        @Override
        public TieStatus getResultStatus() {
            return this.resultStatus;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Long getId() {
            return this.id;
        }
    }
}

