/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtes.business.core.TieAlarm;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.AbstractTieExecutor;
import kd.wtc.wtes.business.core.chain.TieContext;
import kd.wtc.wtes.business.core.chain.TieContextDefault;
import kd.wtc.wtes.business.core.chain.TieDataResult;
import kd.wtc.wtes.business.core.chain.TieEvaluator;
import kd.wtc.wtes.business.core.chain.TieExecutionException;
import kd.wtc.wtes.business.core.chain.TieFilter;
import kd.wtc.wtes.business.core.chain.TieIdService;
import kd.wtc.wtes.business.core.chain.TiePhaseExecutor;
import kd.wtc.wtes.business.core.chain.TieStepExecutor;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactory;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.ITieTraceable;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.core.datanode.TieDataNodeCore;
import kd.wtc.wtes.business.core.datanode.TieDataNodeWrapper;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.log.TieLogFactory;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.Strings;

public class TieStepExecutorDefault<T extends ITieDataNode<T>>
extends AbstractTieExecutor<T>
implements TieStepExecutor<T> {
    private TieStepConfig stepConfig;
    private TiePhaseExecutor<T> phaseExecutor;
    private TieEvaluator<T, ? extends ITieTraceable<T>> evaluator;
    @Nullable
    private TieFilter<T> filter;
    private TieAlarm alarm;
    private TieDataNodeWrapper<T> dataNodeWrapper;
    private TieIdService idService;
    private TieStepIdentity stepIdentity;
    protected CalReportParaHolder reportPara;
    protected final Log log = TieLogFactory.getLog(this.getClass());

    @Override
    protected void init() throws TieExecutionException {
        super.init();
        Assert.nonNull(this.phaseExecutor, (String)"phaseExecutor");
        Assert.nonNull((Object)((Object)this.stepConfig), (String)"stepConfig");
        this.alarm = this.phaseExecutor.getChainExecutor().getAlarm();
        this.dataNodeWrapper = this.phaseExecutor.getChainExecutor().getDataNodeWrapper();
        this.idService = this.phaseExecutor.getChainExecutor().getIdService();
        TieStepExecutorUnitFactory<T> unitFactory = this.phaseExecutor.getChainExecutor().getStepExecutorUnitFactory();
        this.evaluator = unitFactory.createEvaluator(this.stepConfig);
        if (Strings.isNotBlank((String)this.stepConfig.getFilterName())) {
            this.filter = unitFactory.createFilter(this.stepConfig.getFilterName(), this.stepConfig.getTieUnitType());
        }
        this.stepIdentity = new TieStepIdentity(this.stepConfig.getId(), this.stepConfig.getBid(), this.stepConfig.getNumber(), this.phaseExecutor.getPhaseIdentity(), this.stepConfig.getStepEntryId(), this.stepConfig.getTieUnitType());
        this.stepIdentity.setName(this.stepConfig.getName());
    }

    @Override
    protected void doExecute() throws TieExecutionException {
        TieContext<T> context = this.makeContext();
        this.beforeExecute(context);
        this.doExecute(context);
        this.afterExecute(context);
    }

    private void doExecute(TieContext<T> context) throws TieExecutionException {
        TieDataResult<ITieTraceable<T>> evaluatorResult;
        if (this.filter == null) {
            evaluatorResult = this.evaluator.evaluate(context);
        } else {
            TieDataResult<T> filterResult = this.filter.filter(context);
            if (filterResult.hasMessage()) {
                this.tieMessages.add(filterResult.getMessage());
            }
            if (CollectionUtils.isEmpty(filterResult.getDataNodes())) {
                return;
            }
            evaluatorResult = this.evaluator.evaluate(context, filterResult.getDataNodes());
        }
        if (evaluatorResult.hasMessage()) {
            this.tieMessages.add(evaluatorResult.getMessage());
        }
        if (CollectionUtils.isNotEmpty(evaluatorResult.getDataNodes())) {
            this.addWrappedResultDataNodes(evaluatorResult.getDataNodes());
        }
    }

    private void addWrappedResultDataNodes(List<? extends ITieTraceable<T>> dataNodes) {
        ArrayList dataNodeCores = new ArrayList(dataNodes.size());
        long[] ids = this.idService.genLongIds(dataNodes.size());
        int index = 0;
        for (ITieTraceable<T> dataNode : dataNodes) {
            TieDataNodeCore<T> dataNodeCore = new TieDataNodeCore<T>();
            dataNodeCore.setId(ids[index++]);
            dataNodeCore.setData(dataNode);
            dataNodeCore.setStepIdentity(this.getStepIdentity());
            dataNodeCores.add(dataNodeCore);
            if (dataNode.parentDataNodes().isEmpty()) continue;
            List<TieDataNodeCore<T>> parentDataNodeCodes = this.dataNodeWrapper.unwrap(dataNode.parentDataNodes());
            for (TieDataNodeCore<T> parentDataNodeCore : parentDataNodeCodes) {
                parentDataNodeCore.setLeaf(false);
                if (!parentDataNodeCore.getStepIdentity().getPhaseIdentity().getNumber().equals(this.getStepIdentity().getPhaseIdentity().getNumber())) continue;
                parentDataNodeCore.setLeafInPhase(false);
            }
        }
        List<T> wrappedDataNodeCores = this.dataNodeWrapper.wrap(dataNodeCores);
        this.addResultDataNodes(wrappedDataNodeCores);
    }

    protected void beforeExecute(TieContext<T> context) throws TieExecutionException {
    }

    protected void afterExecute(TieContext<T> context) throws TieExecutionException {
    }

    protected TieContext<T> makeContext() {
        return new TieContextDefault(this);
    }

    @Override
    public String getExecutorTag() {
        return this.stepIdentity.getNumber();
    }

    @Override
    public String getExecutorName() {
        return this.stepConfig.getName();
    }

    @Override
    public void setPhaseExecutor(TiePhaseExecutor<T> phaseExecutor) {
        this.phaseExecutor = phaseExecutor;
    }

    @Override
    public void setStepConfig(TieStepConfig stepConfig) {
        this.stepConfig = stepConfig;
    }

    @Override
    public TieStepIdentity getStepIdentity() {
        return this.stepIdentity;
    }

    @Override
    public TiePhaseExecutor<T> getPhaseExecutor() {
        return this.phaseExecutor;
    }

    @Override
    public StepDataResult<T> getStepDataResult() {
        return new StepDataResultImpl(this.getResultDataNodes(), this.getResultStatus(), this.stepConfig.getId(), this.stepConfig.getNumber(), this.stepConfig.getName(), this.stepConfig.getStepEntryId());
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.alarm.alarm(msgLevel, msg);
    }

    private static class StepDataResultImpl<T extends ITieDataNode<T>>
    implements StepDataResult<T> {
        private final List<T> dataNodes;
        private final TieStatus resultStatus;
        private final long stepId;
        private final long stepEntryId;
        private final String number;
        private final String name;

        public StepDataResultImpl(List<T> dataNodes, TieStatus resultStatus, long stepId, String number, String name, Long stepEntryId) {
            this.dataNodes = dataNodes;
            this.resultStatus = resultStatus;
            this.stepId = stepId;
            this.number = number;
            this.name = name;
            this.stepEntryId = stepEntryId;
        }

        @Override
        public List<T> getDataNodes() {
            return this.dataNodes;
        }

        @Override
        public long getId() {
            return this.stepId;
        }

        @Override
        public long getStepEntryId() {
            return this.stepEntryId;
        }

        @Override
        public String getNumber() {
            return this.number;
        }

        @Override
        public TieStatus getResultStatus() {
            return this.resultStatus;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

