/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TieChainExecutor;
import kd.wtc.wtes.business.core.chain.TiePhaseExecutor;
import kd.wtc.wtes.business.core.chain.TieStepExecutor;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;

class WrappedDataPackage<T extends ITieDataNode<T>>
implements DataPackage<T> {
    private final TieChainExecutor<T> chainExecutor;
    private List<PhaseDataResult<T>> phaseDataResults;
    private List<T> allDataNodes;
    boolean emptyDataPackage = false;

    @Override
    public boolean isEmptyDataPackage() {
        return this.emptyDataPackage;
    }

    @Override
    public void setEmptyDataPackage(boolean isEmptyDataPackage) {
        this.emptyDataPackage = isEmptyDataPackage;
    }

    public WrappedDataPackage(TieChainExecutor<T> chainExecutor) {
        this.chainExecutor = chainExecutor;
    }

    @Override
    public List<T> getAllDataNodes() {
        if (this.isEmptyDataPackage()) {
            return Collections.emptyList();
        }
        if (this.allDataNodes == null) {
            this.allDataNodes = new LinkedList(this.chainExecutor.getResultDataNodes());
            if (this.chainExecutor.getResultStatus() == TieStatus.UNKNOWN) {
                this.appendExecutingResults();
            }
        }
        return this.allDataNodes;
    }

    private void appendExecutingResults() {
        TiePhaseExecutor<T> lastPhase;
        List<TiePhaseExecutor<T>> phaseExecutors = this.chainExecutor.getExecutedExecutors();
        if (!phaseExecutors.isEmpty() && (lastPhase = phaseExecutors.get(phaseExecutors.size() - 1)).getResultStatus() == TieStatus.UNKNOWN) {
            this.allDataNodes.addAll(lastPhase.getResultDataNodes());
        }
    }

    @Override
    public List<PhaseDataResult<T>> getPhaseDataResults() {
        if (this.isEmptyDataPackage()) {
            return Collections.emptyList();
        }
        if (this.phaseDataResults == null) {
            this.phaseDataResults = this.chainExecutor.getExecutedExecutors().stream().map(PhaseDataResultDefault::new).collect(Collectors.toList());
        }
        return this.phaseDataResults;
    }

    @Override
    public String getVersion() {
        return this.chainExecutor.getTieRequest().getVersion();
    }

    @Override
    public long getAttPersonId() {
        return this.chainExecutor.getAttSubjectEntry().getAttPersonId();
    }

    @Override
    public LocalDate getChainDate() {
        return this.chainExecutor.getChainDate();
    }

    @Override
    public TieStatus getResultStatus() {
        return this.chainExecutor.getResultStatus();
    }

    @Override
    public TieSchemeIdentity getTieSchemeIdentity() {
        return this.chainExecutor.getSchemeIdentity();
    }

    public String toString() {
        return "DataPackage{version=" + this.getVersion() + ", attPersonId=" + this.getAttPersonId() + ", chainDate=" + this.getChainDate() + ", phaseDataResults=" + this.getPhaseDataResults() + ", tieSchemeNumber=" + this.getTieSchemeIdentity().getNumber() + '}';
    }

    private static class StepDataResultDefault<T extends ITieDataNode<T>>
    implements StepDataResult<T> {
        TieStepExecutor<T> stepExecutor;

        public StepDataResultDefault(TieStepExecutor<T> stepExecutor) {
            this.stepExecutor = stepExecutor;
        }

        @Override
        public List<T> getDataNodes() {
            return this.stepExecutor.getResultDataNodes();
        }

        @Override
        public long getId() {
            return this.stepExecutor.getStepIdentity().getId();
        }

        @Override
        public long getStepEntryId() {
            return this.stepExecutor.getStepIdentity().getStepEntryId();
        }

        @Override
        public String getNumber() {
            return this.stepExecutor.getStepIdentity().getNumber();
        }

        @Override
        public String getName() {
            return this.stepExecutor.getExecutorName();
        }

        @Override
        public TieStatus getResultStatus() {
            return this.stepExecutor.getResultStatus();
        }

        public String toString() {
            return "StepDataResultDefault{id=" + this.getId() + ",number=" + this.getNumber() + ",dataNodes=" + this.getDataNodes() + '}';
        }
    }

    private static class PhaseDataResultDefault<T extends ITieDataNode<T>>
    implements PhaseDataResult<T> {
        TiePhaseExecutor<T> phase;
        List<StepDataResult<T>> stepDataResults;

        PhaseDataResultDefault(TiePhaseExecutor<T> phase) {
            this.phase = phase;
        }

        @Override
        public List<StepDataResult<T>> getStepDataResults() {
            if (this.stepDataResults == null) {
                this.stepDataResults = this.phase.getExecutedExecutors().stream().map(StepDataResultDefault::new).collect(Collectors.toList());
            }
            return this.stepDataResults;
        }

        @Override
        public String getNumber() {
            return this.phase.getPhaseIdentity().getNumber();
        }

        @Override
        public String getName() {
            return this.phase.getExecutorName();
        }

        @Override
        public Long getId() {
            return this.phase.getPhaseIdentity().getId();
        }

        @Override
        public TieStatus getResultStatus() {
            return this.phase.getResultStatus();
        }

        public String toString() {
            return "PhaseDataResultDefault{phaseNumber=" + this.getNumber() + ", getDataNodes=" + this.getStepDataResults() + '}';
        }
    }
}

