/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.engine;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.threads.ThreadPools;
import kd.sdk.wtc.wtes.business.tie.core.init.AfterTieAllParamInitEvent;
import kd.sdk.wtc.wtes.business.tie.core.init.TieParamInitExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.init.TieRequestExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.report.TieReportDao;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.attperiod.SummaryDataProvider;
import kd.wtc.wtes.business.core.AbstractTieRunner;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.TieException;
import kd.wtc.wtes.business.core.TieInterruptingException;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.TieTerminable;
import kd.wtc.wtes.business.core.chain.TieIdService;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactory;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.TieDataNodeWrapper;
import kd.wtc.wtes.business.core.drouter.DataPackageRouter;
import kd.wtc.wtes.business.core.drouter.DataPackageRouterFactory;
import kd.wtc.wtes.business.core.engine.TieEngine;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.core.engine.TieEngineCompletedCallback;
import kd.wtc.wtes.business.core.engine.TieLine;
import kd.wtc.wtes.business.core.engine.TieLineDefault;
import kd.wtc.wtes.business.core.engine.TieRangeChecker;
import kd.wtc.wtes.business.core.exporter.ITieExporter;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.core.init.InitParamRequest;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.core.validator.ValidatorExecutor;
import kd.wtc.wtes.business.exporter.TieExporterStdImpl;
import kd.wtc.wtes.business.service.ICalFinishAfterProcessService;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.business.storage.DataPackageStoreResult;
import kd.wtc.wtes.business.storage.VersionDataPackageStore;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.LogUtils;
import kd.wtc.wtp.business.formula.adapt.FormulaService;

public abstract class AbstractTieEngine<T extends ITieDataNode<T>>
extends AbstractTieRunner
implements TieEngine<T> {
    private TieRequest request;
    protected DataPackageRouterFactory<T> dataPackageRouterFactory;
    protected ITieExporter exporter;
    private TieEngineCompletedCallback engineCompletedCallback;
    private final Map<String, Object> engineVariable = new ConcurrentHashMap<String, Object>(8);
    private final Map<String, Object> initParams = new HashMap<String, Object>(16);
    private List<AttSubject> attSubjects;
    private List<List<TieParamInitializer>> initialises;
    private TieRangeChecker rangeChecker;
    private TieDataNodeWrapper<T> dataNodeWrapper;
    private TieIdService idService;
    private TieStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private ValidatorExecutor validatorExecutor;
    private ITieSchemeService tieSchemeService;
    static final int DEFAULT_INIT_POOL_SIZE = 2;
    static final int INIT_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("tie.init.pool.size", 2);
    static final String DEFAULT_INIT_POOL_NAME = "TiInitPool";
    static final String INIT_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("tie.init.pool.name", "TiInitPool");
    protected static final ExecutorService INIT_EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)INIT_POOL_NAME, (int)INIT_POOL_SIZE);

    @Override
    protected void beforeRun() throws TieException, InterruptedException {
        super.beforeRun();
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        DataPackageStoreManager instance = DataPackageStoreManager.getInstance();
        TieRequest request = this.getRequest();
        String version = request.getVersion();
        int shardingIndex = request.getShardingIndex();
        VersionDataPackageStore versionDataPackageStore = instance.getVersionDataPackageStore(version, shardingIndex);
        try (Span storeBatchSpan = TaskTracer.newSpan((String)CalcReportConstants.STORE_BATCH_TIME);){
            Map<String, Object> costData = versionDataPackageStore.getCostData();
            Date startDate = new Date((Long)costData.get("startTime"));
            storeBatchSpan.startTime(WTCDateUtils.toLocalDateTime((Date)startDate));
            storeBatchSpan.durationInMills(System.currentTimeMillis() - startDate.getTime());
            storeBatchSpan.info(TieReportKDStrings.STORE_BATCH_NUM.loadKDString(), () -> String.valueOf(costData.get("storeBatchNum")));
            storeBatchSpan.info(TieReportKDStrings.STORE_TOTAL_COUNT.loadKDString(), () -> String.valueOf(costData.get("storeTotalCount")));
        }
        instance.clearVersionStoreInstance(version, shardingIndex);
    }

    @Override
    protected void init() throws TieException, InterruptedException {
        super.init();
        this.checkArgs();
        try (Span initSpan = TaskTracer.newSpan((String)CalcReportConstants.PARAM_INIT);){
            this.rangeChecker.setTieRequest(this.request);
            this.rangeChecker.check();
            this.attSubjects = this.rangeChecker.getAttSubjects();
            initSpan.info(TieReportKDStrings.ATT_SUBJECTS_NUM.loadKDString(), () -> String.valueOf(this.attSubjects.size()));
            initSpan.info(TieReportKDStrings.EXCLUDE_ATT_SUBJECTS_NUM.loadKDString(), () -> String.valueOf(this.rangeChecker.getAttExcludeSubject().size()));
            initSpan.info(CalcReportConstants.EXCLUDE_MESSAGE, () -> this.rangeChecker.getExcludeMessage());
            this.exporter.setTieRequest(this.request);
            this.exporter.setAttSubjects(this.attSubjects);
            this.exporter.setAttExcludeSubjects(this.rangeChecker.getAttExcludeSubject());
            if (this.exporter instanceof TieExporterStdImpl) {
                ((TieExporterStdImpl)this.exporter).setPersonRangeMap(this.rangeChecker.getPersonRangeMap());
            }
            if (CollectionUtils.isEmpty(this.attSubjects)) {
                this.alarm(TieMsgLevel.INFO, TieEngineErrorCodes.getNonPersonNeedToTie(), new Object[0]);
                String cancelMessage = TieEngineErrorCodes.getNonPersonNeedToTie().getMessage();
                if (null != this.rangeChecker.getExcludeMessage()) {
                    cancelMessage = cancelMessage + ":" + this.rangeChecker.getExcludeMessage();
                }
                throw new CancellationException(cancelMessage);
            }
            for (List<TieParamInitializer> list : this.initialises) {
                Map<String, Object> initParamsTemp = this.loadInitParam(list);
                this.initParams.putAll(initParamsTemp);
            }
            this.afterAllParamInit();
            this.exporter.setInitMap(this.initParams);
        }
    }

    protected Map<String, Object> loadInitParam(List<TieParamInitializer> initialises) throws TieException, InterruptedException {
        if (CollectionUtils.isEmpty(initialises)) {
            LogUtils.warning((Log)this.log, (ErrorCode)TieEngineErrorCodes.getNonParamInitializer(), (Object[])new Object[0]);
            this.alarm(TieMsgLevel.WARNING, TieEngineErrorCodes.getNonParamInitializer(), new Object[0]);
            return Collections.emptyMap();
        }
        InitParamRequest initRequest = this.initParamRequest();
        String initializerTags = initialises.stream().map(initializer -> initializer.category() + "->" + initializer.getClass().getName()).collect(Collectors.joining(","));
        this.log.debug("Trying to load params between [{},{}] with those initialises: {}", new Object[]{initRequest.getStartDate(), initRequest.getEndDate(), initializerTags});
        return this.loadInitParams(initialises, initRequest);
    }

    protected abstract Map<String, Object> loadInitParams(List<TieParamInitializer> var1, InitParamRequest var2) throws InterruptedException, TieException;

    protected void checkArgs() {
        Assert.nonNull((Object)this.request, (String)"tieRequest");
        Assert.nonNull((Object)this.rangeChecker, (String)"rangeChecker");
        Assert.nonNull(this.dataPackageRouterFactory, (String)"dataPackageRouterFactory");
        Assert.nonNull((Object)this.exporter, (String)"tieExporter");
        Assert.nonNull(this.dataNodeWrapper, (String)"dataNodeWrapper");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
        Assert.nonNull((Object)this.tieSchemeService, (String)"tieSchemeService");
    }

    protected TieLine<T> makeLine(AttSubject attSubject) {
        ITieLineExporter alarm = this.exporter.newLineExporter(attSubject);
        DataPackageRouter<T> dataPackageRouter = this.dataPackageRouterFactory.create();
        dataPackageRouter.setInitParams(this.initParams);
        dataPackageRouter.setTieRequest(this.request);
        dataPackageRouter.setAttSubject(attSubject);
        TieLine line = (TieLine)WTCAppContextHelper.getBean(TieLineDefault.class);
        line.setDataPackageRouter(dataPackageRouter);
        line.setEngineVariable(this.engineVariable);
        line.setLineExporter(alarm);
        line.setTieRequest(this.request);
        line.setDataNodeWrapper(this.dataNodeWrapper);
        line.setIdService(this.idService);
        line.setStepExecutorUnitFactory(this.stepExecutorUnitFactory);
        line.setInitParams(Collections.unmodifiableMap(this.initParams));
        line.setValidatorExecutor(this.validatorExecutor);
        line.setTieSchemeService(this.tieSchemeService);
        line.setAttSubject(attSubject);
        line.setRequestContext(this.getRequestContext());
        return line;
    }

    @Override
    protected void stateChanged(TieState oldState, TieState newState) {
        this.exporter.stateChanged(oldState, newState);
        if (newState.isTerminating()) {
            if (this.exporter instanceof TieTerminable) {
                ((TieTerminable)((Object)this.exporter)).terminate();
            }
            this.terminateRunningLines();
            this.terminateRunningInitializer();
        } else if (newState.isDone() && this.engineCompletedCallback != null) {
            this.engineCompletedCallback.completedCallback(new TieEngineCallbackEvent(null, null, this, null));
        }
    }

    protected abstract void terminateRunningLines();

    protected abstract void terminateRunningInitializer();

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.exporter.alarm(msgLevel, msg);
    }

    @Override
    public void setRequest(TieRequest request) {
        this.request = request;
    }

    @Override
    public void setDataPackageRouterFactory(DataPackageRouterFactory<T> dataPackageRouterFactory) {
        this.dataPackageRouterFactory = dataPackageRouterFactory;
    }

    @Override
    public void setExporter(ITieExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public void setCompletedCallback(TieEngineCompletedCallback terminatedCallback) {
        this.engineCompletedCallback = terminatedCallback;
    }

    public TieRequest getRequest() {
        return this.request;
    }

    @Override
    public ITieExporter getExporter() {
        return this.exporter;
    }

    @Override
    public DataPackageRouterFactory<T> getDataPackageRouterFactory() {
        return this.dataPackageRouterFactory;
    }

    public Map<String, Object> getEngineVariable() {
        return this.engineVariable;
    }

    @Override
    public void setInitialises(List<List<TieParamInitializer>> initialises) {
        this.initialises = initialises;
    }

    @Override
    public void setRangeChecker(TieRangeChecker rangeChecker) {
        this.rangeChecker = rangeChecker;
    }

    @Override
    protected String getRunnerTag() {
        return this.request.getVersion() + ".T." + this.request.getTaskId();
    }

    @Override
    public void setDataNodeWrapper(TieDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public void setIdService(TieIdService idService) {
        this.idService = idService;
    }

    @Override
    public void setStepExecutorUnitFactory(TieStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public ValidatorExecutor getValidatorExecutor() {
        return this.validatorExecutor;
    }

    @Override
    public void setValidatorExecutor(ValidatorExecutor validatorExecutor) {
        this.validatorExecutor = validatorExecutor;
    }

    @Override
    protected void validate() throws WtesException {
        super.validate();
        this.validatorExecutor.validateParams(this.request, this.engineVariable, this.initParams);
    }

    @Override
    public TieRequest getTieRequest() {
        return this.request;
    }

    @Override
    public void setTieSchemeService(ITieSchemeService tieSchemeService) {
        this.tieSchemeService = tieSchemeService;
    }

    @Override
    public List<AttSubject> getAttSubjects() {
        return WTCCollections.unmodifiableList(this.attSubjects);
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return this.exporter.getLastTieDateMap();
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getErrorDateMap() {
        return this.exporter.getErrorDateMap();
    }

    protected void addDataPackageReportNode(TieLine<T> currentLine) {
        DataPackageRouter<T> dataPackageRouter = currentLine.getDataPackageRouter();
        if (dataPackageRouter != null) {
            Map<String, Object> spanData = dataPackageRouter.getSpanData();
            try (Span dataPackageSpan = TaskTracer.newSpan((String)((String)spanData.get("spanName")));){
                dataPackageSpan.startTime(WTCDateUtils.toLocalDateTime((Date)new Date((Long)spanData.get("startTime"))));
                dataPackageSpan.durationInMills(((Long)spanData.get("duration")).longValue());
                dataPackageSpan.info(TieReportKDStrings.DATA_PACKAGE_COMMITTED.loadKDString(), () -> String.valueOf(spanData.get("committedNum")));
            }
        }
    }

    protected void reportProcess(int total, int finishedLine) throws TieInterruptingException {
        try {
            if (total == finishedLine) {
                this.checkTimeOut();
                WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)this.request.getSubTaskId(), (int)80);
                return;
            }
            int processLimit = total / 16;
            if (processLimit < 5) {
                processLimit = 5;
            }
            if (finishedLine % processLimit == 0) {
                this.checkTimeOut();
                int multiply = new BigDecimal(finishedLine).divide(new BigDecimal(total), 2, 5).multiply(new BigDecimal("80")).intValue();
                WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)this.request.getSubTaskId(), (int)multiply);
            }
        }
        catch (TieInterruptingException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.warn("[TIE] reportProgress error,total={},finishedLine={}", new Object[]{total, finishedLine, e});
        }
    }

    protected void checkTimeOut() throws TieInterruptingException {
        boolean stop = WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)this.request.getSubTaskId());
        if (stop) {
            this.log.warn("tie task TimeOut,stop task");
            throw new TieInterruptingException();
        }
    }

    protected void waitStoreFinished() {
        TieRequest request = this.getRequest();
        String version = request.getVersion();
        int shardingIndex = request.getShardingIndex();
        DataPackageStoreManager instance = DataPackageStoreManager.getInstance();
        VersionDataPackageStore versionDataPackageStore = instance.getVersionDataPackageStore(version, shardingIndex);
        List<Future<DataPackageStoreResult>> storeResult = versionDataPackageStore.getStoreResult();
        String key = RequestContext.get().getAccountId() + '_' + version + '_' + shardingIndex;
        this.log.debug("waitStoreFinished storeResult key {} num {}", (Object)key, (Object)storeResult.size());
        try {
            int failSize = 0;
            StringBuilder failMsg = new StringBuilder();
            for (Future<DataPackageStoreResult> future : storeResult) {
                DataPackageStoreResult dataPackageStoreResult = future.get();
                if (dataPackageStoreResult.isSuccess()) continue;
                this.exporter.updateSubErrorResult(dataPackageStoreResult.getAttPersonIds(), ResManager.loadKDString((String)"\u6838\u7b97\u8f6c\u50a8\u8282\u70b9\u5f02\u5e38\u3002", (String)"AbstractTieEngine_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
                ++failSize;
                failMsg.append(dataPackageStoreResult.getFailMsg());
            }
            if (failSize != 0) {
                throw new KDBizException(new ErrorCode("500", failMsg.toString()), new Object[0]);
            }
        }
        catch (Exception ex) {
            this.log.warn("store fail", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", "to store is fail"), new Object[0]);
        }
    }

    protected void storeLastDataPackage() {
        ICalFinishAfterProcessService tieEngineCompletedStoreCallback = (ICalFinishAfterProcessService)WTCAppContextHelper.getBean((String)"kd.wtc.wtes.business.storage.TieEngineCompletedStoreCallback", ICalFinishAfterProcessService.class);
        tieEngineCompletedStoreCallback.completedCallback(new TieEngineCallbackEvent(null, null, this, null));
    }

    @Override
    public void setReportDao(TieReportDao reportDao) {
    }

    @Override
    protected void beforeDoRun() {
        this.doCalDataClean(this.getAttSubjects(), this.getRequest().getVersion());
    }

    @Override
    protected void doRunAfter() {
        SummaryDataProvider summaryDataProvider = new SummaryDataProvider();
        Map<String, Object> initParams = this.getInitParams();
        FormulaService formulaService = (FormulaService)initParams.get("ATT_FOUMULA_INSTANCE");
        TieEngineCallbackEvent tieEngineCallbackEvent = new TieEngineCallbackEvent(null, summaryDataProvider, this, formulaService);
        this.doCalFinishAfterProcess(tieEngineCallbackEvent);
    }

    protected InitParamRequest initParamRequest() {
        TieRequest tieRequest = this.getRequest();
        LocalDate initStartDate = tieRequest.getStartDate();
        LocalDate initEndDate = tieRequest.getEndDate();
        List<AttSubject> attSubjects = this.rangeChecker.getAttSubjects();
        for (AttSubject attSubject : attSubjects) {
            if (null == initStartDate || initStartDate.isAfter(attSubject.getStartDate())) {
                initStartDate = attSubject.getStartDate();
            }
            if (null != initEndDate && !initEndDate.isBefore(attSubject.getEndDate())) continue;
            initEndDate = attSubject.getEndDate();
        }
        WTCAssert.nonNull((Object)initStartDate, (String)"initStartDate");
        WTCAssert.nonNull((Object)initEndDate, (String)"initEndDate");
        InitParamRequest initRequest = new InitParamRequest(tieRequest.getAttPersonIds(), initStartDate.plusDays(-2L), initEndDate.plusDays(2L), tieRequest, attSubjects);
        initRequest.putInitParams(this.initParams);
        return initRequest;
    }

    private void afterAllParamInit() {
        InitParamRequest initParamRequest = this.initParamRequest();
        WTCPluginProxyFactory.create(TieParamInitExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.core.init.TieParamInitExtPlugin").invokeReplace(instance -> {
            AfterTieAllParamInitEvent tieInitExpParam = new AfterTieAllParamInitEvent((TieRequestExt)initParamRequest, Collections.unmodifiableMap(this.initParams));
            instance.afterAllParamInit(tieInitExpParam);
            Object initDataExt = tieInitExpParam.getInitDataExt();
            if (initDataExt != null) {
                this.initParams.put("TIE_EXT_PARAM", initDataExt);
            }
        });
    }
}

