/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.engine;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.report.calreport.ReportNode;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.attperiod.SummaryDataProvider;
import kd.wtc.wtes.business.core.TieMessage;
import kd.wtc.wtes.business.core.TieObject;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.engine.TieEngine;
import kd.wtc.wtp.business.formula.adapt.FormulaService;

@TieObject
public class TieEngineCallbackEvent {
    private final TieState state;
    private final ReportNode reportNode;
    private final TieEngine<?> engine;
    private final Map<AttSubject.AttFileBo, LocalDate> lastTieDateMap;
    private final Map<AttSubject.AttFileBo, LocalDate> errorDateMap;
    private final Map<String, Object> initParams;
    private final TieRequest request;
    protected final List<TieMessage> tieMessages = new LinkedList<TieMessage>();
    private final SummaryDataProvider summaryDataProvider;
    private final FormulaService formulaService;

    public TieEngineCallbackEvent(ReportNode reportNode, SummaryDataProvider summaryDataProvider, TieEngine<?> engine, FormulaService formulaService) {
        this.reportNode = reportNode;
        this.engine = engine;
        this.lastTieDateMap = engine.getLastTieDateMap();
        this.errorDateMap = engine.getErrorDateMap();
        this.initParams = engine.getInitParams();
        this.state = engine.getState();
        this.request = engine.getTieRequest();
        this.summaryDataProvider = summaryDataProvider;
        this.formulaService = formulaService;
    }

    public long getTaskId() {
        return this.request.getTaskId();
    }

    public long getSubTaskId() {
        return this.request.getSubTaskId();
    }

    public TieState getState() {
        return this.state;
    }

    public ReportNode getReportNode() {
        return this.reportNode;
    }

    @Deprecated
    public TieEngine<?> getEngine() {
        return this.engine;
    }

    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return this.lastTieDateMap;
    }

    public Map<AttSubject.AttFileBo, LocalDate> getErrorDateMap() {
        return this.errorDateMap;
    }

    public List<Long> getInvolvedAttPersonIds() {
        return this.lastTieDateMap.keySet().stream().map(attFileBo -> attFileBo.getAttSubject().getAttPersonId()).collect(Collectors.toList());
    }

    public List<Long> getInvolvedAttFileBoids() {
        return this.lastTieDateMap.keySet().stream().map(AttSubject.AttFileBo::getAttFileBoid).collect(Collectors.toList());
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public TieRequest getRequest() {
        return this.request;
    }

    public List<TieMessage> getTieMessages() {
        return this.tieMessages;
    }

    public SummaryDataProvider getSummaryDataProvider() {
        return this.summaryDataProvider;
    }

    public FormulaService getFormulaService() {
        return this.formulaService;
    }
}

