/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.engine;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.TieException;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.engine.AbstractTieEngine;
import kd.wtc.wtes.business.core.engine.TieLine;
import kd.wtc.wtes.business.core.engine.TieParamInitExecutor;
import kd.wtc.wtes.business.core.init.InitParamRequest;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.storage.PriorityExecutorService;

public class TieEngineSerialized<T extends ITieDataNode<T>>
extends AbstractTieEngine<T> {
    private volatile TieLine<T> currentLine;
    private List<Future<Tuple<String, InitParamResult>>> initFutures;
    static final String DEFAULT_INIT_POOL_NAME = "TiInitPool";
    private boolean usePriorityService = WTCAppContextHelper.getProjectParams().getBoolean("tie.init.pool.usepriority", Boolean.valueOf(false));

    @Override
    protected Map<String, Object> loadInitParams(List<TieParamInitializer> initialises, InitParamRequest initRequest) throws InterruptedException, TieException {
        RequestContext requestContext = RequestContext.get();
        List tieParamInitExecutors = initialises.stream().map(initializer -> TaskTracer.wrap((Callable)new TieParamInitExecutor((TieParamInitializer)initializer, initRequest))).collect(Collectors.toList());
        this.initFutures = this.usePriorityService ? PriorityExecutorService.getInitInstance().submitAll(tieParamInitExecutors, this.getTieRequest().getTaskPriority()) : INIT_EXECUTOR_SERVICE.invokeAll(tieParamInitExecutors);
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Future<Tuple<String, InitParamResult>> future : this.initFutures) {
            Tuple<String, InitParamResult> tuple;
            this.checkInterrupt();
            try {
                tuple = future.get();
            }
            catch (ExecutionException e) {
                this.log.warn("[TIE] init error ", (Throwable)e);
                this.terminateRunningInitializer();
                throw new TieException(e.getCause(), TieEngineErrorCodes.getParamInitErr(), e.getCause().getMessage());
            }
            if (((InitParamResult)tuple.getValue()).hasParams()) {
                params.put((String)tuple.getKey(), ((InitParamResult)tuple.getValue()).getInitData());
            }
            if (!((InitParamResult)tuple.getValue()).hasMessage()) continue;
            this.exporter.alarm(((InitParamResult)tuple.getValue()).getMessage());
        }
        this.initFutures.clear();
        return params;
    }

    @Override
    protected void terminateRunningInitializer() {
        if (WTCCollections.isNotEmpty(this.initFutures)) {
            for (Future<Tuple<String, InitParamResult>> initFuture : this.initFutures) {
                initFuture.cancel(true);
            }
        }
    }

    @Override
    public TaskDesc getTaskDesc(TieRequest request) {
        return new TaskDesc("wtte_tie", request.getVersion(), request.getTaskId(), request.getSubTaskId(), 0L, request.getShardingIndex(), request.getCreateUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TieRequest request = this.getTieRequest();
        TaskDesc taskDesc = this.getTaskDesc(request);
        try (TaskTracer taskTracer = TaskTracer.makeTracer((TaskDesc)taskDesc);){
            Span rootSpan = TaskTracer.newRootSpan();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                    rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
                }
                rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
                rootSpan.close();
                throw throwable;
            }
            if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
            }
            rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
            rootSpan.close();
        }
    }

    @Override
    protected void doRun() throws TieException, InterruptedException {
        this.log.info("TieEngineSerialized_run");
        List<AttSubject> attSubjects = this.getAttSubjects();
        int size = attSubjects.size();
        int finishLine = 0;
        for (AttSubject attSubject : attSubjects) {
            Span lineSpan = TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_PIPELINE + "[" + attSubject.getAttPersonId() + "]"));
            Throwable throwable = null;
            try {
                lineSpan.info(CalcReportConstants.CALCULATE_DATE_RANGER, (Object)(attSubject.getStartDate() + "," + attSubject.getEndDate()));
                this.checkInterrupt();
                this.currentLine = this.makeLine(attSubject);
                this.currentLine.run();
                this.addDataPackageReportNode(this.currentLine);
                if (this.currentLine.isError()) {
                    this.exporter.errorOneLine(attSubject);
                } else if (this.currentLine.isSuccess()) {
                    this.exporter.finishOneLine(attSubject);
                }
                this.reportProcess(size, ++finishLine);
                if (this.currentLine.isError()) {
                    lineSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.currentLine.getExceptionStr());
                }
                lineSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.currentLine.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lineSpan == null) continue;
                if (throwable != null) {
                    try {
                        lineSpan.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lineSpan.close();
            }
        }
        this.log.info("TieEngineSerialized_run end");
        this.storeLastDataPackage();
        this.log.info("TieEngineSerialized_run orgId{}", (Object)RequestContext.get().getOrgId());
        this.waitStoreFinished();
    }

    @Override
    protected void terminateRunningLines() {
        TieLine<T> currentLine = this.currentLine;
        if (currentLine != null) {
            currentLine.terminate();
        }
    }
}

