/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.engine;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.AbstractTieRunner;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.TieException;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.TieTerminable;
import kd.wtc.wtes.business.core.chain.TieChainExecutor;
import kd.wtc.wtes.business.core.chain.TieIdService;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactory;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.TieDataNodeWrapper;
import kd.wtc.wtes.business.core.drouter.DataPackageRouter;
import kd.wtc.wtes.business.core.engine.TieEngineKDStrings;
import kd.wtc.wtes.business.core.engine.TieLine;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.validator.ValidatorExecutor;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.std.chain.TieChainExecutorStd;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;

public class TieLineDefault<T extends ITieDataNode<T>>
extends AbstractTieRunner
implements TieLine<T> {
    private TieRequest tieRequest;
    private Map<String, Object> engineVariable;
    private ITieLineExporter lineExporter;
    private DataPackageRouter<T> dataPackageRouter;
    private Map<String, Object> lineVariable;
    private Map<String, Object> initParams;
    private TieDataNodeWrapper<T> dataNodeWrapper;
    private TieIdService idService;
    private TieStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private static final int VARIABLE_SIZE = 32;
    private ValidatorExecutor validatorExecutor;
    private ITieSchemeService tieSchemeService;
    private AttSubject attSubject;

    @Override
    public TieRequest getTieRequest() {
        return this.tieRequest;
    }

    @Override
    public String getExceptionStr() {
        return this.exceptionStr;
    }

    @Override
    protected void init() {
        Assert.nonNull((Object)this.tieRequest, (String)"tieRequest");
        Assert.nonNull(this.engineVariable, (String)"engineVariable");
        Assert.nonNull((Object)this.lineExporter, (String)"lineExporter");
        Assert.nonNull(this.dataPackageRouter, (String)"dataPackageRouter");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
        Assert.nonNull(this.initParams, (String)"initParams");
        Assert.nonNull((Object)this.tieSchemeService, (String)"tieSchemeService");
        Assert.nonNull((Object)this.attSubject, (String)"attSubject");
        this.lineVariable = new HashMap<String, Object>(32);
    }

    @Override
    protected void doRun() throws TieException, InterruptedException {
        int executedChainCount = 0;
        for (AttSubject.AttSubjectEntry attSubjectEntry : this.attSubject) {
            this.checkInterrupt();
            TieChainExecutor<T> chain = this.makeChain(attSubjectEntry);
            this.tieChainValidate(attSubjectEntry);
            this.executeChain(chain);
            if (chain.isSuccess()) {
                DataPackage<T> dataPackage = this.makeDataPackage(chain);
                this.commitDataPackage(dataPackage);
                this.finishOneChain(attSubjectEntry);
            } else {
                if (chain.isError()) {
                    this.makeEmptyDataPackageAndCommitItFrom(this.attSubject, executedChainCount);
                    this.errorOneChain(attSubjectEntry);
                    throw new TieException(TieEngineErrorCodes.getLineBreak(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)chain.getChainDate())));
                }
                DataPackage<T> emptyDataPackage = this.makeEmptyDataPackage(chain);
                this.commitDataPackage(emptyDataPackage);
                if (chain.isExclusion()) {
                    this.finishOneChain(attSubjectEntry);
                }
                this.lineExporter.alarm(TieMsgLevel.WARNING, TieEngineKDStrings.NULL_DATA_PACKAGE.loadKDString(new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)chain.getChainDate()))}));
            }
            ++executedChainCount;
        }
    }

    private void tieChainValidate(AttSubject.AttSubjectEntry attSubjectEntry) {
        this.validatorExecutor.validateTieChain(this.tieRequest, this.engineVariable, this.initParams, this.attSubject, this.lineVariable, attSubjectEntry);
    }

    protected void makeEmptyDataPackageAndCommitItFrom(AttSubject attSubject, int from) throws TieException {
        int idx = 0;
        for (AttSubject.AttSubjectEntry attSubjectEntry : attSubject) {
            if (idx++ < from) continue;
            TieChainExecutor<T> chain = this.makeChain(attSubjectEntry);
            DataPackage<T> emptyDataPackage = this.makeEmptyDataPackage(chain);
            this.commitDataPackage(emptyDataPackage);
        }
    }

    protected DataPackage<T> makeEmptyDataPackage(TieChainExecutor<T> chain) throws TieException {
        DataPackage<T> dataPackage = this.makeDataPackage(chain);
        dataPackage.setEmptyDataPackage(true);
        return dataPackage;
    }

    protected void errorOneChain(AttSubject.AttSubjectEntry attSubjectEntry) throws TieException {
        try {
            this.lineExporter.errorOneChain(attSubjectEntry);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TieException(e, TieEngineErrorCodes.getExporterLineErr(), attSubjectEntry.getAttFileBoid());
        }
    }

    protected DataPackage<T> makeDataPackage(TieChainExecutor<T> chain) throws TieException {
        try {
            return chain.makeDataPackage();
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TieException(e, TieEngineErrorCodes.getChainExecutorErr(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)chain.getChainDate())));
        }
    }

    protected void finishOneChain(AttSubject.AttSubjectEntry attSubjectEntry) throws TieException {
        try {
            this.lineExporter.finishOneChain(attSubjectEntry);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TieException(e, TieEngineErrorCodes.getExporterErr(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)attSubjectEntry.getCurrentDate())));
        }
    }

    protected void commitDataPackage(DataPackage<T> dataPackage) throws TieException {
        try {
            this.dataPackageRouter.commit(dataPackage);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TieException(e, TieEngineErrorCodes.getDrouterErr(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)dataPackage.getChainDate())));
        }
    }

    protected void executeChain(TieChainExecutor<T> chain) throws TieException {
        Span chainSpan = TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_CHAIN + "[" + chain.getChainDate() + "]"));
        try {
            chain.execute();
            if (chain.getTieScheme() != null) {
                chainSpan.info(CalcReportConstants.CALCULATE_CHAIN_TIESCHEME, () -> chain.getTieScheme().getNumber());
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TieException(e, TieEngineErrorCodes.getChainExecutorErr(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)chain.getChainDate())));
        }
        finally {
            chainSpan.info(CalcReportConstants.CALCULATE_CHAIN_RESULT, () -> chain.isSuccess() ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED);
            chainSpan.close();
        }
    }

    @Override
    public void stateChanged(TieState oldState, TieState newState) {
        this.lineExporter.stateChanged(oldState, newState);
        if (newState.isTerminating()) {
            if (this.dataPackageRouter instanceof TieTerminable) {
                ((TieTerminable)((Object)this.dataPackageRouter)).terminate();
            }
        } else if (newState.isDone()) {
            this.dataPackageRouter.close();
        }
    }

    protected TieChainExecutor<T> makeChain(AttSubject.AttSubjectEntry attSubjectEntry) {
        AccountPlanData planData = (AccountPlanData)this.initParams.get("ACCOUNT_PLAN");
        TieScheme tieScheme = planData.getTieSchemeByDetailAndDate(attSubjectEntry.getCurrentDate());
        TieChainExecutor chainExecutor = (TieChainExecutor)WTCAppContextHelper.getBean(TieChainExecutorStd.class);
        chainExecutor.setChainDate(attSubjectEntry.getCurrentDate());
        chainExecutor.setEngineVariable(this.engineVariable);
        chainExecutor.setLineExporter(this.lineExporter);
        chainExecutor.setAttSubjectEntry(attSubjectEntry);
        chainExecutor.setLineVariable(this.lineVariable);
        chainExecutor.setTieRequest(this.tieRequest);
        chainExecutor.setTieScheme(tieScheme);
        chainExecutor.setDataNodeWrapper(this.dataNodeWrapper);
        chainExecutor.setIdService(this.idService);
        chainExecutor.setStepExecutorUnitFactory(this.stepExecutorUnitFactory);
        chainExecutor.setInitParams(this.initParams);
        return chainExecutor;
    }

    @Override
    public void setTieRequest(TieRequest tieRequest) {
        this.tieRequest = tieRequest;
    }

    @Override
    public void setEngineVariable(Map<String, Object> engineVariable) {
        this.engineVariable = engineVariable;
    }

    @Override
    public void setTieSchemeService(ITieSchemeService tieSchemeService) {
        this.tieSchemeService = tieSchemeService;
    }

    @Override
    public void setAttSubject(AttSubject attSubject) {
        this.attSubject = attSubject;
    }

    @Override
    public AttSubject getAttSubject() {
        return this.attSubject;
    }

    @Override
    public void setLineExporter(ITieLineExporter lineExporter) {
        this.lineExporter = lineExporter;
    }

    @Override
    public void setDataPackageRouter(DataPackageRouter<T> dataPackageRouter) {
        this.dataPackageRouter = dataPackageRouter;
    }

    @Override
    public void setDataNodeWrapper(TieDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public void setIdService(TieIdService idService) {
        this.idService = idService;
    }

    @Override
    public void setStepExecutorUnitFactory(TieStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.lineExporter.alarm(msgLevel, msg);
    }

    @Override
    protected String getRunnerTag() {
        return this.tieRequest.getVersion() + ".P." + this.attSubject.getAttPersonId();
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    public ValidatorExecutor getValidatorExecutor() {
        return this.validatorExecutor;
    }

    @Override
    public void setValidatorExecutor(ValidatorExecutor validatorExecutor) {
        this.validatorExecutor = validatorExecutor;
    }

    @Override
    public DataPackageRouter<T> getDataPackageRouter() {
        return this.dataPackageRouter;
    }

    @Override
    protected void validate() throws WtesException {
        super.validate();
        this.validatorExecutor.validateLine(this.tieRequest, this.engineVariable, this.initParams, this.attSubject, this.lineVariable);
    }

    @Override
    protected void doRunAfter() {
    }

    @Override
    protected void beforeDoRun() {
    }
}

