/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.scheme;

import java.util.List;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieScheme
extends AbstractTimeSeqVersion {
    private List<TiePhaseConfig> phaseProperties;
    private List<DecisionConfig> phaseDecisions;
    private Integer priority;
    private String accountType;
    private String accountMode;

    protected TieScheme(Builder<?, ?> builder) {
        super(builder);
        this.phaseProperties = ((Builder)builder).phaseProperties;
        this.phaseDecisions = ((Builder)builder).phaseDecisions;
        this.priority = ((Builder)builder).priority;
        this.accountType = ((Builder)builder).accountType;
        this.accountMode = ((Builder)builder).accountMode;
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(timeSeqInfo);
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(id, number);
    }

    public List<TiePhaseConfig> getPhaseProperties() {
        return CollectionUtils.unmodifiableList(this.phaseProperties);
    }

    public List<DecisionConfig> getPhaseDecisions() {
        return CollectionUtils.unmodifiableList(this.phaseDecisions);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountMode() {
        return this.accountMode;
    }

    public TiePhaseConfig firstPhaseProperties() {
        if (CollectionUtils.isEmpty(this.phaseProperties)) {
            return null;
        }
        return this.phaseProperties.get(0);
    }

    @Deprecated
    public void setPhaseProperties(List<TiePhaseConfig> phaseProperties) {
        this.phaseProperties = phaseProperties;
    }

    @Deprecated
    public void setPhaseDecisions(List<DecisionConfig> phaseDecisions) {
        this.phaseDecisions = phaseDecisions;
    }

    private static class BuilderImpl
    extends Builder<TieScheme, BuilderImpl> {
        protected BuilderImpl(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected BuilderImpl(long id, String number) {
            super(id, number);
        }

        protected BuilderImpl self() {
            return this;
        }

        protected TieScheme building() {
            return new TieScheme(this);
        }
    }

    public static abstract class Builder<E extends TieScheme, B extends Builder<E, B>>
    extends AbstractTimeSeqVersion.Builder<E, B> {
        private List<TiePhaseConfig> phaseProperties;
        private List<DecisionConfig> phaseDecisions;
        private Integer priority;
        private String accountType;
        private String accountMode;

        protected Builder(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected Builder(long id, String number) {
            super(id, number);
        }

        public B phaseProperties(List<TiePhaseConfig> phaseProperties) {
            this.phaseProperties = phaseProperties;
            return (B)((Object)((Builder)this.self()));
        }

        public B phaseDecisions(List<DecisionConfig> phaseDecisions) {
            this.phaseDecisions = phaseDecisions;
            return (B)((Object)((Builder)this.self()));
        }

        public B priority(Integer priority) {
            this.priority = priority;
            return (B)((Object)((Builder)this.self()));
        }

        public B accountType(String accountType) {
            this.accountType = accountType;
            return (B)((Object)((Builder)this.self()));
        }

        public B accountMode(String accountMode) {
            this.accountMode = accountMode;
            return (B)((Object)((Builder)this.self()));
        }

        public List<TiePhaseConfig> getPhaseProperties() {
            return this.phaseProperties;
        }

        public List<DecisionConfig> getPhaseDecisions() {
            return this.phaseDecisions;
        }

        public String getAccountType() {
            return this.accountType;
        }
    }
}

