/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.validator;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtes.business.core.validator.AbstractTieChainValidator;
import kd.wtc.wtes.business.core.validator.TieLineValidatorException;
import kd.wtc.wtes.business.core.validator.TieParamValidatorException;
import kd.wtc.wtes.business.init.LogicCardData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;

public class CardMatchValidator
extends AbstractTieChainValidator {
    @Override
    public void validate() throws TieParamValidatorException {
        LogicCardData logicCardData = (LogicCardData)this.initParams.get("LOGIC_CARD");
        Map<Long, Map<LocalDate, Boolean>> cardMatchMap = logicCardData.getCardMatchMap();
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        AttSubject.AttSubjectEntry attSubjectEntry = this.getAttSubjectEntry();
        long attPersonId = attSubjectEntry.getAttPersonId();
        LocalDate calDate = attSubjectEntry.getCurrentDate();
        LocalDate today = LocalDate.now();
        if (today.isBefore(calDate)) {
            return;
        }
        AttFileModel attFile = attFileCabinet.getByAttPersonIdAndDate(attPersonId, calDate);
        AttModeEnum attModeMust = attFile.getAttModeMust(calDate);
        if (AttModeEnum.NO_CARD == attModeMust) {
            return;
        }
        Map<LocalDate, Boolean> localDateBooleanMap = cardMatchMap.get(attPersonId);
        if (localDateBooleanMap == null) {
            throw new TieLineValidatorException(ResManager.loadKDString((String)"\u4eba\u5458\u5728\u8be5\u65e5\u671f\uff08{0}\uff09\u672a\u6267\u884c\u53d6\u5361\u5339\u914d\uff0c\u8bf7\u5148\u5b8c\u6210\u53d6\u5361\u5339\u914d\u3002", (String)"CardMatchValidator_0", (String)"wtc-wtes-business", (Object[])new Object[]{calDate}));
        }
        Boolean isCardMatch = localDateBooleanMap.get(calDate);
        if (isCardMatch == null || !isCardMatch.booleanValue()) {
            throw new TieLineValidatorException(ResManager.loadKDString((String)"\u4eba\u5458\u5728\u8be5\u65e5\u671f\uff08{0}\uff09\u672a\u6267\u884c\u53d6\u5361\u5339\u914d\uff0c\u8bf7\u5148\u5b8c\u6210\u53d6\u5361\u5339\u914d\u3002", (String)"CardMatchValidator_0", (String)"wtc-wtes-business", (Object[])new Object[]{calDate}));
        }
    }
}

