/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.validator;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.validator.AbstractTieChainValidator;
import kd.wtc.wtes.business.core.validator.TieLineValidatorException;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;
import kd.wtc.wtes.common.lang.WtesException;

public class ShiftTableValidator
extends AbstractTieChainValidator {
    @Override
    public void validate() {
        ShiftTable shiftTable = (ShiftTable)this.initParams.get("ROSTER");
        AttSubject.AttSubjectEntry attSubjectEntry = this.getAttSubjectEntry();
        long attPersonId = attSubjectEntry.getAttPersonId();
        LocalDate calDate = attSubjectEntry.getCurrentDate();
        ShiftTableSingle shiftTableSingle = shiftTable.getByAttPersonId(attPersonId);
        if (null == shiftTableSingle || null == shiftTableSingle.getRosterSpecMap()) {
            throw new WtesException(TieEngineErrorCodes.getLineValidateErr(), new Object[]{ValiteKDStringUtil.noShift(calDate)});
        }
        Roster roster = shiftTableSingle.getRoster(calDate);
        if (null == roster || null == roster.getShiftSpec()) {
            throw new TieLineValidatorException(ValiteKDStringUtil.noShift(calDate));
        }
        if (null == roster.getHoliday()) {
            throw new TieLineValidatorException(ResManager.loadKDString((String)"\u8003\u52e4\u4eba\u201c{0}\u201d\u5728[{1}]\u73ed\u6b21\u7f3a\u5c11holiday\u5b57\u6bb5\u3002", (String)"ShiftTableSingleCompleteValidator_5", (String)"wtc-wtes-business", (Object[])new Object[]{attPersonId, calDate}));
        }
    }
}

