/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.validator;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.validator.AbstractTieChainValidator;
import kd.wtc.wtes.business.core.validator.AbstractTieValidator;
import kd.wtc.wtes.business.core.validator.TieParamValidatorException;
import kd.wtc.wtes.business.log.TieLogFactory;

public abstract class ValidatorExecutor {
    protected final Log log = TieLogFactory.getLog(this.getClass());

    public void validateParams(TieRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams) throws TieParamValidatorException {
        this.doValidate(request, engineVariable, initParams, null, null, this.getParaValidators());
    }

    public void validateLine(TieRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttSubject attSubject, Map<String, Object> lineVariable) throws TieParamValidatorException {
        this.doValidate(request, engineVariable, initParams, attSubject, lineVariable, this.getLineValidators());
    }

    public void validateTieChain(TieRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttSubject attSubject, Map<String, Object> lineVariable, AttSubject.AttSubjectEntry attSubjectEntry) throws TieParamValidatorException {
        this.doTieChainValidate(request, engineVariable, initParams, attSubject, lineVariable, this.getTieChainValidators(), attSubjectEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate(TieRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttSubject attSubject, Map<String, Object> lineVariable, List<AbstractTieValidator> validators) {
        for (AbstractTieValidator validator : validators) {
            validator.initValidator(request, engineVariable, initParams, attSubject, lineVariable);
            long startTime = System.nanoTime();
            try {
                validator.validate();
            }
            finally {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("#TIE# [validatorName {}] [Elapsed {}] #TIE#", (Object)validator.getClass().getName(), (Object)(System.nanoTime() - startTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTieChainValidate(TieRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttSubject attSubject, Map<String, Object> lineVariable, List<AbstractTieChainValidator> validators, AttSubject.AttSubjectEntry attSubjectEntry) {
        for (AbstractTieChainValidator validator : validators) {
            validator.initValidator(request, engineVariable, initParams, attSubject, lineVariable, attSubjectEntry);
            long startTime = System.nanoTime();
            try {
                validator.validate();
            }
            finally {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("#TIE# [validatorName {}] [Elapsed {}] #TIE#", (Object)validator.getClass().getName(), (Object)(System.nanoTime() - startTime));
            }
        }
    }

    public abstract List<AbstractTieValidator> getParaValidators();

    public abstract List<AbstractTieValidator> getLineValidators();

    public abstract List<AbstractTieChainValidator> getTieChainValidators();

    public abstract List<String> getTieParamBeanNames(String var1);

    public abstract List<AbstractTieValidator> getValidators(List<String> var1, Class<AbstractTieValidator> var2);

    public abstract List<AbstractTieChainValidator> getChainValidators(List<String> var1, Class<AbstractTieChainValidator> var2);
}

