/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.drouter;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.business.std.datanode.DataPackageStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.drouter.DataPackageRouterStd;

public abstract class AbstractDataPackageRouterStd
implements DataPackageRouterStd {
    private TieRequestStd tieRequestStd;
    private Map<String, Object> initParams;
    private AttSubject attSubject;
    private long elapsedInNano;
    private int committedNum;
    private long firstStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(DataPackage<TieDataNodeStd> dataPackage) {
        long startTime = System.nanoTime();
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        try {
            this.commitStd((DataPackageStd)dataPackage);
        }
        finally {
            this.elapsedInNano += System.nanoTime() - startTime;
            ++this.committedNum;
        }
    }

    @Override
    public void setTieRequestStd(TieRequestStd tieRequestStd) {
        this.tieRequestStd = tieRequestStd;
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    public TieRequestStd getTieRequestStd() {
        return this.tieRequestStd;
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public <T> T getInitParam(String key) {
        return (T)this.getInitParams().get(key);
    }

    @Override
    public void setAttSubject(AttSubject attSubject) {
        this.attSubject = attSubject;
    }

    public AttSubject getAttSubject() {
        return this.attSubject;
    }

    @Override
    public Map<String, Object> getSpanData() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("spanName", TieReportKDStrings.DATA_PACKAGE_ROUTER.loadKDString());
        if (this.firstStartTime == 0L) {
            map.put("startTime", new Date().getTime());
            map.put("duration", 1L);
        } else {
            map.put("startTime", this.firstStartTime);
            map.put("duration", WTCDateUtils.nano2millis((long)this.elapsedInNano));
        }
        map.put("committedNum", this.committedNum);
        return map;
    }
}

