/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.drouter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.jsondto.AccountPlanJsonDto;
import kd.wtc.wtbs.common.model.jsondto.AttitemJsonDto;
import kd.wtc.wtbs.common.model.jsondto.AttitemTrimJsonDto;
import kd.wtc.wtbs.common.model.jsondto.BucketJsonDto;
import kd.wtc.wtbs.common.model.jsondto.PhaseJsonDto;
import kd.wtc.wtbs.common.model.jsondto.StepJsonDto;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.drouter.AbstractDataPackageRouterStd;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.StoreExtendDataInfo;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.DataPackageStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.util.TieContextUtil;
import kd.wtc.wtes.common.enums.AccountStageTypeEnum;
import kd.wtc.wtes.common.enums.AccountStepEnum;
import kd.wtc.wtes.common.enums.CalculRuleTypeEnum;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public class AttRecordRouter
extends AbstractDataPackageRouterStd {
    private static final Log log = LogFactory.getLog(AttRecordRouter.class);
    private static final String ROSTER = "ROSTER";
    private static final String ADD = "+";

    @Override
    public void commitStd(DataPackageStd dataPackage) {
        TieRequestStd tieRequestStd = this.getTieRequestStd();
        boolean saveEvaluationDetail = tieRequestStd.isSaveEvaluationDetail();
        DataPackageInfo packageInfo = this.makePackInfoByOriPackage(dataPackage);
        packageInfo.setInitParams(this.getInitParams());
        packageInfo.setVersion(tieRequestStd.getVersion());
        packageInfo.setTaskId(tieRequestStd.getTaskId());
        packageInfo.setCalculateDate(WTCDateUtils.toDate((LocalDateTime)this.getTieRequestStd().getCreateTime()));
        packageInfo.setCalculatorId(tieRequestStd.getCreateUserId());
        packageInfo.setPriority(tieRequestStd.getTaskPriority());
        packageInfo.setShardingIndex(tieRequestStd.getShardingIndex());
        packageInfo.setSubTaskId(tieRequestStd.getSubTaskId());
        packageInfo.setIncrDecrItem(dataPackage.getAttIncrDecrList());
        List<TieDataNodeStd> dataNodes = dataPackage.getAllDataNodes();
        StoreExtendDataInfo storeExtendDataInfo = this.makeStoreExtendDataInfoByOriPackage(dataPackage);
        List<AttRecordModel> recordModelList = this.geneRecordModelListByDateNodes(dataNodes, dataPackage.getAttPersonId(), dataPackage.getChainDate());
        AccountPlanJsonDto phaseJsonDto = null;
        if (saveEvaluationDetail) {
            phaseJsonDto = this.transformerJsonDto(dataPackage);
        }
        DataPackageStoreManager dataPackageStoreManager = DataPackageStoreManager.getInstance();
        RecordAndPackageWrapper recordAndPackageWrapper = new RecordAndPackageWrapper(recordModelList, packageInfo, storeExtendDataInfo, phaseJsonDto);
        dataPackageStoreManager.store(recordAndPackageWrapper);
    }

    private StoreExtendDataInfo makeStoreExtendDataInfoByOriPackage(DataPackageStd dataPackage) {
        StoreExtendDataInfo storeExtendDataInfo = new StoreExtendDataInfo();
        storeExtendDataInfo.setStartDate(dataPackage.getStartDate());
        storeExtendDataInfo.setEndDate(dataPackage.getEndDate());
        HashMap extendParams = Maps.newHashMapWithExpectedSize((int)16);
        List list = dataPackage.getDataNodesByPhaseNumber(AccountStageTypeEnum.EX_1050_S.getPhaseCode());
        Map<String, List<TieDataNodeStd>> extendParams1 = list.stream().filter(nodeStd -> CalculRuleTypeEnum.FORMULA.getValue().equals(nodeStd.getStepIdentity().getTieUnitType())).collect(Collectors.groupingBy(nodeStd -> nodeStd.getStepIdentity().getNumber()));
        if (log.isDebugEnabled()) {
            log.debug("TieDataNodeStd by ex formulap\uff1a{}", extendParams1);
        }
        extendParams.putAll(extendParams1);
        extendParams.put(AccountStepEnum.EX_1020_S.getCode(), dataPackage.getDataNodesByStepNumber(AccountStageTypeEnum.EX_1050_S.getPhaseCode(), AccountStepEnum.EX_1020_S.getCode()));
        extendParams.put(AccountStepEnum.EX_1030_S.getCode(), dataPackage.getDataNodesByStepNumber(AccountStageTypeEnum.EX_1050_S.getPhaseCode(), AccountStepEnum.EX_1030_S.getCode()));
        storeExtendDataInfo.setExtendParams(extendParams);
        return storeExtendDataInfo;
    }

    public List<AttRecordModel> geneRecordModelListByDateNodes(List<TieDataNodeStd> dataNodes, long attPersonId, LocalDate chainDate) {
        ShiftTable shiftTableMap = (ShiftTable)this.getInitParam(ROSTER);
        Map<LocalDate, Roster> rosterMap = shiftTableMap.getByAttPersonId(attPersonId).getRosterSpecMap();
        Roster roster = null;
        if (CollectionUtils.isNotEmpty(rosterMap)) {
            roster = rosterMap.get(chainDate);
        }
        Map<Long, AttItemValue> attItemValueMap = TieContextUtil.getAllHandleResultAttItemValue(dataNodes, null != roster ? roster.getShiftSpec() : null);
        Date date = new Date();
        ArrayList recordModelList = Lists.newArrayList();
        HashSet attItemIdSet = Sets.newHashSetWithExpectedSize((int)16);
        List<TieDataNodeStd> tieDataNodeStdList = TieContextUtil.reverseNodeList(dataNodes);
        Optional<TieDataNodeStd> optional = dataNodes.stream().filter(ob -> ob.getStepIdentity().getPhaseIdentity().getNumber().equals(AccountStepEnum.DR_1010_S.getPhaseCode()) && ob.getStepIdentity().getNumber().equals(AccountStepEnum.DR_1010_S.getCode())).findFirst();
        if (optional.isPresent()) {
            TieDataNodeStd tieDataNodeStd = optional.get();
            int indexOptional = tieDataNodeStd.getStepIdentity().getPhaseIdentity().getIndex();
            tieDataNodeStdList = tieDataNodeStdList.stream().filter(ob -> ob.getStepIdentity().getPhaseIdentity().getIndex() >= indexOptional).collect(Collectors.toList());
        }
        LinkedHashMap phaseDataNodes = tieDataNodeStdList.stream().collect(Collectors.groupingBy(ob -> ob.getStepIdentity().getPhaseIdentity().getId(), LinkedHashMap::new, Collectors.toList()));
        Roster finalRoster = roster;
        phaseDataNodes.forEach((entry, dataNodeList) -> dataNodeList.forEach(node -> {
            List<AttItemInstance> attItemInstances = node.getAttItemInstances();
            for (AttItemInstance itemInstance : attItemInstances) {
                AttItemValue attItemValue;
                Long attItemId;
                AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
                boolean persistence = attItemSpec.isPersistence();
                if (!persistence || (attItemId = Long.valueOf(attItemSpec.getBid())) == null || attItemIdSet.contains(attItemId) || itemInstance.getHandleFlag() == null || !itemInstance.getHandleFlag().booleanValue() || (attItemValue = (AttItemValue)attItemValueMap.get(attItemId)) == null) continue;
                attItemIdSet.add(attItemId);
                recordModelList.add(this.getAttRecordModel((TieDataNodeStd)node, attItemValue, itemInstance, date, finalRoster));
            }
        }));
        return recordModelList;
    }

    private AttRecordModel getAttRecordModel(TieDataNodeStd nodeStd, AttItemValue attItemValue, AttItemInstance itemInstance, Date date, Roster roster) {
        AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
        long timeBuckId = nodeStd.getId();
        AttRecordModel model = new AttRecordModel();
        model.setTimeBuckId(timeBuckId);
        long attItemId = attItemSpec.getBid();
        model.setAttItemId(attItemId);
        long attItemFid = attItemSpec.getTimeSeqInfo().getVid();
        model.setAttItemFid(attItemFid);
        if (roster != null) {
            if (null != roster.getDateAttribute()) {
                model.setDateAttributeId(roster.getDateAttribute().getId());
            }
            if (null != roster.getDateType()) {
                model.setDateType(roster.getDateType().getId());
            }
        }
        boolean originalItem = attItemSpec.isOriginalItem();
        model.setOriginalItem(originalItem);
        DataType dataType = attItemSpec.getDataType();
        this.setRecordModelValue(nodeStd, attItemValue, attItemSpec, model);
        String unit = attItemSpec.getUnit();
        int dataAccuracy = attItemSpec.getDataAccuracy();
        String precisionTail = attItemSpec.getPrecisionTail();
        String valueString = AttRecordRouter.getValueString(dataType.code, model.getValue(), model.getValueSecondDecimal(), unit, dataAccuracy, precisionTail);
        model.setValueString(valueString);
        LabelSet<ILabel> labelSet = itemInstance.getExtraLabels();
        model.setLabelSet(labelSet);
        model.setAttRecordAdjustResultList(itemInstance.getAttRecordAdjustResultList());
        model.setAttRecordTrimResultList(attItemValue.getAttItemInstance().getAttRecordTrimResultList());
        model.setCalDate(date);
        return model;
    }

    private void setRecordModelValue(TieDataNodeStd nodeStd, AttItemValue attItemValue, AttItemSpec attItemSpec, AttRecordModel model) {
        DataType dataType = attItemSpec.getDataType();
        BigDecimal value = BigDecimal.ZERO;
        BigDecimal valueSecond = BigDecimal.ZERO;
        switch (dataType) {
            case DURATION: {
                value = attItemValue.getAttItemInstance().getDay();
                valueSecond = attItemValue.getAttItemInstance().getSecondDecimal();
                break;
            }
            case TIMES: {
                value = attItemValue.getAttItemInstance().getItemValue();
                break;
            }
        }
        model.setValue(value);
        model.setValueSecondDecimal(valueSecond);
        long[] parentIds = attItemValue.getParentIds();
        if (parentIds != null && parentIds.length > 0) {
            Set<Long> set = Arrays.stream(attItemValue.getParentIds()).boxed().collect(Collectors.toSet());
            set.remove(nodeStd.getId());
            set.addAll(Arrays.stream(nodeStd.getParentIds()).boxed().collect(Collectors.toSet()));
            nodeStd.getDataNodeCore().setLinkParentIdSet(set);
        }
    }

    private DataPackageInfo makePackInfoByOriPackage(DataPackageStd dataPackage) {
        DataPackageInfo packageInfo = new DataPackageInfo();
        long attPersonId = dataPackage.getAttPersonId();
        packageInfo.setAttPersonId(attPersonId);
        LocalDate chainDate = dataPackage.getChainDate();
        Date ownDate = WTCDateUtils.toDate((LocalDate)chainDate);
        packageInfo.setOwnDate(ownDate);
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.getInitParam("ATT_FILE");
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
        String mode = attFileModel.getAttMode(chainDate).getCode();
        packageInfo.setMode(mode);
        long attPeriodId = dataPackage.getAttPeriodId();
        packageInfo.setAttPeriodId(attPeriodId);
        packageInfo.setPerAttPeriodId(dataPackage.getPerAttPeriodId());
        packageInfo.setPerAttPeriodPK(dataPackage.getPerAttPeriodPK());
        packageInfo.setPerAttBeginDate(dataPackage.getPerAttBeginDate());
        packageInfo.setPerAttEndDate(dataPackage.getPerAttEndDate());
        ShiftTable shiftTableMap = (ShiftTable)this.getInitParam(ROSTER);
        ShiftSpec shiftSpec = shiftTableMap.getByAttPersonId(attPersonId).getShiftSpec(chainDate);
        long shiftId = shiftSpec.getBid();
        packageInfo.setShiftId(shiftId);
        long shiftFid = shiftSpec.getId();
        packageInfo.setShiftFid(shiftFid);
        long attFileid = attFileModel.getTimeSeqInfo().getBid();
        packageInfo.setAttFileid(attFileid);
        long attFilevid = attFileModel.getTimeSeqInfo().getVid();
        packageInfo.setAttFileVid(attFilevid);
        Long org = attFileModel.getOrgId();
        packageInfo.setOrg(org);
        Long department = attFileModel.getAdminOrgId();
        packageInfo.setDepartment(department);
        long company = attFileModel.getCompanyId();
        packageInfo.setCompany(company);
        Long position = attFileModel.getPositionId();
        packageInfo.setPosition(position);
        Long job = attFileModel.getJobId();
        packageInfo.setJob(job);
        AdminOrg adminOrgByDate = attFileCabinet.getAdminOrgByDate(department, chainDate);
        Company companyByDate = attFileCabinet.getCompanyByDate(company, chainDate);
        Position positionByDate = attFileCabinet.getPositionByDate(position, chainDate);
        Job jobByDate = attFileCabinet.getJobByDate(job, chainDate);
        long departmentVid = adminOrgByDate == null ? 0L : adminOrgByDate.getId();
        long companyVid = companyByDate == null ? 0L : companyByDate.getId();
        long positionVid = positionByDate == null ? 0L : positionByDate.getId();
        long jobVid = jobByDate == null ? 0L : jobByDate.getId();
        packageInfo.setCompanyVid(companyVid);
        packageInfo.setDepartmentVid(departmentVid);
        packageInfo.setPositionVid(positionVid);
        packageInfo.setJobVid(jobVid);
        AttendPersonData attendPersonData = (AttendPersonData)((Object)this.getInitParam("ATT_PERINFO"));
        AttendPersonModel byBidAndDate = attendPersonData.getByBidAndDate(attFileModel, dataPackage.getChainDate());
        if (byBidAndDate != null) {
            CmpEmp cmpEmp = byBidAndDate.getCmpEmp();
            packageInfo.setManagescopeid(cmpEmp == null ? 0L : cmpEmp.getBid());
            packageInfo.setManagescopevid(cmpEmp == null ? 0L : cmpEmp.getId());
            packageInfo.setManagingScope(cmpEmp == null || cmpEmp.getManagingScope() == null ? 0L : cmpEmp.getManagingScope());
            ContrWorkLoc contrWorkLoc = byBidAndDate.getContrWorkLoc();
            if (null != contrWorkLoc) {
                packageInfo.setAgreedworkplace(contrWorkLoc.getId());
            }
        }
        packageInfo.setAffiliateadminorgid(attFileModel.getAffiliateAdminOrgBid());
        packageInfo.setAffiliateadminorgvid(attFileModel.getAffiliateAdminOrgVid(chainDate));
        packageInfo.setEmpgroup(attFileModel.getEmpGroup());
        packageInfo.setDependency(attFileModel.getDependencyId());
        packageInfo.setDependencytype(attFileModel.getDependencyType());
        packageInfo.setAgreedworkplace(0L);
        packageInfo.setWorkplace(attFileModel.getWorkplace());
        packageInfo.setInitParams(this.getInitParams());
        return packageInfo;
    }

    private AccountPlanJsonDto transformerJsonDto(DataPackageStd dataPackage) {
        LocalDate chainDate = dataPackage.getChainDate();
        Date ownDate = WTCDateUtils.toDate((LocalDate)chainDate);
        AccountPlanJsonDto accountPlanJsonDto = this.transferAccountPlanJsonByPackage(dataPackage);
        List<TieDataNodeStd> dataNodes = dataPackage.getAllDataNodes();
        ArrayList<BucketJsonDto> bucketJsonDtoList = new ArrayList<BucketJsonDto>(dataNodes.size());
        for (TieDataNodeStd dataNode : dataNodes) {
            boolean lastInPhase = dataNode.isLeafInPhase();
            BucketJsonDto bucketJsonDto = new BucketJsonDto();
            bucketJsonDto.setBucketId(Long.valueOf(dataNode.getId()));
            bucketJsonDto.setStepId(Long.valueOf(dataNode.getStepIdentity().getId()));
            bucketJsonDto.setStepEntryId(dataNode.getStepIdentity().getStepEntryId());
            bucketJsonDto.setOwnDate(ownDate);
            if (Objects.nonNull(dataNode.getEvaluationRule())) {
                bucketJsonDto.setParamId(Long.valueOf(dataNode.getEvaluationRule().getId()));
                bucketJsonDto.setEntityName(dataNode.getEvaluationRule().getRuleSourceNumber());
            }
            long[] parentIds = dataNode.getParentIds();
            ArrayList<Long> parentBucketIds = new ArrayList<Long>(parentIds.length);
            for (int i = 0; i < parentIds.length; ++i) {
                parentBucketIds.add(parentIds[i]);
            }
            Set<Long> linkParentIdSet = dataNode.getDataNodeCore().getLinkParentIdSet();
            if (!CollectionUtils.isEmpty(linkParentIdSet)) {
                bucketJsonDto.setParentBucketId(new ArrayList<Long>(linkParentIdSet));
            } else {
                bucketJsonDto.setParentBucketId(parentBucketIds);
            }
            bucketJsonDto.setLastInPhase(Boolean.valueOf(lastInPhase));
            if (dataNode instanceof TimeBucketStd) {
                TimeBucketStd timeBucket = (TimeBucketStd)dataNode;
                bucketJsonDto.setType("0");
                bucketJsonDto.setStartDate(WTCDateUtils.toDate((LocalDateTime)timeBucket.getStartTime()));
                bucketJsonDto.setEndDate(WTCDateUtils.toDate((LocalDateTime)timeBucket.getEndTime()));
                bucketJsonDto.setShiftId(Long.valueOf(timeBucket.getShiftSpec().getId()));
                bucketJsonDto.setShiftDate(WTCDateUtils.toDate((LocalDate)timeBucket.getShiftDate()));
                bucketJsonDto.setAttendanceStatus(timeBucket.getAttendanceStatuses());
                bucketJsonDto.setShiftSessionType(timeBucket.getTimeBucketPosition().code);
                bucketJsonDto.setShiftTimeBucketSeq(timeBucket.getShiftTimeBucketSeqId().toString());
                bucketJsonDto.setStartTimePointSource(timeBucket.getStartTimePointSource().getNumber());
                bucketJsonDto.setEndTimePointSource(timeBucket.getEndTimePointSource().getNumber());
                bucketJsonDto.setPunchCardTag(timeBucket.getPunchCardTag());
                bucketJsonDto.setShiftTimeProp(timeBucket.getShiftTimeBucketProperty().code);
                bucketJsonDto.setDateType(Objects.isNull(timeBucket.getDateType()) ? null : timeBucket.getDateType().getId());
                bucketJsonDto.setDateAttribute(Objects.isNull(timeBucket.getDateAttribute()) ? null : timeBucket.getDateAttribute().getName());
                bucketJsonDto.setDateAttributeEntry(Objects.isNull(timeBucket.getDateAttribute()) ? null : timeBucket.getDateAttribute());
                bucketJsonDto.setAttendanceBillTag(String.valueOf(timeBucket.getAttendanceBillTag().getStatus()));
                bucketJsonDto.setAbsenceBillState(timeBucket.getAbsenceBillState());
                bucketJsonDto.setTravelBillState(timeBucket.getTravelBillState());
                bucketJsonDto.setTimeBucketLabelList(timeBucket.getTimeBucketLabelList());
            } else if (dataNode instanceof AttItemValueStd) {
                bucketJsonDto.setType("1");
            }
            List<AttItemInstance> attItemInstances = dataNode.getAttItemInstances();
            ArrayList<AttitemJsonDto> attitemJsonDtos = new ArrayList<AttitemJsonDto>(attItemInstances.size());
            for (AttItemInstance itemInstance : attItemInstances) {
                AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
                AttitemJsonDto attitemJsonDto = new AttitemJsonDto();
                attitemJsonDto.setAttitemId(attItemSpec.getId());
                attitemJsonDto.setNumber(attItemSpec.getNumber());
                attitemJsonDto.setDataType(attItemSpec.getDataType().code);
                attitemJsonDto.setDay(itemInstance.getDay());
                attitemJsonDto.setItemValue(itemInstance.getItemValue());
                attitemJsonDto.setItemType(attItemSpec.getItemType());
                attitemJsonDto.setOriginalItem(attItemSpec.isOriginalItem());
                attitemJsonDto.setSeconds(itemInstance.getSeconds());
                attitemJsonDto.setSecondDecimal(itemInstance.getSecondDecimal());
                attitemJsonDto.setUnit(attItemSpec.getUnit());
                List<AttRecordTrimResult> attRecordTrimResultList = itemInstance.getAttRecordTrimResultList();
                ArrayList attitemTrimJsonDtoList = Lists.newArrayListWithExpectedSize((int)16);
                this.addAttitemTrimJsonDto(attitemTrimJsonDtoList, attRecordTrimResultList, "-");
                List<AttRecordTrimResult> attRecordMoveTrimResultList = itemInstance.getAttRecordMoveTrimResultList();
                this.addAttitemTrimJsonDto(attitemTrimJsonDtoList, attRecordMoveTrimResultList, ADD);
                attitemJsonDto.setAttitemTrimJsonDtoList((List)attitemTrimJsonDtoList);
                attitemJsonDtos.add(attitemJsonDto);
            }
            bucketJsonDto.setAttitemList(attitemJsonDtos);
            bucketJsonDtoList.add(bucketJsonDto);
        }
        this.mountBuckets(accountPlanJsonDto, bucketJsonDtoList);
        return accountPlanJsonDto;
    }

    private void addAttitemTrimJsonDto(List<AttitemTrimJsonDto> attitemTrimJsonDtoList, List<AttRecordTrimResult> attRecordTrimResultList, String add) {
        if (!CollectionUtils.isEmpty(attRecordTrimResultList)) {
            attRecordTrimResultList.forEach(ob -> attitemTrimJsonDtoList.add(this.builtAttitemTrimJsonDto((AttRecordTrimResult)ob, add)));
        }
    }

    private AttitemTrimJsonDto builtAttitemTrimJsonDto(AttRecordTrimResult attRecordTrimResult, String add) {
        AttitemTrimJsonDto attitemTrimJsonDto = (AttitemTrimJsonDto)WTCAppContextHelper.getBean(AttitemTrimJsonDto.class);
        AttRecordAdjust attRecordAdjust = attRecordTrimResult.getAttRecordAdjust();
        if (attRecordAdjust != null) {
            attitemTrimJsonDto.setStartDate(WTCDateUtils.toDate((LocalDate)attRecordAdjust.getStartDate()));
            attitemTrimJsonDto.setEndDate(WTCDateUtils.toDate((LocalDate)attRecordAdjust.getEndDate()));
            attitemTrimJsonDto.setTrimType(attRecordAdjust.getTrimType());
            attitemTrimJsonDto.setRevisionHisId(attRecordAdjust.getAdjustDetailId());
            attitemTrimJsonDto.setValue(attRecordAdjust.getValueUpdate().stripTrailingZeros());
            attitemTrimJsonDto.setAttitemName(attRecordAdjust.getItemName());
            attitemTrimJsonDto.setRevisionAdd(add);
        }
        return attitemTrimJsonDto;
    }

    private AccountPlanJsonDto transferAccountPlanJsonByPackage(DataPackageStd dataPackage) {
        AccountPlanJsonDto accountPlanJsonDto = new AccountPlanJsonDto();
        List<PhaseDataResult<TieDataNodeStd>> phaseDataResultList = dataPackage.getPhaseDataResults();
        ArrayList<PhaseJsonDto> phaseJsonDtoList = new ArrayList<PhaseJsonDto>(phaseDataResultList.size());
        for (PhaseDataResult<TieDataNodeStd> phase : phaseDataResultList) {
            PhaseJsonDto phaseJsonDto = new PhaseJsonDto();
            phaseJsonDto.setName(phase.getName());
            phaseJsonDto.setId(phase.getId());
            List<StepDataResult<TieDataNodeStd>> steps = phase.getStepDataResults();
            ArrayList<StepJsonDto> stepJsonDtoList = new ArrayList<StepJsonDto>(steps.size());
            for (StepDataResult<TieDataNodeStd> step : steps) {
                StepJsonDto stepJsonDto = new StepJsonDto();
                stepJsonDto.setStepId(Long.valueOf(step.getId()));
                stepJsonDto.setStepEntryId(Long.valueOf(step.getStepEntryId()));
                stepJsonDto.setName(step.getName());
                stepJsonDtoList.add(stepJsonDto);
            }
            phaseJsonDto.setSteps(stepJsonDtoList);
            phaseJsonDtoList.add(phaseJsonDto);
        }
        accountPlanJsonDto.setPhaseList(phaseJsonDtoList);
        return accountPlanJsonDto;
    }

    private void mountBuckets(AccountPlanJsonDto accountPlanJsonDto, List<BucketJsonDto> bucketJsonDtoList) {
        List phaseList = accountPlanJsonDto.getPhaseList();
        for (PhaseJsonDto phase : phaseList) {
            List steps = phase.getSteps();
            steps.forEach(stepJsonDto -> {
                Long stepEntryId = stepJsonDto.getStepEntryId();
                List filterBucketList = bucketJsonDtoList.stream().filter(bucketJsonDto -> bucketJsonDto.getStepEntryId().equals(stepEntryId)).collect(Collectors.toList());
                stepJsonDto.setBucketDto(filterBucketList);
            });
        }
    }

    private static String getValueString(String dataType, BigDecimal value, BigDecimal valueSecond, String unit, int dataAccuracy, String precisionTail) {
        String result = "";
        if (HRStringUtils.equals((String)dataType, (String)"1")) {
            switch (unit) {
                case "day": {
                    result = AttRecordRouter.scale(value, dataAccuracy, 1, precisionTail);
                    break;
                }
                case "hour": {
                    result = AttRecordRouter.scale(valueSecond, dataAccuracy, 3600, precisionTail);
                    break;
                }
                case "minute": {
                    result = AttRecordRouter.scale(valueSecond, dataAccuracy, 60, precisionTail);
                    break;
                }
                case "second": {
                    result = String.valueOf(valueSecond);
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)dataType, (String)"0") && HRStringUtils.equals((String)unit, (String)"time")) {
            if (null == value) {
                return result;
            }
            result = AttRecordRouter.scale(value, dataAccuracy, 1, precisionTail);
        } else {
            result = "";
        }
        return result;
    }

    private static String scale(BigDecimal value, int dataaccuracy, int scale, String precisionTail) {
        int precision = 4;
        switch (precisionTail) {
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
        }
        return value.divide(new BigDecimal(scale), dataaccuracy, precision).toString();
    }
}

