/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.engine;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.engine.TieEngine;
import kd.wtc.wtes.business.engine.TieEngineConfig;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.common.lang.WtesException;

public final class TieEngineServiceSupport {
    static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    static final int ENGINE_POOL_SIZE;
    static final String DEFAULT_POOL_NAME = "TieEnginePool";
    static final String ENGINE_POOL_NAME;
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final Map<String, Future<?>> TASK_ID2FUTURE_MAP;

    static void submit(TieEngineConfig engineConfig, TieRequestStd request) {
        String key = TieEngineServiceSupport.genKey(request.getTaskId(), request.getSubTaskId());
        TASK_ID2FUTURE_MAP.remove(key);
        TieEngine<TieDataNodeStd> tieEngine = TieEngineServiceSupport.buildTieEngine(engineConfig, request);
        Future<?> future = EXECUTOR_SERVICE.submit(tieEngine);
        TASK_ID2FUTURE_MAP.put(key, future);
    }

    public static void submitSync(TieEngineConfig engineConfig, TieRequest request) {
        TieEngine<TieDataNodeStd> tieEngine = TieEngineServiceSupport.buildTieEngine(engineConfig, request);
        tieEngine.run();
    }

    static void terminate(long taskId, long subTaskId) {
        String key = TieEngineServiceSupport.genKey(taskId, subTaskId);
        TieEngineServiceSupport.terminateInner(key);
    }

    private static void terminateInner(String key) {
        TASK_ID2FUTURE_MAP.computeIfPresent(key, (key_, future) -> {
            future.cancel(true);
            return null;
        });
    }

    static void terminate(long taskId) {
        String keyPrefix = TieEngineServiceSupport.genKeyPrefix(taskId);
        TASK_ID2FUTURE_MAP.keySet().stream().filter(key -> key.startsWith(keyPrefix)).forEach(TieEngineServiceSupport::terminateInner);
    }

    private static String genKey(long taskId, long subTaskId) {
        return TieEngineServiceSupport.genKeyPrefix(taskId) + subTaskId;
    }

    private static String genKeyPrefix(long taskId) {
        return taskId + "_";
    }

    private TieEngineServiceSupport() {
    }

    public static TieEngine<TieDataNodeStd> buildTieEngine(TieEngineConfig engineConfig, TieRequest request) {
        String serialized = WTCAppContextHelper.getProjectParams().getString("tie.engine", "CONCURRENT");
        TieEngine<TieDataNodeStd> engine = engineConfig.getEngine(serialized);
        request.setSubTaskDispatchedTime(LocalDateTime.now());
        engine.setDataPackageRouterFactory(engineConfig.getDataPackageRouterFactory());
        engine.setExporter(engineConfig.getExporter());
        engine.setRequest(request);
        engine.setRangeChecker(engineConfig.getRangeChecker());
        engine.setTieSchemeService(engineConfig.getTieSchemeService());
        engine.setInitialises(engineConfig.getInitialises());
        engine.setIdService(engineConfig.getIdService());
        engine.setDataNodeWrapper(engineConfig.getDataNodeWrapper());
        engine.setStepExecutorUnitFactory(engineConfig.getStepExecutorUnitFactory());
        engine.setValidatorExecutor(engineConfig.getValidatorExecutor());
        engine.setCompletedCallback(engineConfig.getCallbackExecutor());
        engine.setReportDao(engineConfig.getReportDao());
        engine.setRequestContext(RequestContext.get());
        return engine;
    }

    static {
        try {
            ENGINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("tie.engine.pool.size", DEFAULT_POOL_SIZE);
            ENGINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("tie.engine.pool.name", DEFAULT_POOL_NAME);
            EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)ENGINE_POOL_NAME, (int)ENGINE_POOL_SIZE);
        }
        catch (Exception e) {
            throw new WtesException((Throwable)e, ResManager.loadKDString((String)"\u5f15\u64ce\u521d\u59cb\u5316\u53c2\u6570\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"TieEngineServiceSupport_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        TASK_ID2FUTURE_MAP = new ConcurrentHashMap();
    }
}

