/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.attrecordadjust;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.ContextUtil;

public class AttDayRecordTrimEvaluator
implements TieEvaluatorStd {
    private ShiftSpec shiftSpec = null;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataResultStd = AttRecordTrimUtil.vailte(context);
        if (tieDataResultStd != null) {
            return tieDataResultStd;
        }
        AttRecordTrimData attRecordTrimData = ContextUtil.getAttRecordTrimtData(context);
        LocalDate chainDate = context.getChainDate();
        this.shiftSpec = ContextUtil.getCurrentShiftTable(context).getShiftSpec(chainDate);
        long attPersonId = context.getAttPersonId();
        List<AttRecordAdjust> trimRecordList = attRecordTrimData.getDayAdjustRecords(attPersonId, chainDate, "trim");
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        List<AttItemValue> attItemValueList = this.matchAttRecordAdjust(trimRecordList, chainDate, attItemSpecData, context, dataNodes);
        return TieDataResultStd.success(attItemValueList);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    private List<AttItemValue> matchAttRecordAdjust(List<AttRecordAdjust> attRecordAdjustList, LocalDate chainDate, AttItemSpecData attItemSpecData, TieContextStd context, List<TieDataNodeStd> dataNodes) {
        ArrayList attItemValueList = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(dataNodes);
        List dataNodesInCurPhase = context.getDataNodesInCurPhase();
        attRecordAdjustList.forEach(attRecordAdjust -> {
            AttItemValue pointAttItemValue;
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attRecordAdjust.getItemId(), chainDate);
            if (attItemSpec != null && StringUtils.equals((CharSequence)attItemSpec.getUnit(), (CharSequence)attRecordAdjust.getItemUnit()) && (pointAttItemValue = AttRecordTrimUtil.getCurAttItemInstance(dataNodesInCurPhase, attItemValueMap, attItemSpec, false)) != null) {
                AttItemValue attItemValue = AttRecordTrimUtil.getAttItemSpecAttItemValue(attItemSpec, attItemValueList);
                attItemValueList.add(this.builtAttItemValue(attItemValue, pointAttItemValue, (AttRecordAdjust)attRecordAdjust, attItemSpec));
            }
        });
        Map<Long, List<AttItemValue>> map = attItemValueList.stream().collect(Collectors.groupingBy(ob -> ob.getAttItemInstance().getAttItemSpec().getBid()));
        ArrayList returnAttItemValue = Lists.newArrayListWithExpectedSize((int)16);
        map.forEach((key, value) -> {
            AttItemValue lastAttItemValue = (AttItemValue)value.get(value.size() - 1);
            List attRecordTrimResultList = value.stream().map(ob -> ob.getAttItemInstance().getAttRecordTrimResult()).collect(Collectors.toList());
            lastAttItemValue.getAttItemInstance().getAttRecordTrimResultList().addAll(attRecordTrimResultList);
            returnAttItemValue.add(lastAttItemValue);
        });
        return returnAttItemValue;
    }

    private AttItemValue builtAttItemValue(AttItemValue attItemValue, AttItemValue curAttItemValue, AttRecordAdjust attRecordAdjust, AttItemSpec attItemSpec) {
        AttRecordTrimResult attRecordTrimResult;
        String itemUnit = attRecordAdjust.getItemUnit();
        BigDecimal valueBefore = HRStringUtils.equals((String)"time", (String)itemUnit) ? curAttItemValue.getAttItemInstance().getItemValue() : curAttItemValue.getAttItemInstance().getSecondDecimal();
        boolean isUpNode = false;
        if (attItemValue != null && (attRecordTrimResult = attItemValue.getAttItemInstance().getAttRecordTrimResult()) != null) {
            valueBefore = attRecordTrimResult.getValueAfter();
            isUpNode = true;
        }
        return AttRecordTrimUtil.builtAttitemValueWithParent(attItemSpec, attRecordAdjust, valueBefore, curAttItemValue, this.shiftSpec, true, isUpNode, null);
    }
}

