/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.enums.RefDateType;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.retrieval.BillRetrievalDimensionResult;
import kd.wtc.wtes.business.model.rlotcal.TimeCut;
import kd.wtc.wtes.business.model.rlotcal.TimeCutConfig;
import kd.wtc.wtes.business.service.impl.DateRangeEnhancedServiceImpl;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TimeBucketUtil;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class CalTimeCutHelper {
    private static final Log logger = LogFactory.getLog(CalTimeCutHelper.class);

    public static Set<TimeBucket> splidTimeBucket(TieContextStd context, TimeBucket timeBucket, TimeCut timeCut) {
        if (logger.isDebugEnabled()) {
            logger.debug("context.getAttPersonId(){},context.getChainDate(){}", (Object)context.getAttPersonId(), (Object)context.getChainDate());
        }
        if (timeCut != null && timeBucket.getStartTime() != null && timeBucket.getEndTime() != null) {
            boolean sence13;
            if (logger.isDebugEnabled()) {
                logger.debug("context.getAttPersonId(){},context.getChainDate(){},timeBucket.getStartTime(){},timeBucket.getEndTime(){}\uff0ctimeC\uff1b{}", new Object[]{context.getAttPersonId(), context.getChainDate(), timeBucket.getStartTime(), timeBucket.getEndTime(), timeCut.toString()});
            }
            LocalDateTime startTime = CalTimeCutHelper.getLocalDateTime(timeCut.getFixtimeentity().getStagdate(), timeCut.getFixtimeentity().getBegintime(), context.getChainDate());
            LocalDateTime endTime = CalTimeCutHelper.getLocalDateTime(timeCut.getFixtimeentity().getEtagdate(), timeCut.getFixtimeentity().getEndtime(), context.getChainDate());
            TimeBucket preTimeBucket = null;
            TimeBucket endTimeBucket = null;
            TimeBucket currentTimeBucket = null;
            boolean allNotnull = startTime != null && endTime != null;
            boolean sence1 = allNotnull && startTime == endTime && TimeBucketUtil.hasInTimeBucket(startTime, timeBucket);
            boolean sence2 = allNotnull && startTime != endTime && TimeBucketUtil.hasInTimeBucket(startTime, timeBucket) && TimeBucketUtil.hasInTimeBucket(endTime, timeBucket);
            boolean sence3 = allNotnull && endTime.compareTo(timeBucket.getStartTime()) <= 0;
            boolean sence4 = allNotnull && startTime.compareTo(timeBucket.getEndTime()) >= 0;
            boolean sence5 = startTime != null && endTime == null && TimeBucketUtil.hasInTimeBucket(startTime, timeBucket);
            boolean sence6 = startTime != null && endTime == null && startTime.compareTo(timeBucket.getStartTime()) <= 0;
            boolean sence7 = startTime != null && endTime == null && startTime.compareTo(timeBucket.getEndTime()) >= 0;
            boolean sence8 = startTime == null && endTime != null && TimeBucketUtil.hasInTimeBucket(endTime, timeBucket);
            boolean sence9 = startTime == null && endTime != null && endTime.compareTo(timeBucket.getStartTime()) <= 0;
            boolean sence10 = startTime == null && endTime != null && endTime.compareTo(timeBucket.getEndTime()) >= 0;
            boolean sence11 = allNotnull && startTime.compareTo(timeBucket.getStartTime()) <= 0 && endTime.compareTo(timeBucket.getEndTime()) >= 0;
            boolean sence12 = allNotnull && !TimeBucketUtil.hasInTimeBucket(startTime, timeBucket) && TimeBucketUtil.hasInTimeBucket(endTime, timeBucket);
            boolean bl = sence13 = allNotnull && !TimeBucketUtil.hasInTimeBucket(endTime, timeBucket) && TimeBucketUtil.hasInTimeBucket(startTime, timeBucket);
            if (logger.isDebugEnabled()) {
                logger.debug("timeBucket.getStartTime(){},timeBucket.getEndTime(){}\uff0cstartTime{}\uff0cendTime{}", new Object[]{timeBucket.getStartTime(), timeBucket.getEndTime(), startTime, endTime});
                logger.debug("sence1{},sence2{},sence3{},sence4{},sence5{},sence6{},sence7{},sence8{},sence9{},sence10{},sence11{},sence12{},sence13{}", new Object[]{sence1, sence2, sence3, sence4, sence5, sence6, sence7, sence8, sence9, sence10, sence11, sence12, sence13});
            }
            if (sence1 || sence2) {
                preTimeBucket = preTimeBucket != null ? preTimeBucket : CalTimeCutHelper.newTimeBucket(timeBucket.getStartTime(), startTime, RefDateType.PREV_DAY, timeBucket, context);
                endTimeBucket = endTimeBucket != null ? endTimeBucket : CalTimeCutHelper.newTimeBucket(endTime, timeBucket.getEndTime(), RefDateType.NEXT_DAY, timeBucket, context);
                TimeBucket timeBucket2 = currentTimeBucket = currentTimeBucket != null ? currentTimeBucket : CalTimeCutHelper.newTimeBucket(startTime, endTime, RefDateType.TODAY, timeBucket, context);
            }
            if (sence3 || sence9) {
                TimeBucket timeBucket3 = endTimeBucket = endTimeBucket != null ? endTimeBucket : CalTimeCutHelper.newTimeBucket(timeBucket.getStartTime(), timeBucket.getEndTime(), RefDateType.NEXT_DAY, timeBucket, context);
            }
            if (sence4 || sence7) {
                TimeBucket timeBucket4 = preTimeBucket = preTimeBucket != null ? preTimeBucket : CalTimeCutHelper.newTimeBucket(timeBucket.getStartTime(), timeBucket.getEndTime(), RefDateType.PREV_DAY, timeBucket, context);
            }
            if (sence5 || sence13) {
                preTimeBucket = preTimeBucket != null ? preTimeBucket : CalTimeCutHelper.newTimeBucket(timeBucket.getStartTime(), startTime, RefDateType.PREV_DAY, timeBucket, context);
                TimeBucket timeBucket5 = currentTimeBucket = currentTimeBucket != null ? currentTimeBucket : CalTimeCutHelper.newTimeBucket(startTime, timeBucket.getEndTime(), RefDateType.TODAY, timeBucket, context);
            }
            if (sence6 || sence10 || sence11) {
                TimeBucket timeBucket6 = currentTimeBucket = currentTimeBucket != null ? currentTimeBucket : timeBucket.clone();
            }
            if (sence8 || sence12) {
                endTimeBucket = endTimeBucket != null ? endTimeBucket : CalTimeCutHelper.newTimeBucket(endTime, timeBucket.getEndTime(), RefDateType.NEXT_DAY, timeBucket, context);
                TimeBucket timeBucket7 = currentTimeBucket = currentTimeBucket != null ? currentTimeBucket : CalTimeCutHelper.newTimeBucket(timeBucket.getStartTime(), endTime, RefDateType.TODAY, timeBucket, context);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CalTimeCutHelper.splidTimeBucket.preTimeBucket:{},currentTimeBucket:{},endTimeBucket:{}", new Object[]{preTimeBucket, currentTimeBucket, endTimeBucket});
            }
            HashSet res = Sets.newHashSetWithExpectedSize((int)6);
            res.addAll(Sets.newHashSet((Object[])new TimeBucket[]{preTimeBucket, endTimeBucket, currentTimeBucket}));
            res.remove(null);
            return res;
        }
        return Sets.newHashSet((Object[])new TimeBucket[]{timeBucket});
    }

    private static TimeBucket newTimeBucket(LocalDateTime startTime, LocalDateTime endTime, RefDateType refDateType, TimeBucket timeBucket, TieContextStd context) {
        if (startTime.compareTo(endTime) >= 0) {
            return null;
        }
        TimeBucket timeBucket1 = timeBucket.clone();
        if (!timeBucket1.getStartTime().equals(startTime)) {
            timeBucket1.setStartTime(startTime);
            timeBucket1.setStartTimePointSource(SourceCode.NONE);
        }
        if (!timeBucket1.getEndTime().equals(endTime)) {
            timeBucket1.setEndTime(endTime);
            timeBucket1.setEndTimePointSource(SourceCode.NONE);
        }
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        Roster roster = null;
        switch (refDateType) {
            case TODAY: {
                break;
            }
            case NEXT_DAY: {
                timeBucket1.setDateAttribute(shiftTableSingle.getDateAttribute(context.getChainDate().plusDays(1L)));
                roster = shiftTableSingle.getRoster(context.getChainDate().plusDays(1L));
                if (roster == null || roster.getDateType() == null) break;
                DateType dateType = roster.getDateType();
                timeBucket1.setDateType(dateType);
                break;
            }
            case PREV_DAY: {
                timeBucket1.setDateAttribute(shiftTableSingle.getDateAttribute(context.getChainDate().plusDays(-1L)));
                roster = shiftTableSingle.getRoster(context.getChainDate().plusDays(-1L));
                if (roster == null || roster.getDateType() == null) break;
                DateType dateType = roster.getDateType();
                timeBucket1.setDateType(dateType);
                break;
            }
        }
        return timeBucket1;
    }

    public static TimeCut isMatcheDate(TieContextStd context, TimeCut timeCut) {
        return CalTimeCutHelper.isMatcheDate(context, timeCut, null);
    }

    public static TimeCut isMatcheDate(TieContextStd context, TimeCut timeCut, Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult> tuple3) {
        ArrayList timeCutConfigs = Lists.newArrayListWithExpectedSize((int)timeCut.getTimeCutConfigs().size());
        DateRangeEnhancedServiceImpl rangeEnhancedService = new DateRangeEnhancedServiceImpl();
        for (TimeCutConfig cutConfig : timeCut.getTimeCutConfigs()) {
            BillRetrievalDimensionResult item1;
            boolean matche;
            if (cutConfig.getDateConditionAccessDto() != null) {
                BillRetrievalDimensionResult item2 = tuple3 == null ? null : (BillRetrievalDimensionResult)tuple3.item2;
                RuleConditionValues ruleConditionValues = null;
                if (item2 != null) {
                    ruleConditionValues = item2.getRetrievalDimension();
                }
                matche = rangeEnhancedService.matchShiftCondition(WTCDateRangeSource.OTP, cutConfig.getDateConditionAccessDto(), context, RefDateType.TODAY, ruleConditionValues);
            } else {
                matche = true;
            }
            if (cutConfig.getPreDateConditionAccessDto() != null) {
                item1 = tuple3 == null ? null : (BillRetrievalDimensionResult)tuple3.item1;
                RuleConditionValues preRuleConditionValues = null;
                if (item1 != null) {
                    preRuleConditionValues = item1.getRetrievalDimension();
                }
                boolean bl = matche = matche && rangeEnhancedService.matchShiftCondition(WTCDateRangeSource.OTP, cutConfig.getPreDateConditionAccessDto(), context, RefDateType.PREV_DAY, preRuleConditionValues);
            }
            if (cutConfig.getAfterDateConditionAccessDto() != null) {
                item1 = tuple3 == null ? null : (BillRetrievalDimensionResult)tuple3.item3;
                RuleConditionValues nextRuleConditionValues = null;
                if (item1 != null) {
                    nextRuleConditionValues = item1.getRetrievalDimension();
                }
                boolean bl = matche = matche && rangeEnhancedService.matchShiftCondition(WTCDateRangeSource.OTP, cutConfig.getAfterDateConditionAccessDto(), context, RefDateType.NEXT_DAY, nextRuleConditionValues);
            }
            if (!matche) continue;
            timeCutConfigs.add(cutConfig);
        }
        if (timeCutConfigs.size() > 0) {
            return TimeCut.builder().setId(timeCut.getId()).setNumber(timeCut.getNumber()).setTimeCutConfigs(timeCutConfigs).build();
        }
        return null;
    }

    public static LocalDateTime getLocalDateTime(String tagdate, LocalTime time, LocalDate now) {
        if (tagdate == null || time == null || now == null) {
            return null;
        }
        if ("D".equals(tagdate)) {
            return LocalDateTime.of(now, time);
        }
        if ("C".equals(tagdate)) {
            return LocalDateTime.of(now.plusDays(1L), time);
        }
        return LocalDateTime.of(now, time);
    }

    public static boolean dateAttributeIsChange(TieContextStd context, ITimeBucket timeBucket) {
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        DateAttribute dateAttribute = shiftTableSingle.getDateAttribute(context.getChainDate());
        return dateAttribute != timeBucket.getDateAttribute();
    }
}

