/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.common;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class InitHelper {
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_daterange");

    public static DynamicObject[] getHisDyArr(String entityNumber, Set<Long> fileEntryIds, LocalDate startDate, LocalDate endDate) {
        Set newSet = fileEntryIds.stream().filter(key -> key != 0L).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(newSet)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(fileEntryIds, startDate, endDate);
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static Map<Long, List<Entity>> createConditionMap(String entityNumber, Collection<Long> collection) {
        DynamicObject[] conditions = helper.query("basedataid,conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)entityNumber), new QFilter("basedataid", "in", collection)});
        return Arrays.stream(conditions).map(dy -> new Entity(dy.getLong("basedataid"), dy.getString("conditions"))).collect(Collectors.groupingBy(Entity::getId));
    }

    public static AttItemInstance createAttItem(Long bid, LocalDate chainDate, int second, ShiftTableSingle shiftTableSingle, AttItemSpecData attItemSpecData) {
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        BigDecimal day = shiftSpec.secondsToDays(Math.abs(second));
        AttItemSpec attItem = attItemSpecData.getByBidAndDate(bid, chainDate);
        return new AttItemInstance(attItem, BigDecimal.valueOf(second), day, BigDecimal.valueOf(second), null);
    }

    public static AttItemInstance createAttItem(LocalDate chainDate, int second, ShiftTableSingle shiftTableSingle, AttItemSpec attItemSpec) {
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        BigDecimal day = shiftSpec.secondsToDays(Math.abs(second));
        return new AttItemInstance(attItemSpec, BigDecimal.valueOf(second), day, BigDecimal.valueOf(second), null);
    }

    public static AttItemInstance createAttItem(LocalDate chainDate, BigDecimal second, ShiftTableSingle shiftTableSingle, AttItemSpec attItemSpec) {
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        BigDecimal day = shiftSpec.secondsToDays(second);
        return new AttItemInstance(attItemSpec, second, day, second, null);
    }

    public static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        return TimeSeqEntityGenerateUtils.getTimeSeqEntity(dynamicObject);
    }
}

