/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.formula.provider.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttendAttr;
import kd.wtc.wtbs.common.predata.wtbd.PreDataExAttribute;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.DasoConf;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtp.utils.FlxTimeBucketUtils;

public class TieProviderBillService {
    private static final Log LOG = LogFactory.getLog(TieProviderBillService.class);

    public Object[] getOTBillObjectArray(Map<String, Object> paramMap, String lang) {
        TieContextStd context = (TieContextStd)paramMap.get("context");
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        List<AttBillTimeBucket> billTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(context.getAttPersonId());
        List<Object> res = Lists.newArrayListWithCapacity((int)attBillTimeBucketData.getBtbId2Btb().size());
        for (AttBillTimeBucket attBillTimeBucket : billTimeBuckets) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!"OT".equals(attBillTimeBucket.getBillTypeBig())) continue;
            DynamicObject billDyn = attBillTimeBucket.getOtpBillDyn();
            DynamicObject rowDy = attBillTimeBucket.getEntryRowDy();
            if (billDyn == null || rowDy == null) {
                LOG.warn("billDyn is null or rowDy is null,{}", (Object)(billDyn == null ? 1 : 0));
                continue;
            }
            this.billCommonInfo(map, attBillTimeBucket, rowDy);
            String otApplyType = billDyn.getString("otapplytype");
            map.put("billBizType", "1".equals(otApplyType) ? rowDy.getLocaleString("sdottype.name").get((Object)lang) : rowDy.getLocaleString("scottype.name").get((Object)lang));
            if (attBillTimeBucket.getStartTime() != null) {
                map.put("shiftDate", WTCDateUtils.toDate((LocalDate)attBillTimeBucket.getStartTime().toLocalDate()));
            } else {
                map.put("assignmentDate", WTCDateUtils.toDate((LocalDate)attBillTimeBucket.getRosterDate()));
            }
            map.put("assignmentDate", WTCDateUtils.toDate((LocalDate)attBillTimeBucket.getRosterDate()));
            map.put("requestType", otApplyType);
            res.add(map);
        }
        res = TieProviderBillService.removeDuplicates((List<Map<String, Object>>)res, "requestBillID");
        return res.stream().map(hashMap -> Collections.unmodifiableMap(hashMap)).collect(Collectors.toList()).toArray();
    }

    private static List<Map<String, Object>> removeDuplicates(List<Map<String, Object>> list, String keyField) {
        HashMap uniqueMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Map<String, Object> map : list) {
            Object keyValue = map.get(keyField);
            uniqueMap.put(keyValue, map);
        }
        return new ArrayList<Map<String, Object>>(uniqueMap.values());
    }

    private List<Map<String, Object>> getVaBillOption(TieContextStd context, String lang) {
        Map listMap = (Map)context.getInitParams().get("BILL_DYNAMICOBJECT");
        List vaDyList = (List)listMap.get(AttFilePlanEnum.VP.getSign());
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        ArrayList res = Lists.newArrayListWithCapacity((int)attBillTimeBucketData.getBtbId2Btb().size());
        for (DynamicObject vaDy : vaDyList) {
            DynamicObjectCollection rowDys = vaDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject rowDy : rowDys) {
                if (!"3".equals(rowDy.getString("entrystartmethod"))) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.billCommonInfo(map, "VA", rowDy, vaDy);
                map.put("billBizType", rowDy.getLocaleString("entryvacationtype.name").get((Object)lang));
                String bizTypeCode = ResManager.loadKDString((String)"\u4f11\u5047", (String)"AttStatusEnum_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
                map.put("bizTypeCode", "VA");
                map.put("validLengthOfTime", rowDy.getBigDecimal("entryvatimehour").multiply(BigDecimal.valueOf(60L)));
                map.put("startTimeType", rowDy.getString("entrystartmethod"));
                map.put("endTimeType", rowDy.getString("entryendmethod"));
                map.put("specialvatype", rowDy.getString("specialvatype"));
                map.put("specialvamethod", rowDy.getString("specialvamethod.number"));
                map.put("assignmentDate", new Date(rowDy.getDate("owndate").getTime()));
                res.add(map);
            }
        }
        return res;
    }

    public Object[] getVaBillObjectArray(Map<String, Object> paramMap, String lang) {
        TieContextStd context = (TieContextStd)paramMap.get("context");
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        List<AttBillTimeBucket> billTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(context.getAttPersonId());
        ArrayList res = Lists.newArrayListWithCapacity((int)attBillTimeBucketData.getBtbId2Btb().size());
        for (AttBillTimeBucket attBillTimeBucket : billTimeBuckets) {
            DynamicObject rowDy;
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            if (!"VA".equals(attBillTimeBucket.getBillTypeBig()) || "3".equals((rowDy = attBillTimeBucket.getEntryRowDy()).getString("entrystartmethod"))) continue;
            this.billCommonInfo(map2, attBillTimeBucket, rowDy);
            map2.put("billBizType", rowDy.getLocaleString("entryvacationtype.name").get((Object)lang));
            map2.put("bizTypeCode", attBillTimeBucket.getBillTypeBig());
            map2.put("validLengthOfTime", attBillTimeBucket.getDuration());
            map2.put("startTimeType", rowDy.getString("entrystartmethod"));
            map2.put("endTimeType", rowDy.getString("entryendmethod"));
            map2.put("specialvatype", rowDy.getString("specialvatype"));
            map2.put("specialvamethod", rowDy.getString("specialvamethod.number"));
            res.add(map2);
        }
        res.addAll(this.getVaBillOption(context, lang));
        Map<String, List<Map>> collect = res.stream().collect(Collectors.groupingBy(map -> String.valueOf(map.get("requestBillID"))));
        ArrayList allBill = Lists.newArrayListWithCapacity((int)res.size());
        for (Map.Entry<String, List<Map>> entry : collect.entrySet()) {
            List<Map> maps = entry.getValue();
            List timeNotNull = maps.stream().filter(map -> {
                Date startTime = (Date)FlxTimeBucketUtils.getValue((Map)map, (String)"startTime", Date.class);
                Date endTime = (Date)FlxTimeBucketUtils.getValue((Map)map, (String)"endTime", Date.class);
                boolean bool = startTime != null && endTime != null;
                return bool;
            }).collect(Collectors.toList());
            if (!WTCCollections.isNotEmpty(timeNotNull)) continue;
            List sorted = timeNotNull.stream().sorted(Comparator.comparingLong(map -> ((Date)FlxTimeBucketUtils.getValue((Map)map, (String)"startTime", Date.class)).getTime())).collect(Collectors.toList());
            Date latestDate = (Date)FlxTimeBucketUtils.getValue((Map)((Map)sorted.get(sorted.size() - 1)), (String)"endTime", Date.class);
            Map map3 = (Map)sorted.get(0);
            map3.put("endTime", latestDate);
            allBill.add(map3);
        }
        return allBill.stream().map(hashMap -> Collections.unmodifiableMap(hashMap)).collect(Collectors.toList()).toArray();
    }

    public Object[] getTLBillObjectArray(Map<String, Object> paramMap, String lang) {
        TieContextStd context = (TieContextStd)paramMap.get("context");
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        List<AttBillTimeBucket> billTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(context.getAttPersonId());
        ArrayList res = Lists.newArrayListWithCapacity((int)attBillTimeBucketData.getBtbId2Btb().size());
        List<Object> result = Lists.newArrayListWithCapacity((int)attBillTimeBucketData.getBtbId2Btb().size());
        for (AttBillTimeBucket attBillTimeBucket : billTimeBuckets) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            if (!"BT".equals(attBillTimeBucket.getBillTypeBig())) continue;
            DynamicObject rowDy = attBillTimeBucket.getEntryRowDy();
            this.billCommonInfo(map2, attBillTimeBucket, rowDy);
            map2.put("billBizType", rowDy.getLocaleString("busitriptype.name").get((Object)lang));
            map2.put("startTimeType", rowDy.getString("startmethod"));
            map2.put("endTimeType", rowDy.getString("endmethod"));
            map2.put("assignmentDate", rowDy.getString("owndate"));
            res.add(map2);
        }
        Map<Object, List<Map>> listMap = res.stream().collect(Collectors.groupingBy(obj -> obj.get("requestBillID")));
        for (Map.Entry<Object, List<Map>> entry : listMap.entrySet()) {
            List<Map> maps = entry.getValue();
            List timeNotNull = maps.stream().filter(map -> {
                Date startTime = (Date)FlxTimeBucketUtils.getValue((Map)map, (String)"startTime", Date.class);
                Date endTime = (Date)FlxTimeBucketUtils.getValue((Map)map, (String)"endTime", Date.class);
                boolean bool = startTime != null && endTime != null;
                return bool;
            }).collect(Collectors.toList());
            if (!WTCCollections.isNotEmpty(timeNotNull)) continue;
            List collect = timeNotNull.stream().sorted(Comparator.comparingLong(map -> ((Date)FlxTimeBucketUtils.getValue((Map)map, (String)"startTime", Date.class)).getTime())).collect(Collectors.toList());
            ((Map)collect.get(0)).put("endTime", ((Map)collect.get(collect.size() - 1)).get("endTime"));
            result.add(collect.get(0));
        }
        result = TieProviderBillService.removeDuplicates((List<Map<String, Object>>)result, "requestBillID");
        return result.stream().map(hashMap -> Collections.unmodifiableMap(hashMap)).collect(Collectors.toList()).toArray();
    }

    private void billCommonInfo(Map<String, Object> map, String billTypeBig, DynamicObject rowDy, DynamicObject parentDy) {
        String entrystart = "entrystartdate";
        String entryend = "entryenddate";
        map.put("requestCode", parentDy.getString("billno"));
        map.put("requestBillID", String.valueOf(rowDy.getLong("ID")));
        if (rowDy.getDate(entrystart) != null && rowDy.getDate(entryend) != null) {
            map.put("lengthOfTime", (rowDy.getDate(entryend).getTime() - rowDy.getDate(entrystart).getTime()) / 1000L);
        }
        map.put("units", "second");
        map.put("startTime", new Date(rowDy.getDate(entrystart).getTime()));
        map.put("endTime", new Date(rowDy.getDate(entryend).getTime()));
    }

    private void billCommonInfo(Map<String, Object> map, AttBillTimeBucket attBillTimeBucket, DynamicObject rowDy) {
        String entrystart = "entrystartdate";
        String entryend = "entryenddate";
        if ("BT".equals(attBillTimeBucket.getBillTypeBig())) {
            entrystart = "startdate";
            entryend = "enddate";
        }
        if ("VA".equals(attBillTimeBucket.getBillTypeBig())) {
            entrystart = "entrystartdate";
            entryend = "entryenddate";
        }
        if ("OT".equals(attBillTimeBucket.getBillTypeBig()) && "1".equals(attBillTimeBucket.getOtpBillDyn().getString("otapplytype"))) {
            entrystart = "otstartdate";
            entryend = "otenddate";
        }
        if ("OT".equals(attBillTimeBucket.getBillTypeBig()) && "2".equals(attBillTimeBucket.getOtpBillDyn().getString("otapplytype"))) {
            entrystart = "otdstarttime";
            entryend = "otdendtime";
            map.put("lengthOfTime", rowDy.get("otdtime"));
        }
        map.put("requestCode", attBillTimeBucket.getNumber());
        map.put("requestBillID", String.valueOf(rowDy.getLong("ID")));
        map.put("bizTypeCode", attBillTimeBucket.getBillTypeBig());
        if (rowDy.getDate(entrystart) != null && rowDy.getDate(entryend) != null) {
            map.put("lengthOfTime", (rowDy.getDate(entryend).getTime() - rowDy.getDate(entrystart).getTime()) / 1000L);
        }
        map.put("units", "second");
        map.put("startTime", new Date(rowDy.getDate(entrystart).getTime()));
        map.put("endTime", new Date(rowDy.getDate(entryend).getTime()));
        if ("BT".equals(attBillTimeBucket.getBillTypeBig()) && !"3".equals(rowDy.getString("startmethod")) || "VA".equals(attBillTimeBucket.getBillTypeBig()) && !"3".equals(rowDy.getString("entrystartmethod"))) {
            map.put("startTime", WTCDateUtils.toDate((LocalDateTime)attBillTimeBucket.getStartTime()));
            map.put("endTime", WTCDateUtils.toDate((LocalDateTime)attBillTimeBucket.getEndTime()));
        }
    }

    public Object[] getDasoconfMap(Map<String, Object> paramMap) {
        HashMap<String, AccessDto> res = new HashMap<String, AccessDto>();
        TieContextStd context = (TieContextStd)paramMap.get("context");
        ConfigMix configMix = ContextUtil.getConfigMix(context);
        LocalDate chainDate = context.getChainDate();
        res.put("OT", this.accessDto(configMix.getDataSource(BizTypeEnum.OT), chainDate));
        res.put("VA", this.accessDto(configMix.getDataSource(BizTypeEnum.VA), chainDate));
        res.put("BT", this.accessDto(configMix.getDataSource(BizTypeEnum.BUSINESS), chainDate));
        res.put("LATE", this.accessDto(configMix.getDataSource(BizTypeEnum.EX, PreDataExAttribute.PD_1010_S), chainDate));
        res.put("EARLY", this.accessDto(configMix.getDataSource(BizTypeEnum.EX, PreDataExAttribute.PD_1020_S), chainDate));
        res.put("absent", this.accessDto(configMix.getDataSource(BizTypeEnum.EX, PreDataExAttribute.PD_1030_S), chainDate));
        res.put("supple", this.accessDto(configMix.getDataSource(BizTypeEnum.EX, PreDataExAttribute.PD_1040_S), chainDate));
        res.put("ATT_ORI", this.accessDto(configMix.getDataSource(BizTypeEnum.ATT, PreDataAttendAttr.PD_1020_S), chainDate));
        return res.entrySet().toArray();
    }

    private AccessDto accessDto(BizDataSource bizDataSource, LocalDate localDate) {
        TimeSeqBo<DasoConf> dasoConfTimeSeqBo = bizDataSource != null ? bizDataSource.getDasoConfTimeSeqBo() : null;
        DasoConf versionByDate = dasoConfTimeSeqBo != null && localDate != null ? (DasoConf)dasoConfTimeSeqBo.getVersionByDate(localDate) : null;
        return versionByDate != null ? versionByDate.getConditionWtbs() : null;
    }
}

