/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlad;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlad.AdCalcData;
import kd.wtc.wtes.business.model.rlad.AdConfigDetailPackage;
import kd.wtc.wtes.business.model.rlad.AdConfigPackage;
import kd.wtc.wtes.business.model.util.AdEntityUtils;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AdCountCalcEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(AdCountCalcEvaluator.class);
    private AttItemSpecData attItemSpecData;
    private LocalDate chainDate;
    private Map<LocalDate, List<AdCalcData>> punchCardDataMap;
    private TieContextStd context;
    private AdConfigDetailPackage adConfigDetailPackage;
    private AttPeriodTable attPeriodTable;
    private AdConfigPackage adConfigPackage;
    private List<AttItemValue> attItemValues;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        this.context = context;
        this.chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        this.punchCardDataMap = AdEntityUtils.getCardDataOfPerson(context, attPersonId);
        if (CollectionUtils.isEmpty(this.punchCardDataMap)) {
            LOG.debug("AdCountCalcEvaluator,AttPersonId:{},no card data", (Object)attPersonId);
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "no card data"));
        }
        this.adConfigPackage = AdEntityUtils.getAdConfigPackage(context);
        if (this.adConfigPackage == null) {
            LOG.debug("AdCountCalcEvaluator,AttPersonId:{},no ad rule or count limit config", (Object)attPersonId);
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "no ad rule or count limit config"));
        }
        this.attItemSpecData = ContextUtil.getAttItemSpecData(context);
        String limitType = this.adConfigPackage.getLimitType();
        this.attPeriodTable = (AttPeriodTable)context.getInitParam("ATT_PERIOD");
        boolean isLimitByCard = "A".equals(limitType);
        this.attItemValues = new LinkedList<AttItemValue>();
        if (isLimitByCard) {
            this.adConfigDetailPackage = this.adConfigPackage.getAdConfigByCardPackage();
            this.initAttItemValue(true);
        } else {
            List<AdConfigDetailPackage> adConfigByReasonPackageList = this.adConfigPackage.getAdConfigByReasonPackageList();
            Iterator<AdConfigDetailPackage> iterator = adConfigByReasonPackageList.iterator();
            while (iterator.hasNext()) {
                AdConfigDetailPackage detailPackage;
                this.adConfigDetailPackage = detailPackage = iterator.next();
                this.initAttItemValue(false);
            }
        }
        if (CollectionUtils.isEmpty(this.attItemValues)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "count limit set no config attitem or not exists card."));
        }
        return TieDataResultStd.success(this.attItemValues);
    }

    private void initAttItemValue(boolean isLimitByCard) {
        AttItemSpec aboveAttItemSpec;
        AttItemSpec attItemSpec;
        int aboveApplyCount;
        int applyCount;
        if (this.adConfigDetailPackage.getAttItemId() == 0L && this.adConfigDetailPackage.getAboveAttItemId() == 0L) {
            return;
        }
        boolean allowAbove = this.adConfigDetailPackage.isAllowAbove();
        List<AdCalcData> adCalcDataList = this.punchCardDataMap.get(this.chainDate);
        if (CollectionUtils.isNotEmpty(adCalcDataList) && !isLimitByCard) {
            long reasonId = this.adConfigDetailPackage.getReasonId();
            adCalcDataList = adCalcDataList.stream().filter(item -> item.getApplyReasonId() == reasonId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(adCalcDataList)) {
            applyCount = 0;
            aboveApplyCount = 0;
        } else {
            Tuple<Integer, Integer> applyCountTuple = this.getApplyCount(adCalcDataList, isLimitByCard);
            applyCount = (Integer)applyCountTuple.getKey();
            aboveApplyCount = (Integer)applyCountTuple.getValue();
        }
        if (applyCount > 0 && (attItemSpec = this.attItemSpecData.getByBidAndDate(this.adConfigDetailPackage.getAttItemId(), this.chainDate)) != null) {
            AttItemInstance attItemInstance = new AttItemInstance(attItemSpec, BigDecimal.valueOf(applyCount));
            this.attItemValues.add(this.buildAttItemValue(attItemInstance));
        }
        if (allowAbove && aboveApplyCount > 0 && (aboveAttItemSpec = this.attItemSpecData.getByBidAndDate(this.adConfigDetailPackage.getAboveAttItemId(), this.chainDate)) != null) {
            AttItemInstance aboveAttItemInstance = new AttItemInstance(aboveAttItemSpec, BigDecimal.valueOf(aboveApplyCount));
            this.attItemValues.add(this.buildAttItemValue(aboveAttItemInstance));
        }
    }

    private Tuple<Integer, Integer> getApplyCount(List<AdCalcData> adCalcDataList, boolean isLimitByCard) {
        int aboveApplyCount;
        int applyCount;
        boolean allowAbove = this.adConfigDetailPackage.isAllowAbove();
        String timeScope = this.adConfigDetailPackage.getTimeScope();
        Tuple<LocalDate, LocalDate> timeScopeRange = AdEntityUtils.getTimeScopeRange(timeScope, this.context.getAttPersonId(), this.context.getChainDate(), this.attPeriodTable);
        int count = this.adConfigDetailPackage.getCount();
        int hisApplyCount = 0;
        LocalDate beginDate = (LocalDate)timeScopeRange.getKey();
        if (isLimitByCard) {
            hisApplyCount = this.punchCardDataMap.entrySet().stream().filter(item -> ((LocalDate)item.getKey()).compareTo(beginDate) >= 0 && ((LocalDate)item.getKey()).compareTo(this.chainDate) < 0).mapToInt(item -> ((List)item.getValue()).size()).sum();
        } else {
            long reasonId = this.adConfigDetailPackage.getReasonId();
            for (Map.Entry<LocalDate, List<AdCalcData>> entry : this.punchCardDataMap.entrySet()) {
                if (entry.getKey().compareTo(beginDate) < 0 || entry.getKey().compareTo(this.chainDate) >= 0) continue;
                hisApplyCount += (int)entry.getValue().stream().filter(item -> item.getApplyReasonId() == reasonId).count();
            }
        }
        int size = adCalcDataList.size();
        if (allowAbove) {
            if (hisApplyCount >= count) {
                applyCount = 0;
                aboveApplyCount = size;
            } else {
                applyCount = Math.min(count - hisApplyCount, size);
                aboveApplyCount = size - applyCount;
            }
        } else {
            applyCount = size;
            aboveApplyCount = 0;
        }
        return new Tuple((Object)applyCount, (Object)aboveApplyCount);
    }

    private AttItemValue buildAttItemValue(AttItemInstance attItemInstance) {
        return (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(this.adConfigPackage.getId(), "wtp_countset"))).parentDataNodes(Collections.emptyList())).matchedRule(this.adConfigPackage)).build();
    }
}

