/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlatt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.attconfig.AttPlan;
import kd.wtc.wtes.business.model.attconfig.AttRule;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPlanEvalService {
    private static final Log LOG = LogFactory.getLog(AttPlanEvalService.class);
    private static final AttPlanEvalService INS = new AttPlanEvalService();
    private static final DateRangeServiceImpl DATA_RANGE_SERVICE = new DateRangeServiceImpl();

    public static AttPlanEvalService getInstance() {
        return INS;
    }

    private AttPlanEvalService() {
    }

    public AttRule getAttRuleByAttPlanAndDateInfo(AttPlan attPlan, LocalDate queryDate, TieContextStd context) {
        TimeSeqBo attRuleTimeSeqBos = null;
        if ("2".equals(attPlan.getSetRuleWay())) {
            RuleParam ruleParam = new RuleParam(RuleEngineEnum.att.getSceneNumber(), RuleEngineEnum.att.getBizApp(), attPlan.getTimeSeqInfo().getId());
            ruleParam.setScenePlanName(RuleEngineEnum.att.getScenePlanName());
            List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
            LOG.debug(ResManager.loadKDString((String)"attPlan:{},queryDate:{}\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}\u3002", (String)"AttPlanEvalService_0", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{attPlan.getNumber(), queryDate, policyResults});
            Long ruleId = this.getRuleIds(policyResults);
            RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
            if (ruleEngineMetaData == null) {
                LOG.debug("attPlan:{},queryDate:{}, ruleId={} . ruleEngineMetaData is null", new Object[]{attPlan.getNumber(), queryDate, ruleId});
                return null;
            }
            attRuleTimeSeqBos = (TimeSeqBo)ruleEngineMetaData.getBizRuleById(ruleId);
            if (attRuleTimeSeqBos == null) {
                LOG.debug("attPlan:{},queryDate:{ }, ruleId={} . attRuleTimeSeqBos is null", new Object[]{attPlan.getNumber(), queryDate, ruleId});
                return null;
            }
            attPlan.setAttRule((TimeSeqBo<AttRule>)attRuleTimeSeqBos);
        } else {
            attRuleTimeSeqBos = attPlan.getAttRule();
        }
        if (attRuleTimeSeqBos != null) {
            return (AttRule)attRuleTimeSeqBos.getVersionByDate(queryDate);
        }
        return null;
    }

    public AttRuleCal getAttRuleCalByAttRuleAndDateInfo_(AttRule attRule, DateType dateType, boolean off, DateAttribute dateAttribute, AttFileModel attFileModel, Map<Long, AttfileLimitScope> limitScopeMap) {
        List<AttRuleCal> attRuleCalList = this.getAttRuleListCalByAttRuleAndDateInfo(attRule, dateType, off, dateAttribute, attFileModel, limitScopeMap);
        if (attRuleCalList == null || attRuleCalList.isEmpty()) {
            return null;
        }
        return attRuleCalList.get(0);
    }

    public List<AttRuleCal> getAttRuleListCalByAttRuleAndDateInfo(AttRule attRule, DateType dateType, boolean off, DateAttribute dateAttribute, AttFileModel attFileModel, Map<Long, AttfileLimitScope> limitScopeMap) {
        List<AttRuleCal> attRuleCal = attRule.getAttRuleCal();
        AttfileLimitScopeServiceImpl limitScopeService = new AttfileLimitScopeServiceImpl();
        if (CollectionUtils.isEmpty(attRuleCal)) {
            return null;
        }
        ArrayList<AttRuleCal> attRuleCalList = new ArrayList<AttRuleCal>(attRuleCal.size());
        for (AttRuleCal ruleCal : attRuleCal) {
            AccessDto accessDto = ruleCal.getDateConditionAccessDto();
            String limitConditionJson = ruleCal.getLimitConditionJson();
            if (!DATA_RANGE_SERVICE.isSatisfyDateRange(dateType.getId(), dateAttribute.getCode(), Boolean.valueOf(off), accessDto).booleanValue() || !limitScopeService.matchLimit(limitScopeMap.get(attFileModel.getId()), limitConditionJson)) continue;
            attRuleCalList.add(ruleCal);
        }
        return attRuleCalList;
    }

    public AttRuleCal getAttRuleCalByAttRuleAndDateInfo(AttRule attRule, DateType dateType, boolean off, DateAttribute dateAttribute, AttFileModel attFileModel, TieContextStd context) {
        return this.getAttRuleCalByAttRuleAndDateInfo_(attRule, dateType, off, dateAttribute, attFileModel, ContextUtil.getLimitScopeMap(context));
    }

    private Long getRuleIds(List<PolicyResult> policyResults) {
        LinkedList ruleIds = Lists.newLinkedList();
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                Object obj = policyResult.getDefaultResults().get("wtp_attendrule");
                this.parseResultObj(obj, ruleIds);
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                Object obj = ruleResult.getMatchResults().get("wtp_attendrule");
                this.parseResultObj(obj, ruleIds);
            }
        }
        if (CollectionUtils.isEmpty((Collection)ruleIds)) {
            return null;
        }
        if (ruleIds.size() > 1) {
            throw new IllegalArgumentException("no more than one rule");
        }
        return (Long)ruleIds.get(0);
    }

    private void parseResultObj(Object obj, List<Long> ids) {
        if (obj instanceof DynamicObject) {
            ids.add(((DynamicObject)obj).getLong("id"));
        } else if (obj instanceof DynamicObjectCollection) {
            ids.addAll(((DynamicObjectCollection)obj).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        } else if (obj instanceof DynamicObject[]) {
            ids.addAll(Arrays.stream((DynamicObject[])obj).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
    }
}

