/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlex;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.business.plugin.PluginServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.rlex.ExCalHelper;
import kd.wtc.wtes.business.executor.rlex.ExConstant;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlex.ExConfigEntry;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.service.IAccessService;
import kd.wtc.wtes.business.service.ICusPlugFilterService;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.enums.ShiftType;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;

public class ExAbnormalEvaluator
implements TieEvaluatorStd {
    private static final Log log = LogFactory.getLog(ExAbnormalEvaluator.class);
    private TieContextStd context;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        TieDataResultStd dataResult = this.beforeEvaluator(context);
        return Objects.isNull(dataResult) ? this.doEvaluate(context, context.getRawTimeBuckets()) : dataResult;
    }

    private TieDataResultStd beforeEvaluator(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        if (exAttPackage == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5f02\u5e38\u65b9\u6848\u914d\u7f6e,chainDate[{0}]attpersonId[{1}]\u3002", (String)"ExAbnormalEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[]{chainDate, attPersonId})));
        }
        if (exAttPackage.isRuleEngine()) {
            Long exProcess;
            TimeSeqAvailableBo seqExRule;
            this.ruleEngineInit(context, exAttPackage);
            if (exAttPackage.getExRule() == null && (seqExRule = (TimeSeqAvailableBo)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exrule"), VScope.CHAIN)) != null) {
                exAttPackage.setExRule((TimeSeqAvailableBo<ExRulePackage>)seqExRule);
            }
            if (exAttPackage.getExProcess() == null && (exProcess = (Long)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exprocess"), VScope.CHAIN)) != null) {
                exAttPackage.setExProcess(exProcess);
            }
            return null;
        }
        TimeSeqAvailableBo<ExRulePackage> exRule = exAttPackage.getExRule();
        if (null == exRule || null == exRule.getVersionByDate(chainDate)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5f02\u5e38\u89c4\u5219\u914d\u7f6e,chainDate[{0}]attpersonId[{1}]\u3002", (String)"ExAbnormalEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[]{chainDate, attPersonId})));
        }
        return null;
    }

    private void ruleEngineInit(TieContextStd context, ExAttPackage exAttPackage) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.exs.getSceneNumber(), RuleEngineEnum.exs.getBizApp(), exAttPackage.getTimeSeqInfo().getId());
        ruleParam.setScenePlanName(RuleEngineEnum.exs.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        log.debug("ExAbnormalEvaluator_\u89c4\u5219\u5f15\u64ce\u7ed3\u679c {}", policyResults);
        ArrayList ruleIds = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList exProcessIds = Lists.newArrayListWithExpectedSize((int)10);
        RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
        for (PolicyResult policyResult : policyResults) {
            if (WTCCollections.isNotEmpty((Collection)policyResult.getRuleResults())) {
                log.debug("policyResult.getRuleResults() is not null ");
                for (RuleResult ruleResult : policyResult.getRuleResults()) {
                    Object exRule = ruleResult.getMatchResults().get("wtp_exrule");
                    this.getResId(ruleIds, exRule);
                    Object exProcess = ruleResult.getMatchResults().get("wtp_exprocess");
                    this.getResId(exProcessIds, exProcess);
                }
                continue;
            }
            Map defaultResults = policyResult.getDefaultResults();
            Object defaultExRule = defaultResults.get("wtp_exrule");
            this.getResId(ruleIds, defaultExRule);
            Object defaultProcess = defaultResults.get("wtp_exprocess");
            this.getResId(exProcessIds, defaultProcess);
        }
        log.debug("ExAbnormalEvaluator_ruleIds ={} ,exProcessIds={} ", (Object)ruleIds, (Object)exProcessIds);
        if (!CollectionUtils.isEmpty((Collection)ruleIds)) {
            TimeSeqAvailableBo exRuleTimeSeq = ruleIds.stream().map(id -> (TimeSeqAvailableBo)ruleEngineMetaData.getBizRuleById((Long)id)).filter(Objects::nonNull).findFirst().orElse(null);
            context.setVariable(ExCalHelper.getVariableKey(context, "wtp_exrule"), exRuleTimeSeq, VScope.CHAIN);
        }
        if (!CollectionUtils.isEmpty((Collection)exProcessIds)) {
            log.debug("ExAbnormalEvaluator_exProcessIds = {} ", (Object)exProcessIds);
            context.setVariable(ExCalHelper.getVariableKey(context, "wtp_exprocess"), exProcessIds.get(0), VScope.CHAIN);
        }
    }

    private void getResId(List<Long> ids, Object result) {
        if (null == result) {
            return;
        }
        log.debug("ExAbnormalEvaluator_result\u7c7b\u578b result={} ,name ={}", result.getClass(), (Object)result.getClass().getName());
        if (result instanceof DynamicObject) {
            DynamicObject dyn = (DynamicObject)result;
            ids.add(dyn.getLong("id"));
        } else if (result instanceof DynamicObject[]) {
            ids.add(((DynamicObject[])result)[0].getLong("id"));
        } else {
            throw new KDBizException(new ErrorCode("EX_006", ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u9519\u8bef\u3002", (String)"ExAbnormalEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        ArrayList res = Lists.newArrayList();
        this.invokeCal(attFileModel, context, dataNodes, res);
        return TieDataResultStd.success(res);
    }

    private void invokeCal(AttFileModel attFileModel, TieContextStd context, List<TieDataNodeStd> dataNodes, List<AttItemValue> res) {
        this.context = context;
        LocalDate chainDate = context.getChainDate();
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        Long exProcess = exAttPackage.isRuleEngine() ? (Long)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exprocess"), VScope.CHAIN) : exAttPackage.getExProcess();
        String mode = attFileModel.getAttMode(chainDate).getCode();
        ShiftTableSingle personalShiftTable = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shift = personalShiftTable.getShiftSpec(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        Map<Long, AccessDto> conditionsMap = ContextUtil.getDataRangeMap(context);
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        List<ExConfig> configList = this.getMatchConfigList(exAttPackage, chainDate);
        log.debug("ExAbnormalEvaluator_\u52a0\u8f7d\u914d\u7f6e_{}_\u6570\u91cf_{}_\u5f00\u59cb", (Object)chainDate, (Object)configList.size());
        for (ExConfig config : configList) {
            boolean shitAndMode;
            log.debug("ExAbnormalEvaluator_\u539f\u59cb\u65f6\u95f4\u5bf9_\u8ba1\u7b97\u65e5\u671f_{}_{}", (Object)chainDate, (Object)config.getNumber());
            boolean bl = shitAndMode = !this.checkLimitConditions(config.getConditionInfo(), mode, shift);
            if (shitAndMode) {
                log.debug("ExAbnormalEvaluator_\u5f53\u5929\u4e0d\u8bb0\u5f55\u5f02\u5e38_{}_{}  ", (Object)chainDate, (Object)config.getNumber());
                continue;
            }
            List<TimeBucketStd> timeBucketStd = this.sourceFilter(config, context, dataNodes);
            if (CollectionUtils.isEmpty(timeBucketStd)) {
                log.debug("ExAbnormalEvaluator_\u5f02\u5e38\u8ba1\u7b97\u6570\u636e\u6e90\u8fc7\u6ee4\u8017_chainDate_{}_number_{}", (Object)chainDate, (Object)config.getNumber());
                continue;
            }
            List<TimeBucket> dateRangeFiltertimeBuckets = dateRangeService.filterDataNodes(WTCDateRangeSource.EX, context, timeBucketStd, conditionsMap.get(config.getId()));
            if (CollectionUtils.isEmpty(dateRangeFiltertimeBuckets)) {
                log.debug("ExAbnormalEvaluator_\u5f02\u5e38\u8ba1\u7b97\u65e5\u671f\u5c5e\u6027\u8fc7\u6ee4_chainDate_{}_number={}", (Object)chainDate, (Object)config.getNumber());
                continue;
            }
            List timeBucketList = dateRangeFiltertimeBuckets.stream().filter(timeBucket -> this.isFlexAttendance(config, (TimeBucket)timeBucket, shift)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(timeBucketList)) {
                log.debug("ExAbnormalEvaluator_\u5f02\u5e38\u8ba1\u7b97\u5f39\u6027\u51fa\u52e4\u65f6\u6bb5\u8fc7\u6ee4_chainDate_{}_number={}", (Object)chainDate, (Object)config.getNumber());
                continue;
            }
            Map<Long, List<TimeBucket>> finalTimeBucket = timeBucketList.stream().collect(Collectors.groupingBy(TimeBucket::getShouldPunchCardSeqId));
            List timeBucket2 = dataNodes.stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
            List<TimeBucket> timeBucke = timeBucket2.stream().map(TimeBucketStd::unwrapAndCopy).collect(Collectors.toList());
            this.exportAttItem(timeBucke, finalTimeBucket, config, res, chainDate, attItemSpecData, exProcess, shift);
        }
    }

    private void exportAttItem(List<TimeBucket> dateRangeFiltertimeBuckets, Map<Long, List<TimeBucket>> groupTimeBucket, ExConfig config, List<AttItemValue> res, LocalDate chainDate, AttItemSpecData attItemSpecData, Long exProcess, ShiftSpec shift) {
        List<ExConfigEntry> entryList = config.getEntryList();
        if (CollectionUtils.isEmpty(groupTimeBucket) || CollectionUtils.isEmpty(entryList)) {
            return;
        }
        for (Map.Entry<Long, List<TimeBucket>> entryMap : groupTimeBucket.entrySet()) {
            Long origAttItem;
            List<TimeBucket> timeBuckets = entryMap.getValue();
            boolean shiftSeq = this.checkShiftTimeBucketSeqEqual(timeBuckets);
            int seconds = timeBuckets.stream().mapToInt(TimeBucket::getDurationOfSecond).sum();
            BigDecimal day = shift.secondsToDays(seconds);
            if (config.isAllPunchCard()) {
                origAttItem = entryList.get(0).getOrigAttItem();
            } else {
                ExConfigEntry exConfigEntry = entryList.stream().filter(entry -> entry.getPunchCard().equals(entryMap.getKey())).findFirst().orElse(null);
                if (null == exConfigEntry) continue;
                origAttItem = exConfigEntry.getOrigAttItem();
            }
            AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(origAttItem, chainDate);
            AttItemInstance newItemInstance = new AttItemInstance(attitemSpec, null, day, BigDecimal.valueOf(seconds), null);
            String exTypeIdStr = null == config.getExTypeId() ? "" : config.getExTypeId().toString();
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_attr", (String)exTypeIdStr));
            String exProcessStr = null == exProcess ? "" : exProcess.toString();
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"exProcess", (String)exProcessStr));
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_punchCard", (String)entryMap.getKey().toString()));
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_punchPoint", (String)this.getPunchPoint(dateRangeFiltertimeBuckets, entryMap, chainDate, true)));
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_origAttItem", (String)JSONObject.toJSONString(Collections.singletonList(origAttItem))));
            newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_origAttItem_v", (String)(seconds + "")));
            if (shiftSeq) {
                Long bucketSeqId = timeBuckets.get(0).getShiftTimeBucketSeqId();
                String bucketSeqIdStr = null == bucketSeqId ? "" : bucketSeqId.toString();
                newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_shitCard", (String)bucketSeqIdStr));
            }
            ArrayList parentNode = Lists.newArrayListWithExpectedSize((int)timeBuckets.size());
            HashSet set = Sets.newHashSet();
            timeBuckets.forEach(timeBucket -> timeBucket.parentDataNodes().forEach(dateNode -> {
                if (!set.contains(dateNode.getId())) {
                    parentNode.add(dateNode);
                    set.add(dateNode.getId());
                }
            }));
            AttItemValue attItemValue = ExCalHelper.getAttItemValue(parentNode, config, newItemInstance);
            res.add(attItemValue);
        }
    }

    private String getPunchPoint(List<TimeBucket> dateRangeFiltertimeBuckets, Map.Entry<Long, List<TimeBucket>> entryMap, LocalDate chainDate, boolean simpleDateTime) {
        String punchPoint = null;
        punchPoint = this.getPunchPoint(entryMap.getValue(), chainDate, simpleDateTime);
        log.debug("HRStringUtils.isEmpty(punchPoint):{}", (Object)entryMap.getValue().get(0).getStartTime());
        if (HRStringUtils.isEmpty((String)punchPoint)) {
            Long punchCardId = entryMap.getKey();
            List<TimeBucket> punchCardMatchTimeBuckets = dateRangeFiltertimeBuckets.stream().filter(bucket -> punchCardId.equals(bucket.getShouldPunchCardSeqId()) && bucket.getPunchCardTag().equals(((TimeBucket)((List)entryMap.getValue()).get(0)).getPunchCardTag())).collect(Collectors.toList());
            punchPoint = this.getPunchPoint(punchCardMatchTimeBuckets, chainDate, simpleDateTime);
        }
        return punchPoint;
    }

    private String getPunchPoint(List<TimeBucket> timeBucketStds, LocalDate chainDate, boolean simpleDateTime) {
        List points = timeBucketStds.stream().filter(timeBucketStd -> timeBucketStd.getStartTimePointSource().isCardSupposedIn() || timeBucketStd.getStartTimePointSource().isCardSupposedOut() || timeBucketStd.getEndTimePointSource().isCardSupposedIn() || timeBucketStd.getEndTimePointSource().isCardSupposedOut()).map(timeBucketStd -> {
            ArrayList tempList = Lists.newArrayListWithExpectedSize((int)2);
            if (timeBucketStd.getPunchCardTag().equals(PunchCardTagEnum.IN_ABSENT.code)) {
                if (timeBucketStd.getStartTimePointSource().isCardSupposedIn()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getStartTime()));
                }
                if (timeBucketStd.getEndTimePointSource().isCardSupposedIn()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getEndTime()));
                }
            } else if (timeBucketStd.getPunchCardTag().equals(PunchCardTagEnum.OUT_ABSENT.code)) {
                if (timeBucketStd.getStartTimePointSource().isCardSupposedOut()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getStartTime()));
                }
                if (timeBucketStd.getEndTimePointSource().isCardSupposedOut()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getEndTime()));
                }
            } else {
                if (timeBucketStd.getStartTimePointSource().isCardSupposedIn() || timeBucketStd.getStartTimePointSource().isCardSupposedOut()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getStartTime()));
                }
                if (timeBucketStd.getEndTimePointSource().isCardSupposedIn() || timeBucketStd.getEndTimePointSource().isCardSupposedOut()) {
                    tempList.add(this.getTimeCheckRes(timeBucketStd.getEndTime()));
                }
            }
            return String.join((CharSequence)",", tempList);
        }).collect(Collectors.toList());
        ArrayList pointsOfSingle = Lists.newArrayListWithCapacity((int)8);
        points.stream().filter(HRStringUtils::isNotEmpty).map(po -> Arrays.asList(po.split(","))).forEach(pointsOfSingle::addAll);
        String resStr = this.simpleDateTime(pointsOfSingle, chainDate, simpleDateTime);
        if (resStr.length() > 500) {
            resStr = resStr.substring(0, resStr.substring(0, 500).lastIndexOf(44));
        }
        return resStr;
    }

    private String simpleDateTime(List<String> pointsOfSingle, LocalDate chainDate, boolean simpleDateTime) {
        String resStr;
        if (!simpleDateTime) {
            return String.join((CharSequence)",", pointsOfSingle);
        }
        boolean flag = false;
        for (String point : pointsOfSingle) {
            if (point.contains(chainDate.toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            resStr = String.join((CharSequence)",", pointsOfSingle);
        } else {
            List res = pointsOfSingle.stream().map(po -> po.substring(chainDate.toString().length() + 1)).collect(Collectors.toList());
            resStr = String.join((CharSequence)",", res);
        }
        return resStr;
    }

    private String getTimeCheckRes(LocalDateTime time) {
        if (time == null) {
            return "";
        }
        return time.toString().replace('T', ' ');
    }

    private List<ExConfig> getMatchConfigList(ExAttPackage exAttPackage, LocalDate chainDate) {
        TimeSeqAvailableBo seqExRule = exAttPackage.isRuleEngine() ? (TimeSeqAvailableBo)this.context.getVariable(ExCalHelper.getVariableKey(this.context, "wtp_exrule"), VScope.CHAIN) : exAttPackage.getExRule();
        if (null == seqExRule) {
            return Collections.emptyList();
        }
        return ((ExRulePackage)seqExRule.getVersionByDate(chainDate)).getConfigList().stream().map(config -> (ExConfig)config.getVersionByDate(chainDate)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean checkLimitConditions(RuleConditionInfo accessDto, String mode, ShiftSpec shift) {
        if (accessDto == null) {
            return true;
        }
        LinkedHashMap dataMap = Maps.newLinkedHashMap();
        HashMap param = Maps.newHashMapWithExpectedSize((int)ExConstant.NUMBER_2);
        String shitType = shift.getShiftType().getCode();
        param.put("attmethod", mode);
        param.put("shifttype", shitType);
        long id = IDService.get().genLongId();
        dataMap.put(id, param);
        JudgeResult judge = JudgeConditionService.judge((LinkedHashMap)dataMap, (RuleConditionInfo)accessDto);
        log.debug("ExAbnormalEvaluator_\u6761\u4ef6\u5224\u65ad\u8003\u52e4\u65b9\u5f0f \u548c \u73ed\u6b21\u7c7b\u578b {}", (Object)judge);
        return judge.isMatched();
    }

    private boolean isOff(ShiftSpec shift) {
        return shift.isOff();
    }

    private List<TimeBucketStd> sourceFilter(ExConfig config, TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (config.isCustom()) {
            return this.CusPlugFilter(config, dataNodes);
        }
        ConfigMix configMix = ContextUtil.getConfigMix(context);
        BizDataSource dataSource = configMix.getDataSource(BizTypeEnum.EX, config.getExTypeId());
        if (null == dataSource || null == dataSource.getDatasourceId()) {
            return Collections.emptyList();
        }
        IAccessService accessService = (IAccessService)WTCAppContextHelper.getBean(AccessServiceImpl.class);
        return accessService.accessFilterByCondition(dataNodes, dataSource.getCondition()).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
    }

    private List<TimeBucketStd> CusPlugFilter(ExConfig config, List<TieDataNodeStd> dataNodes) {
        try {
            ICusPlugFilterService cusPlug = (ICusPlugFilterService)PluginServiceHelper.getPluginObject(ICusPlugFilterService.class, (Long)config.getPeriodFilter());
            return cusPlug.filterDate(dataNodes).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("\u5f02\u5e38\u5ba2\u6237\u81ea\u5b9a\u4e49\u65f6\u6bb5\u6570\u636e\u8fc7\u6ee4\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean isFlexAttendance(ExConfig config, TimeBucket timeBucket, ShiftSpec shift) {
        if (config.isFlexAttendance()) {
            if (shift.getShiftType() == ShiftType.PARFLEXSHIFT) {
                return timeBucket.getShiftTimeBucketProperty() != ShiftTimeBucketPropertyEnum.ATTENDANCE;
            }
            return true;
        }
        return true;
    }

    private boolean checkShiftTimeBucketSeqEqual(List<TimeBucket> timeBuckets) {
        if (CollectionUtils.isEmpty(timeBuckets)) {
            return true;
        }
        Long firstSeq = null;
        for (int i = 0; i < timeBuckets.size(); ++i) {
            TimeBucket timeBucket = timeBuckets.get(i);
            Long bucketSeqId = timeBucket.getShiftTimeBucketSeqId();
            if (i == 0) {
                firstSeq = bucketSeqId;
                continue;
            }
            if (bucketSeqId.equals(firstSeq)) continue;
            return false;
        }
        return true;
    }
}

