/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlex;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlex.ExConfigEntry;
import kd.wtc.wtes.business.model.rlex.ExRuleEntry;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.business.model.rlexenum.DurationUnitEnum;
import kd.wtc.wtes.business.model.rlexenum.ExDealTypeEnum;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;

public class ExCalHelper {
    public static DynamicObject[] getHisDyArr(String pageKey, Set<Long> planIdSet, LocalDate startDate, LocalDate endDate) {
        if (planIdSet == null || planIdSet.size() == 0) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageKey);
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(planIdSet, startDate, endDate);
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    private static TimeSeqInfo getTimeSeqEntity(DynamicObject entity) {
        return TimeSeqEntityGenerateUtils.getTimeSeqEntity(entity);
    }

    public static List<ExAttPackage> getExSchemeHisList(List<DynamicObject> schemeDyList, Map<Long, List<DynamicObject>> ruleHisMap, Map<Long, List<DynamicObject>> configHisMap) {
        ArrayList ruleHisList = Lists.newArrayListWithExpectedSize((int)schemeDyList.size());
        for (DynamicObject schemeHis : schemeDyList) {
            TimeSeqInfo timeSeqEntity = ExCalHelper.getTimeSeqEntity(schemeHis);
            ExAttPackage vaAttPackage = new ExAttPackage(schemeHis.getLong("id"), schemeHis.getString("number"), timeSeqEntity);
            if ("2".equals(schemeHis.getString("srw"))) {
                vaAttPackage.setRuleEngine(true);
            } else {
                TimeSeqAvailableBo<ExRulePackage> exRule = ExCalHelper.getExRule(schemeHis.getLong("rule.id"), ruleHisMap, configHisMap);
                vaAttPackage.setExProcess(schemeHis.getLong("exprocess.id"));
                vaAttPackage.setExRule(exRule);
            }
            vaAttPackage.setAttItem(schemeHis.getLong("atdattitem.id"));
            ruleHisList.add(vaAttPackage);
        }
        return ruleHisList;
    }

    public static Map<Long, List<DynamicObject>> getExConfMap(LocalDate startDate, LocalDate endDate, DynamicObject[] exRuleHisArr) {
        Set<Long> configIdHisSet = ExCalHelper.getConfigIdList(exRuleHisArr);
        DynamicObject[] exConfigArr = ExCalHelper.getHisDyArr("wtp_exconfig", configIdHisSet, startDate, endDate);
        return Arrays.stream(exConfigArr).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    private static Set<Long> getConfigIdList(DynamicObject[] exRuleHisArr) {
        HashSet configIdHisSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject exRuleHis : exRuleHisArr) {
            DynamicObjectCollection entryList = exRuleHis.getDynamicObjectCollection("ruleentryentity");
            for (DynamicObject entry : entryList) {
                Long configId = entry.getLong("exconfigid.id");
                configIdHisSet.add(configId);
            }
        }
        return configIdHisSet;
    }

    public static TimeSeqAvailableBo<ExRulePackage> getExRule(long exRuleId, Map<Long, List<DynamicObject>> ruleHisMap, Map<Long, List<DynamicObject>> configHisMap) {
        List<DynamicObject> ruleHisList = ruleHisMap.get(exRuleId);
        if (CollectionUtils.isEmpty(ruleHisList)) {
            return null;
        }
        ArrayList<ExRulePackage> ruleList = new ArrayList<ExRulePackage>(ruleHisList.size());
        for (DynamicObject ruleHis : ruleHisList) {
            DynamicObjectCollection entryEntity = ruleHis.getDynamicObjectCollection("entryentity");
            List<ExRuleEntry> exEntityList = ExCalHelper.getExProjectEntityList(entryEntity);
            DynamicObjectCollection ruleEntryEntity = ruleHis.getDynamicObjectCollection("ruleentryentity");
            ArrayList exConfigList = Lists.newArrayList();
            for (DynamicObject ruleEntry : ruleEntryEntity) {
                Long exConfigId = ruleEntry.getLong("exconfigid.id");
                TimeSeqAvailableBo<ExConfig> exConfig = ExCalHelper.getConfigList(exConfigId, configHisMap);
                exConfigList.add(exConfig);
            }
            ExRulePackage exRulePackage = new ExRulePackage(ruleHis.getLong("id"), ruleHis.getString("number"), ExCalHelper.getTimeSeqEntity(ruleHis));
            exRulePackage.setConfigList(exConfigList);
            exRulePackage.setEntryPackageList(exEntityList);
            ruleList.add(exRulePackage);
        }
        return new TimeSeqAvailableBo(ruleList);
    }

    private static TimeSeqAvailableBo<ExConfig> getConfigList(Long exConfigId, Map<Long, List<DynamicObject>> configHisMap) {
        if (CollectionUtils.isEmpty(configHisMap) || CollectionUtils.isEmpty((Collection)configHisMap.get(exConfigId))) {
            return null;
        }
        List<DynamicObject> configHisListDyn = configHisMap.get(exConfigId);
        ArrayList configList = Lists.newArrayListWithExpectedSize((int)configHisListDyn.size());
        for (DynamicObject config : configHisListDyn) {
            ExConfig.ExConfigBuilder builder = ExConfig.ExConfigBuilder.newEmp();
            builder.id(config.getLong("id")).number(config.getString("number")).timeSeqEntity(ExCalHelper.getTimeSeqEntity(config)).exTypeId(config.getLong("exattribute.id")).isCustom(config.getBoolean("iscustom")).isAllPunchCard(config.getBoolean("isallpunchcard")).isFlexAttendance(config.getBoolean("isflexibleattperiod")).conditions(config.getString("limitfilter")).periodFilter(config.getLong("periodfilter.id"));
            DynamicObjectCollection aEntryEntity = config.getDynamicObjectCollection("entryentity");
            ArrayList entryList = Lists.newArrayList();
            builder.entryList(entryList);
            for (DynamicObject entryInfo : aEntryEntity) {
                ExConfigEntry.ExConfigEntryBuilder entryBuilder = ExConfigEntry.ExConfigEntryBuilder.getEmp();
                entryBuilder.id(entryInfo.getLong("id")).origAttItem(entryInfo.getLong("originalitem.id")).backSet(entryInfo.getString("conditionfilter")).are(entryInfo.getString("are")).culValue(entryInfo.getBigDecimal("culvalue")).unit(DurationUnitEnum.getByCode(entryInfo.getString("culunit"))).logic("and").bre(entryInfo.getString("bre")).maxValue(entryInfo.getBigDecimal("maxvalue")).aunit(DurationUnitEnum.getByCode(entryInfo.getString("maxunit"))).roundRule(entryInfo.getLong("roundrule.id")).dealMethod(entryInfo.getString("dealmethod")).timeValue(entryInfo.getBigDecimal("appointvalue")).appointUnit(DurationUnitEnum.getByCode(entryInfo.getString("appointunit"))).dealType(ExDealTypeEnum.getByCode(entryInfo.getString("dealtype"))).punchCard(entryInfo.getLong("punchcard.id"));
                List<Long> attItems = entryInfo.getDynamicObjectCollection("attitems").stream().filter(Objects::nonNull).map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                entryBuilder.resultAttItems(attItems);
                entryList.add(entryBuilder.build());
            }
            configList.add(builder.build());
        }
        return new TimeSeqAvailableBo((Collection)configList);
    }

    public static AttItemValue getChangeAttItemValue(List<TieDataNodeStd> nodeStdList, AttItemInstance newItemInstance, ExRulePackage exRule, ExRuleEntry ruleEntry) {
        return (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(newItemInstance)).parentDataNodes(nodeStdList)).evaluationRule(EvaluationRuleModel.of(exRule.getId(), "wtp_exrule"))).matchedRule(ruleEntry)).build();
    }

    public static AttItemValue getAttItemValue(List<TieDataNodeStd> parentNode, ExConfig config, AttItemInstance newItemInstance) {
        return (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(newItemInstance)).parentDataNodes(parentNode)).evaluationRule(EvaluationRuleModel.of(config.getId(), "wtp_exconfig"))).matchedRule((IEntity)config)).build();
    }

    public static AttItemValue getAttItemValue(AttItemValueStd attItemValueStd, ExConfigEntry configEntry, AttItemInstance newItemInstance) {
        ExConfig exConfig = (ExConfig)attItemValueStd.getMatchedRule();
        return (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(newItemInstance)).parentDataNodes(Collections.singletonList(attItemValueStd))).evaluationRule(EvaluationRuleModel.of(exConfig.getId(), "wtp_exconfig"))).matchedRule(configEntry)).build();
    }

    public static AttItemValue changeToAttItemValue(AttItemValueStd attItemValueStd) {
        AttItemInstance origItem = attItemValueStd.getAttItemInstance();
        AttItemInstance attItemInstance = new AttItemInstance(origItem.getAttItemSpec(), null, origItem.getDay(), origItem.getSecondDecimal(), null);
        attItemInstance.getExtraLabels().addAll(origItem.getExtraLabels());
        attItemInstance.getExtraLabels().add((ILabel)Label.of((String)"origAttItem", (String)Boolean.TRUE.toString()));
        return (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(Collections.singletonList(attItemValueStd))).evaluationRule(attItemValueStd.getEvaluationRule())).matchedRule(attItemValueStd.getMatchedRule())).build();
    }

    private static List<ExRuleEntry> getExProjectEntityList(DynamicObjectCollection entryEntity) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return list;
        }
        entryEntity.forEach(dy -> {
            ExRuleEntry.ExRuleEntryBuilder builder = ExRuleEntry.ExRuleEntryBuilder.newEmp();
            builder.id(dy.getLong("id"));
            builder.rela(dy.getString("rela"));
            builder.value(dy.getBigDecimal("value"));
            builder.vunit(DurationUnitEnum.getByCode(dy.getString("vunit")));
            builder.rawConvertValue(DurationUnitEnum.changeValueToSecond(dy.getString("vunit"), dy.getBigDecimal("value")));
            builder.logic(dy.getString("logic"));
            builder.relas(dy.getString("relas"));
            builder.values(dy.getBigDecimal("values"));
            builder.vunits(DurationUnitEnum.getByCode(dy.getString("vunits")));
            builder.rawConvertValues(DurationUnitEnum.changeValueToSecond(dy.getString("vunits"), dy.getBigDecimal("values")));
            builder.dealType(dy.getString("dealtype"));
            builder.addValue(dy.getBigDecimal("appointvalue"));
            builder.appointUnit(DurationUnitEnum.getByCode(dy.getString("appointunit")));
            DynamicObjectCollection attItem = dy.getDynamicObjectCollection("attitem");
            Set<Long> attIds = attItem.stream().filter(Objects::nonNull).map(att -> att.getLong("fbasedataid.id")).collect(Collectors.toSet());
            builder.attItemIds(attIds);
            builder.resAttItem(dy.getLong("resattitem.id"));
            builder.exAttribute(dy.getLong("exattribute.id"));
            list.add(builder.build());
        });
        return list;
    }

    public static StringBuilder conditionParse(List<SimpleFilterRow> filterRow, Map<String, String> param) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < filterRow.size(); ++index) {
            SimpleFilterRow row = filterRow.get(index);
            if (!"105".equals(row.getCompareType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\u8ba1\u7b97\u6761\u4ef6\u89e3\u6790\u5f02\u5e38,\u6761\u4ef6\u4e0d\u662f\u7b49\u4e8e\u3002", (String)"ExCalHelper_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            ExCalHelper.bracket(sb, row.getLeftBracket());
            ExCalHelper.fileName(param, sb, row);
            ExCalHelper.bracket(sb, row.getRightBracket());
            ExCalHelper.logic(filterRow, sb, index, row);
        }
        return sb;
    }

    private static void logic(List<SimpleFilterRow> filterRow, StringBuilder sb, int index, SimpleFilterRow row) {
        if (StringUtils.isNotEmpty((String)row.getLogic()) && index < filterRow.size() - 1) {
            if (row.getLogic().equals("0")) {
                sb.append("and").append(' ');
            } else if (row.getLogic().equals("1")) {
                sb.append("or").append(' ');
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\u8ba1\u7b97\u6761\u4ef6\u89e3\u6790\u5f02\u5e38,\u6761\u4ef6\u5173\u7cfb(\u5e76\u4e14\u548c\u6216\u8005)", (String)"ExCalHelper_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
        }
    }

    private static void bracket(StringBuilder sb, String bracket) {
        if (StringUtils.isNotEmpty((String)bracket)) {
            if (bracket.contains("(")) {
                sb.append(bracket.replaceAll("\\(", "\\( "));
            }
            if (bracket.contains(")")) {
                sb.append(bracket.replaceAll("\\)", "\\) "));
            }
        }
    }

    private static void fileName(Map<String, String> param, StringBuilder sb, SimpleFilterRow row) {
        String fieldName = row.getFieldName();
        String value = param.get(fieldName);
        if (StringUtils.isNotEmpty((String)fieldName) && StringUtils.isNotEmpty((String)value)) {
            sb.append(((FilterValue)row.getValue().get(0)).getValue()).append(" == ").append(value).append(' ');
        }
    }

    public static List<SimpleFilterRow> parseCondition(String conditions) {
        if (StringUtils.isEmpty((String)conditions)) {
            return Collections.emptyList();
        }
        FilterCondition filterCondition = (FilterCondition)JSONObject.parseObject((String)conditions, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        if (CollectionUtils.isEmpty((Collection)filterRow)) {
            return Collections.emptyList();
        }
        return filterRow;
    }

    public static String getVariableKey(TieContextStd context, String append) {
        String chainDate = WTCDateUtils.format((LocalDate)context.getChainDate());
        long attPersonId = context.getAttPersonId();
        return attPersonId + chainDate + append;
    }
}

