/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlex;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.rlex.ExCalHelper;
import kd.wtc.wtes.business.executor.rlex.ExConstant;
import kd.wtc.wtes.business.executor.rlex.ExExtHelper;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rlex.ExRuleEntry;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.business.model.rlexenum.DurationUnitEnum;
import kd.wtc.wtes.business.model.rlexenum.ExDealMethodEnum;
import kd.wtc.wtes.business.model.util.ParserUtil;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;

public class ExChangeEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(ExChangeEvaluator.class);
    private static final char NULL_STR = ' ';

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        TieDataResultStd tieDataResultStd = this.beforeEvaluator(context);
        if (null != tieDataResultStd) {
            return tieDataResultStd;
        }
        List<TieDataNodeStd> allDataNodes = context.getAllDataNodes();
        return this.doEvaluate(context, allDataNodes);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        ArrayList<AttItemValue> res = new ArrayList<AttItemValue>();
        this.changEvaluator(context, dataNodes, res);
        return TieDataResultStd.success(res);
    }

    private TieDataResultStd beforeEvaluator(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        if (exAttPackage == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5f02\u5e38\u65b9\u6848\u914d\u7f6e,chainDate[{0}]attpersonId[{1}]\u3002", (String)"ExChangeEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[]{chainDate, attPersonId})));
        }
        TimeSeqAvailableBo exRule = exAttPackage.isRuleEngine() ? (TimeSeqAvailableBo)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exrule"), VScope.CHAIN) : exAttPackage.getExRule();
        if (null == exRule || null == exRule.getVersionByDate(chainDate)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5f02\u5e38\u89c4\u5219\u914d\u7f6e,chainDate[{0}]attpersonId[{1}]\u3002", (String)"ExChangeEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[]{"wtc-wtes-business", chainDate, attPersonId})));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void changEvaluator(TieContextStd context, List<TieDataNodeStd> dataNodes, List<AttItemValue> res) {
        Long exProcess;
        TimeSeqAvailableBo exRulePackageSeq;
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        Map<String, Object> map = this.mergeResult(context, dataNodes);
        Map groupMap = (Map)map.get("groupMap");
        Map parentsNodesMap = (Map)map.get("parentsNodesMap");
        LocalDate chainDate = context.getChainDate();
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        Long diffAttItemId = exAttPackage.getAttItem();
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        if (exAttPackage.isRuleEngine()) {
            exRulePackageSeq = (TimeSeqAvailableBo)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exrule"), VScope.CHAIN);
            exProcess = (Long)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exprocess"), VScope.CHAIN);
        } else {
            exRulePackageSeq = exAttPackage.getExRule();
            exProcess = exAttPackage.getExProcess();
        }
        ExRulePackage exRulePackage = (ExRulePackage)exRulePackageSeq.getVersionByDate(chainDate);
        for (ExRuleEntry ruleEntry : exRulePackage.getEntryPackageList()) {
            Set<Long> itemIds = ruleEntry.getAttItemIds();
            List<AttItemInstance> attItemInstances = itemIds.stream().filter(groupMap::containsKey).map(groupMap::get).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(attItemInstances)) continue;
            BigDecimal seconds = BigDecimal.ZERO;
            for (AttItemInstance attItemInstance : attItemInstances) {
                seconds = seconds.add(attItemInstance.getSecondDecimal());
            }
            if (!this.ruleCheck(ruleEntry, seconds).booleanValue()) continue;
            List<Long> changeAttItemIds = attItemInstances.stream().map(attItem -> attItem.getAttItemSpec().getBid()).collect(Collectors.toList());
            ArrayList listNode = Lists.newArrayListWithCapacity((int)2);
            for (AttItemInstance attItemInstance : attItemInstances) {
                listNode.addAll((Collection)parentsNodesMap.get(attItemInstance.getAttItemSpec().getBid()));
            }
            BigDecimal bigDecimal = shiftSpec.secondsToDays(seconds);
            if (ExDealMethodEnum.DEAL_TYPE_A == ExDealMethodEnum.getByCode(ruleEntry.getDealType())) {
                AttItemInstance resItemInstance = this.getResItemInstance(attItemSpecData, chainDate, ruleEntry, bigDecimal, seconds, changeAttItemIds, exProcess, seconds);
                this.addExtantFlag(attItemInstances, resItemInstance);
                AttItemValue resTimeBucket = ExCalHelper.getChangeAttItemValue(listNode, resItemInstance, exRulePackage, ruleEntry);
                res.add(resTimeBucket);
                continue;
            }
            if (ExDealMethodEnum.DEAL_TYPE_B == ExDealMethodEnum.getByCode(ruleEntry.getDealType())) {
                void var24_31;
                BigDecimal appointSeconds;
                if (DurationUnitEnum.UNIT_DAY == ruleEntry.getAppointUnit()) {
                    appointSeconds = shiftSpec.daysToSecondDecimal(ruleEntry.getAddValue());
                    BigDecimal bigDecimal2 = ruleEntry.getAddValue();
                } else {
                    appointSeconds = DurationUnitEnum.changeValueToSecond(ruleEntry.getAppointUnit().getCode(), ruleEntry.getAddValue());
                    BigDecimal bigDecimal3 = shiftSpec.secondsToDays(appointSeconds);
                }
                AttItemInstance resItemInstance = this.getResItemInstance(attItemSpecData, chainDate, ruleEntry, (BigDecimal)var24_31, appointSeconds, changeAttItemIds, exProcess, seconds);
                this.addExtantFlag(attItemInstances, resItemInstance);
                AttItemValue resTimeBucket = ExCalHelper.getChangeAttItemValue(listNode, resItemInstance, exRulePackage, ruleEntry);
                res.add(resTimeBucket);
                AttItemSpec diffItemSpec = attItemSpecData.getByBidAndDate(diffAttItemId, chainDate);
                BigDecimal diffSeconds = seconds.subtract(appointSeconds);
                BigDecimal bigDecimal4 = shiftSpec.secondsToDays(diffSeconds.abs());
                this.exportDiffAttItem(exRulePackage, diffItemSpec, res, ruleEntry, diffSeconds, bigDecimal4, listNode);
                continue;
            }
            throw new WtesBizException(new ErrorCode("002", ResManager.loadKDString((String)"\u820d\u5165\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u4e0d\u5408\u683c\u3002", (String)"ExChangeEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[0]);
        }
        res.forEach(item -> item.getAttItemInstances().forEach(attItem -> attItem.getExtraLabels().add((ILabel)Label.of((String)"exFilterType", (String)"exConvert"))));
        long exProcessL = exProcess == null ? 0L : exProcess;
        ExExtHelper.afterExecEx(context, res, exRulePackage, exProcessL);
    }

    private void addExtantFlag(List<AttItemInstance> attItemInstances, AttItemInstance resItemInstance) {
        String punchCard = null;
        StringBuilder punchCardPoint = new StringBuilder();
        TreeSet<String> punchCardPointSet = new TreeSet<String>();
        boolean punchCardFlag = true;
        for (AttItemInstance instance : attItemInstances) {
            String punchCardStr = instance.getExtraLabels().getValue("ex_punchCard");
            String punchCardPointStr = instance.getExtraLabels().getValue("ex_punchPoint");
            if (WTCStringUtils.isEmpty(punchCard) && WTCStringUtils.isNotEmpty((String)punchCardStr)) {
                punchCard = punchCardStr;
            }
            if (!WTCStringUtils.equals(punchCard, (String)punchCardStr)) {
                punchCardFlag = false;
            }
            if (!WTCStringUtils.isNotEmpty((String)punchCardPointStr)) continue;
            for (String s : punchCardPointStr.split(",")) {
                punchCardPointSet.add(s);
            }
        }
        if (punchCardFlag) {
            resItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_punchCard", punchCard));
        }
        for (String s : punchCardPointSet) {
            if (WTCStringUtils.isNotEmpty((String)punchCardPoint.toString())) {
                punchCardPoint.append(",");
            }
            punchCardPoint.append(s);
        }
        if (WTCStringUtils.isNotEmpty((String)punchCardPoint.toString())) {
            resItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_punchPoint", (String)punchCardPoint.toString()));
        }
    }

    private void exportDiffAttItem(ExRulePackage exRule, AttItemSpec diffItemSpec, List<AttItemValue> res, ExRuleEntry ruleEntry, BigDecimal diffSeconds, BigDecimal day, List<TieDataNodeStd> listNode) {
        if (diffSeconds.compareTo(BigDecimal.ZERO) != 0) {
            if (diffSeconds.compareTo(BigDecimal.ZERO) < 0) {
                day = day.multiply(new BigDecimal("-1"));
            }
            AttItemInstance diffItem = new AttItemInstance(diffItemSpec, null, day, diffSeconds, null);
            diffItem.getExtraLabels().add((ILabel)Label.of((String)"ex_no_export", (String)Boolean.TRUE.toString()));
            res.add(ExCalHelper.getChangeAttItemValue(listNode, diffItem, exRule, ruleEntry));
        }
    }

    private AttItemInstance getResItemInstance(AttItemSpecData attItemSpecData, LocalDate chainDate, ExRuleEntry ruleEntry, BigDecimal day, BigDecimal seconds, List<Long> changeAttItemIds, Long exProcess, BigDecimal oriItemValue) {
        AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(ruleEntry.getResAttItem(), chainDate);
        AttItemInstance itemInstance = new AttItemInstance(attitemSpec, null, day, seconds, null);
        itemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_attr", (String)ruleEntry.getExAttribute().toString()));
        itemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_origAttItem", (String)JSONObject.toJSONString(changeAttItemIds)));
        String exProcessStr = null == exProcess ? "" : exProcess.toString();
        itemInstance.getExtraLabels().add((ILabel)Label.of((String)"exProcess", (String)exProcessStr));
        itemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_origAttItem_v", (String)(oriItemValue + "")));
        return itemInstance;
    }

    private Boolean ruleCheck(ExRuleEntry entry, BigDecimal seconds) {
        StringBuilder sub = new StringBuilder();
        sub.append(seconds).append(' ').append(entry.getRela()).append(' ').append(entry.getRawConvertValue()).append(' ').append(entry.getLogic()).append(' ').append(seconds).append(' ').append(entry.getRelas()).append(' ').append(entry.getRawConvertValues()).append(' ');
        try {
            return new ParserUtil().calculate(sub.toString(), null);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("EX_001", ResManager.loadKDString((String)"\u5f02\u5e38\u8ba1\u7b97\u89c4\u5219\u89e3\u6790\u5f02\u5e38\u3002", (String)"ExChangeEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    private Map<String, Object> mergeResult(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ExConstant.NUMBER_2);
        HashMap groupMap = Maps.newHashMap();
        resultMap.put("groupMap", groupMap);
        HashMap parentsNodesMap = Maps.newHashMap();
        resultMap.put("parentsNodesMap", parentsNodesMap);
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(dataNodes);
        attItemValueMap.forEach((key, entry) -> {
            groupMap.put(key, entry.getAttItemInstance());
            HashSet set = new HashSet(Arrays.stream(entry.getParentIds()).boxed().collect(Collectors.toSet()));
            List parentDataNodes = dataNodes.stream().filter(ob -> set.contains(ob.getId())).collect(Collectors.toList());
            parentsNodesMap.put(key, parentDataNodes);
        });
        return resultMap;
    }
}

