/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlex;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.AfterExecExEvent;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.AfterExecExParam;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.ExAttItemInstanceExtDTO;
import kd.sdk.wtc.wtes.business.tie.model.attitem.ExAttItemInstanceExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.ext.model.attitem.AttItemSpecExtImpl;
import kd.wtc.wtes.business.ext.model.attitem.ExAttItemInstanceExtImpl;
import kd.wtc.wtes.business.ext.model.ex.AfterExecExParamImpl;
import kd.wtc.wtes.business.ext.model.ex.ExRulePackageExtImpl;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TieContextUtil;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;
import kd.wtc.wtes.common.util.LabelSet;

class ExExtHelper {
    ExExtHelper() {
    }

    static void afterExecEx(TieContextStd context, List<AttItemValue> curNodeResList, ExRulePackage exRulePackage, long exProcess) {
        WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtes.business.tie.exexutor.ex.TieExecExExtPlugin");
        if (pluginProxy != null && pluginProxy.hasPlugin()) {
            List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
            TieStepIdentity tieStepIdentity = context.getTieStepIdentity();
            ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
            ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(context.getChainDate());
            Map<Long, AttItemValue> curChainInstances = TieContextUtil.getAllHandleResultAndAttItemValue(context.getAllDataNodes(), shiftSpec, curNodeResList, tieStepIdentity);
            Map<Long, AttItemValue> curPhaseHandleResultAndAttItemValue = TieContextUtil.getCurPhaseHandleResultAndAttItemValue(context.getAllDataNodes(), shiftSpec, curNodeResList, tieStepIdentity);
            List<ExAttItemInstanceExt> exAttItemInstances = ExExtHelper.convert2ExAttItemInstanceExt(curNodeResList, context);
            AfterExecExParamImpl param = new AfterExecExParamImpl(context, rawTimeBuckets, curPhaseHandleResultAndAttItemValue, curChainInstances, new ExRulePackageExtImpl(exRulePackage, exProcess), exAttItemInstances);
            AfterExecExEvent stepEvent = new AfterExecExEvent((AfterExecExParam)param);
            pluginProxy.invokeReplace(tieExtPlugin -> tieExtPlugin.afterExecEx(stepEvent));
            if (WTCCollections.isNotEmpty((Collection)stepEvent.getExAttItemInstances())) {
                List<AttItemValue> attItemValues = ExExtHelper.convert2AttItemValue(stepEvent.getExAttItemInstances(), context, exProcess);
                curNodeResList.addAll(attItemValues);
            }
        }
    }

    private static List<ExAttItemInstanceExt> convert2ExAttItemInstanceExt(List<AttItemValue> curNodeResList, TieContextStd context) {
        List<AttItemValue> exAttItemValues = ExExtHelper.getExAttItemValues(curNodeResList, context);
        ArrayList<ExAttItemInstanceExt> attItemInstanceExts = new ArrayList<ExAttItemInstanceExt>(exAttItemValues.size());
        for (AttItemValue exAttItemValue : exAttItemValues) {
            long exTypeId;
            AttItemInstance attItemInstance = exAttItemValue.getAttItemInstance();
            LabelSet<ILabel> extraLabels = attItemInstance.getExtraLabels();
            if (HRStringUtils.equals((String)extraLabels.getValue("ex_no_export"), (String)Boolean.TRUE.toString()) || (exTypeId = ExExtHelper.convert2Long(extraLabels.getValue("ex_attr"))) == 0L) continue;
            boolean isOriginEx = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)extraLabels.getValue("origAttItem"));
            ExAttItemInstanceExtImpl exAttItemInstanceExt = isOriginEx ? new ExAttItemInstanceExtImpl() : new ExAttItemInstanceExtImpl(new AttItemSpecExtImpl(attItemInstance.getAttItemSpec()), attItemInstance.getItemValue(), attItemInstance.getDay(), attItemInstance.getSecondDecimal());
            LocalDate shiftDate = ExExtHelper.getShiftDate(exAttItemValue, context.getChainDate());
            exAttItemInstanceExt.setShiftDate(ExExtHelper.getShiftDate(exAttItemValue, context.getChainDate()));
            exAttItemInstanceExt.setExTypeId(exTypeId);
            ExExtHelper.setShouldPunchCardSeqId(extraLabels, exAttItemInstanceExt, shiftDate);
            long tbPosition = ExExtHelper.convert2Long(extraLabels.getValue("ex_shitCard"));
            exAttItemInstanceExt.setShiftTimeBucketSeqId(tbPosition);
            ExExtHelper.setOriginAttItem(exAttItemInstanceExt, context, attItemInstance, shiftDate);
            long exProcessId = ExExtHelper.convert2Long(extraLabels.getValue("exProcess"));
            exAttItemInstanceExt.setExProcessId(exProcessId);
            ExExtHelper.setExFilterType(extraLabels, exAttItemInstanceExt);
            attItemInstanceExts.add(exAttItemInstanceExt);
        }
        return attItemInstanceExts;
    }

    private static List<AttItemValue> getExAttItemValues(List<AttItemValue> curNodeResList, TieContextStd context) {
        List dataNodesOfPrevStepExecutor = context.getDataNodesOfPrevStepExecutor();
        ArrayList<AttItemValue> exAttItemValues = new ArrayList<AttItemValue>(dataNodesOfPrevStepExecutor.size() + curNodeResList.size());
        for (TieDataNodeStd tieDataNodeStd : dataNodesOfPrevStepExecutor) {
            exAttItemValues.add(tieDataNodeStd.unwrapAndCastTo(AttItemValue.class));
        }
        exAttItemValues.addAll(curNodeResList);
        return exAttItemValues;
    }

    private static void setExFilterType(LabelSet<ILabel> extraLabels, ExAttItemInstanceExtImpl exAttItemInstanceExt) {
        String exFilterType = "exGeneral".equals(extraLabels.getValue("exFilterType")) ? "1" : ("exConvert".equals(extraLabels.getValue("exFilterType")) ? "2" : "3");
        exAttItemInstanceExt.setExFilterType(exFilterType);
    }

    private static void setOriginAttItem(ExAttItemInstanceExtImpl exAttItemInstanceExt, TieContextStd context, AttItemInstance attItemInstance, LocalDate shiftDate) {
        BigDecimal originAttItemValue;
        List<Long> originAttItemVids;
        List originAttItemBoIds;
        ShiftTableSingle currentShiftTable = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = currentShiftTable.getShiftSpec(shiftDate);
        LabelSet<ILabel> extraLabels = attItemInstance.getExtraLabels();
        AttItemSpec attItemSpec = attItemInstance.getAttItemSpec();
        if (exAttItemInstanceExt.isOriginEx()) {
            originAttItemBoIds = Collections.singletonList(attItemSpec.getBid());
            originAttItemVids = Collections.singletonList(attItemSpec.getId());
            originAttItemValue = ExExtHelper.getAttItemValue(attItemInstance);
        } else {
            AttItemSpecData attItemSpecData = (AttItemSpecData)context.getInitParam("ATT_ITEM_SPEC");
            originAttItemBoIds = JSON.parseArray((String)extraLabels.getValue("ex_origAttItem"), Long.class);
            List<AttItemSpec> attItemSpecs = originAttItemBoIds.stream().map(attId -> attItemSpecData.getByBidAndDate((long)attId, context.getChainDate())).collect(Collectors.toList());
            originAttItemVids = attItemSpecs.stream().map(AbstractTimeSeqVersion::getId).collect(Collectors.toList());
            String timeunit = ExExtHelper.getUnit(attItemSpecs);
            String originAttItemValueStr = extraLabels.getValue("ex_origAttItem_v");
            BigDecimal originAttItemValueInSecond = WTCStringUtils.isNotEmpty((String)originAttItemValueStr) ? new BigDecimal(originAttItemValueStr) : BigDecimal.ZERO;
            originAttItemValue = HRStringUtils.equals((String)timeunit, (String)"day") ? shiftSpec.secondsToDays(originAttItemValueInSecond) : new BigDecimal(ExExtHelper.getValueString(originAttItemValueInSecond, timeunit, 6, "2"));
        }
        exAttItemInstanceExt.setOriginAttItemBoIds(originAttItemBoIds);
        exAttItemInstanceExt.setOriginAttItemVids(originAttItemVids);
        exAttItemInstanceExt.setOriginAttItemValue(originAttItemValue);
    }

    private static void setShouldPunchCardSeqId(LabelSet<ILabel> extraLabels, ExAttItemInstanceExtImpl exAttItemInstanceExt, LocalDate shiftDate) {
        long shouldPunchCardSeqId = ExExtHelper.convert2Long(extraLabels.getValue("ex_punchCard"));
        exAttItemInstanceExt.setShouldPunchCardSeqId(shouldPunchCardSeqId);
        LocalDateTime startTime = null;
        LocalDateTime endTime = null;
        String shouldPunchPoint = extraLabels.getValue("ex_punchPoint");
        if (WTCStringUtils.isNotEmpty((String)shouldPunchPoint)) {
            String[] shouldPunchPointArr = shouldPunchPoint.split(",");
            if (WTCStringUtils.isNotEmpty((String)shouldPunchPointArr[0])) {
                startTime = ExExtHelper.getLocalDateTime(shiftDate, shouldPunchPointArr[0]);
            }
            if (shouldPunchPointArr.length > 1 && WTCStringUtils.isNotEmpty((String)shouldPunchPointArr[1])) {
                endTime = ExExtHelper.getLocalDateTime(shiftDate, shouldPunchPointArr[1]);
            }
        }
        exAttItemInstanceExt.setShouldPunchPointStart(startTime);
        exAttItemInstanceExt.setShouldPunchPointEnd(endTime);
    }

    private static LocalDateTime getLocalDateTime(LocalDate shiftDate, String text) {
        LocalDateTime startTime;
        try {
            LocalTime localTime = LocalTime.parse(text);
            startTime = LocalDateTime.of(shiftDate, localTime);
        }
        catch (Exception ex) {
            try {
                startTime = LocalDateTime.parse(text, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            }
            catch (Exception ex2) {
                startTime = null;
            }
        }
        return startTime;
    }

    private static String getUnit(List<AttItemSpec> attItemSpecs) {
        Set units = attItemSpecs.stream().map(AttItemSpec::getUnit).collect(Collectors.toSet());
        if (units.contains(AttitemUnitEnum.SECOND.getUnit())) {
            return AttitemUnitEnum.SECOND.getUnit();
        }
        if (units.contains(AttitemUnitEnum.MINUTE.getUnit())) {
            return AttitemUnitEnum.MINUTE.getUnit();
        }
        if (units.contains(AttitemUnitEnum.HOUR.getUnit())) {
            return AttitemUnitEnum.HOUR.getUnit();
        }
        return AttitemUnitEnum.DAY.getUnit();
    }

    private static BigDecimal getAttItemValue(AttItemInstance attItemInstance) {
        if (HRStringUtils.equals((String)attItemInstance.getAttItemSpec().getUnit(), (String)"day")) {
            return attItemInstance.getDay();
        }
        if (HRStringUtils.equals((String)attItemInstance.getAttItemSpec().getUnit(), (String)"time")) {
            return attItemInstance.getItemValue();
        }
        return new BigDecimal(ExExtHelper.getValueString(attItemInstance.getSecondDecimal(), attItemInstance.getAttItemSpec().getUnit(), attItemInstance.getAttItemSpec().getDataAccuracy(), attItemInstance.getAttItemSpec().getPrecisionTail()));
    }

    private static String getValueString(BigDecimal valueSecond, String unit, int dataAccuracy, String precisionTail) {
        String result;
        switch (unit) {
            case "hour": {
                result = ExExtHelper.scale(valueSecond, dataAccuracy, 3600, precisionTail);
                break;
            }
            case "minute": {
                result = ExExtHelper.scale(valueSecond, dataAccuracy, 60, precisionTail);
                break;
            }
            case "second": {
                result = String.valueOf(valueSecond);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static String scale(BigDecimal value, int dataaccuracy, int scale, String precisionTail) {
        int precision;
        switch (precisionTail) {
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
            default: {
                precision = 4;
            }
        }
        return value.divide(new BigDecimal(scale), dataaccuracy, precision).toString();
    }

    private static long convert2Long(String str) {
        return WTCStringUtils.isEmpty((String)str) ? 0L : Long.parseLong(str);
    }

    private static LocalDate getShiftDate(AttItemValue attItemValue, LocalDate ownDate) {
        List<TieDataNodeStd> tieDataNodeStds = attItemValue.parentDataNodes();
        HashSet<LocalDate> shiftDateSets = new HashSet<LocalDate>(2);
        for (TieDataNodeStd tieDataNodeStd : tieDataNodeStds) {
            Set<LocalDate> shiftDateSet = ExExtHelper.getShiftDate(tieDataNodeStd);
            shiftDateSets.addAll(shiftDateSet);
        }
        if (shiftDateSets.size() == 1) {
            return (LocalDate)shiftDateSets.iterator().next();
        }
        return ownDate;
    }

    private static Set<LocalDate> getShiftDate(TieDataNodeStd model) {
        HashSet<LocalDate> set = new HashSet<LocalDate>(2);
        if (model instanceof TimeBucketStd && WTCCollections.isEmpty(model.parentDataNodes())) {
            set.add(((TimeBucketStd)model).getShiftDate());
        }
        if (WTCCollections.isNotEmpty(model.parentDataNodes())) {
            for (TieDataNodeStd dataNode : model.parentDataNodes()) {
                set.addAll(ExExtHelper.getShiftDate(dataNode));
            }
        }
        return set;
    }

    private static List<AttItemValue> convert2AttItemValue(List<ExAttItemInstanceExtDTO> exAttItemSpecExtList, TieContextStd context, long exProcess) {
        ArrayList<AttItemValue> attItemValues = new ArrayList<AttItemValue>(exAttItemSpecExtList.size());
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        for (ExAttItemInstanceExtDTO attItemInstanceExt : exAttItemSpecExtList) {
            ShiftSpec shiftSpec;
            if (attItemInstanceExt == null) continue;
            ExExtHelper.checkAttItemInstanceExt(attItemInstanceExt);
            BigDecimal seconds = attItemInstanceExt.getSecondDecimal();
            BigDecimal day = BigDecimal.ZERO;
            if (DataType.DURATION.code.equals(attItemInstanceExt.getAttItemSpecExt().dataType()) && (shiftSpec = shiftTableSingle.getShiftSpec(attItemInstanceExt.getShiftDate())) != null) {
                day = shiftSpec.secondsToDays(attItemInstanceExt.getSecondDecimal());
            }
            BigDecimal itemValue = attItemInstanceExt.getItemValue();
            AttItemSpec attItemSpec = (AttItemSpec)((Object)attItemInstanceExt.getAttItemSpecExt().getInstance());
            AttItemInstance attItemInstance = new AttItemInstance(attItemSpec, itemValue, day, seconds, null);
            ExExtHelper.appendLabel(attItemInstance, attItemInstanceExt, context, exProcess);
            AttItemValue attItemValue = (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(Lists.newLinkedList())).attItemInstance(attItemInstance)).build();
            attItemValues.add(attItemValue);
        }
        return attItemValues;
    }

    private static void checkAttItemInstanceExt(ExAttItemInstanceExtDTO attItemInstanceExt) {
        WTCAssert.nonNull((Object)attItemInstanceExt.getAttItemSpecExt(), (String)"AttItemSpecExt could not be null");
        if (DataType.TIMES.code.equals(attItemInstanceExt.getAttItemSpecExt().dataType())) {
            WTCAssert.state((attItemInstanceExt.getItemValue() != null ? 1 : 0) != 0, (String)"ItemValue of ExAttItemInstanceExtDTO could not be null when data type of AttItemSpecExt is TIMES('0')");
        }
        if (DataType.DURATION.code.equals(attItemInstanceExt.getAttItemSpecExt().dataType())) {
            WTCAssert.state((attItemInstanceExt.getSecondDecimal() != null ? 1 : 0) != 0, (String)"SecondDecimal of ExAttItemInstanceExtDTO could not be null when data type of AttItemSpecExt is DURATION('1')");
        }
        WTCAssert.isTrue((attItemInstanceExt.getExTypeId() != 0L ? 1 : 0) != 0, (String)"ExTypeId could not be zero");
    }

    private static void appendLabel(AttItemInstance attItemInstance, ExAttItemInstanceExtDTO exAttItemInstanceExt, TieContextStd context, long defaultExProcessId) {
        LabelSet<ILabel> extraLabels = attItemInstance.getExtraLabels();
        extraLabels.add((ILabel)Label.of((String)"ex_attr", (String)String.valueOf(exAttItemInstanceExt.getExTypeId())));
        extraLabels.add((ILabel)Label.of((String)"origAttItem", (String)Boolean.FALSE.toString()));
        LocalDate shiftDate = exAttItemInstanceExt.getShiftDate();
        if (shiftDate == null) {
            shiftDate = context.getChainDate();
        }
        extraLabels.add((ILabel)Label.of((String)"ex_shiftDate", (String)shiftDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        extraLabels.add((ILabel)Label.of((String)"ex_punchCard", (String)String.valueOf(exAttItemInstanceExt.getShouldPunchCardSeqId())));
        ArrayList<String> punchPoints = new ArrayList<String>(2);
        if (exAttItemInstanceExt.getShouldPunchPointStart() != null) {
            punchPoints.add(exAttItemInstanceExt.getShouldPunchPointStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
        }
        if (exAttItemInstanceExt.getShouldPunchPointEnd() != null) {
            punchPoints.add(exAttItemInstanceExt.getShouldPunchPointEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
        }
        if (WTCCollections.isNotEmpty(punchPoints)) {
            extraLabels.add((ILabel)Label.of((String)"ex_punchPoint", (String)WTCStringUtils.join(punchPoints, (String)",")));
        }
        extraLabels.add((ILabel)Label.of((String)"ex_shitCard", (String)String.valueOf(exAttItemInstanceExt.getShiftTimeBucketSeqId())));
        long exProcessId = exAttItemInstanceExt.getExProcessId();
        if (exProcessId == 0L) {
            exProcessId = defaultExProcessId;
        }
        extraLabels.add((ILabel)Label.of((String)"exProcess", (String)String.valueOf(exProcessId)));
        String exFilterType = exAttItemInstanceExt.getExFilterType();
        if (WTCStringUtils.isEmpty((String)exFilterType)) {
            exFilterType = "5";
        }
        extraLabels.add((ILabel)Label.of((String)"exFilterType", (String)exFilterType));
        extraLabels.add((ILabel)Label.of((String)"EXT_ATT_ITEM_EX"));
    }
}

