/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.ruleengine.RuleEngineQueryServiceImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.common.model.common.Fixtimeentity;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.model.OtAttPackage;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.rlotcal.OtDeductSubTimeItem;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalCompenConfig;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.model.rlotcal.OtRulePackage;
import kd.wtc.wtes.business.model.rlotcal.OtSubConfig;
import kd.wtc.wtes.business.model.rlotcal.OtSubTimeItem;
import kd.wtc.wtes.business.model.rlotcal.TimeCut;
import kd.wtc.wtes.business.model.rlotcal.TimeCutConfig;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class OtCalcHelper {
    private static final Log logger = LogFactory.getLog(OtCalcHelper.class);

    private OtCalcHelper() {
    }

    private static TimeSeqAvailableBo<OtSubConfig> buildOtSub(List<DynamicObject> dynamicObjects) {
        ArrayList otSubConfigList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            OtSubConfig.Builder sub = OtSubConfig.createSub();
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(dynamicObject);
            sub.setTimeSeqEntity((TimeSeqInfo)timeSeqEntity);
            String subtype = dynamicObject.getString("subtype");
            sub.setSubType(subtype);
            BigDecimal fixtimes = dynamicObject.getBigDecimal("fixtimes");
            sub.setFixTimes(fixtimes);
            String selectsub = dynamicObject.getString("selectsub");
            sub.setSelectSub(selectsub);
            BigDecimal destimes = dynamicObject.getBigDecimal("destimes");
            sub.setDesTimes(destimes);
            DynamicObjectCollection otTimeEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            List<OtSubTimeItem> otSubTimeList = null;
            if (!CollectionUtils.isEmpty((Collection)otTimeEntry)) {
                otSubTimeList = OtCalcHelper.getOtSubItem(otTimeEntry);
            }
            sub.setOtSubTimeItemList(otSubTimeList);
            BigDecimal start = dynamicObject.getBigDecimal("satisfyhours");
            BigDecimal deductHours = dynamicObject.getBigDecimal("deducthours");
            OtDeductSubTimeItem.Builder builder = OtDeductSubTimeItem.createSub();
            OtDeductSubTimeItem otDeductSubTimeItem = builder.setDeductHours(deductHours).setSatisfyhours(start).build();
            ArrayList otDeductSubTimeItemList = Lists.newArrayList((Object[])new OtDeductSubTimeItem[]{otDeductSubTimeItem});
            sub.setOtDeductSubTimeItemList(otDeductSubTimeItemList);
            otSubConfigList.add(sub.build());
        }
        return new TimeSeqAvailableBo((Collection)otSubConfigList);
    }

    private static List<OtSubTimeItem> getOtSubItem(DynamicObjectCollection otTimeEntry) {
        ArrayList otSubTimeList = Lists.newArrayListWithExpectedSize((int)otTimeEntry.size());
        for (DynamicObject dynamicObject : otTimeEntry) {
            int start = dynamicObject.getInt("starttime");
            int end = dynamicObject.getInt("endtime");
            OtSubTimeItem item = new OtSubTimeItem(start, end);
            otSubTimeList.add(item);
        }
        return otSubTimeList;
    }

    public static boolean checkEmpty(TieContextStd context) {
        return context.getRawTimeBuckets().isEmpty();
    }

    public static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        return TimeSeqEntityGenerateUtils.getTimeSeqEntity(dynamicObject);
    }

    public static List<OtAttPackage> getPlanList(List<DynamicObject> dynamicObjects, Map<Long, List<DynamicObject>> ruleHisListMap, Map<Long, List<DynamicObject>> timecutDyMap, LocalDate startDate, LocalDate endDate) {
        ArrayList planHis = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject planDy : dynamicObjects) {
            TimeSeqAvailableBo<OtRulePackage> ruleBoVersionList = null;
            HashSet otscenes = new HashSet();
            TimeCut timeCut = null;
            if (!PolicyResultHelp.isRuleEngineByPlanID(planDy.getLong("id"))) {
                Long ruleBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planDy, (String)"overworkrule");
                otscenes = Sets.newHashSet((Object[])String.valueOf(planDy.get("otscene")).split(","));
                timeCut = OtCalcHelper.getTimeCut(planDy, timecutDyMap);
                ruleBoVersionList = OtCalcHelper.getRule(ruleBoId, ruleHisListMap, startDate, endDate);
            } else {
                ruleBoVersionList = new TimeSeqAvailableBo<OtRulePackage>();
            }
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(planDy);
            Map ruleSetMap = RuleEngineQueryServiceImpl.getInstance().queryRuleEngineAssociation((List)Lists.newArrayList((Object[])new Long[]{planDy.getLong("id")}));
            String ruleWay = (String)ruleSetMap.get(timeSeqEntity.getId());
            String sceneNumber = RuleEngineEnum.otp3.getSceneNumber();
            if (WTCStringUtils.isEmpty((String)ruleWay)) {
                ruleWay = "1";
            }
            if ("2".equals(ruleWay)) {
                Map planPolicyMap = PlanRuleEngineHelper.getPolicyPlanMapByPlanIds(Collections.singletonList(planDy.getLong("id")));
                Map planSceneMap = PlanRuleEngineHelper.getPlanSceneMap((Map)planPolicyMap);
                sceneNumber = ((DynamicObject)planSceneMap.get(planDy.getLong("id"))).getString("number");
            }
            OtAttPackage attPackage = new OtAttPackage(planDy.getLong("id"), planDy.getString("number"), (TimeSeqInfo)timeSeqEntity, ruleBoVersionList, ruleWay, otscenes, timeCut, sceneNumber);
            planHis.add(attPackage);
        }
        return planHis;
    }

    public static TimeCut getTimeCut(DynamicObject ottimecutDy) {
        if (ottimecutDy == null) {
            return null;
        }
        DynamicObjectCollection ottimecutentryDy = ottimecutDy.getDynamicObjectCollection("timecutentry");
        ArrayList cutConfigs = Lists.newArrayListWithExpectedSize((int)ottimecutentryDy.size());
        for (DynamicObject dynamicObject : ottimecutentryDy) {
            DynamicObject datetypetimeDy = dynamicObject.getDynamicObject("datetypetime");
            if (datetypetimeDy == null) continue;
            List<Fixtimeentity> fixtimeentitys = datetypetimeDy.getDynamicObjectCollection("fixtimeentity").stream().map(dy -> new Fixtimeentity(LocalTime.ofSecondOfDay(dy.getLong("begintime")), dy.getString("stagdate"), LocalTime.ofSecondOfDay(dy.getLong("endtime")), dy.getString("etagdate"))).collect(Collectors.toList());
            TimeCutConfig cutConfig = TimeCutConfig.builder().setAfterDateRangeJson(dynamicObject.getString("afterdaycond")).setCurrentDateRangeJson(dynamicObject.getString("daycond")).setPreDateRangeJson(dynamicObject.getString("beforedaycond")).setIscutattitem(dynamicObject.getBoolean("iscutattitem")).setId(dynamicObject.getLong("id")).setFixtimeentity(fixtimeentitys).setCutattitem(dynamicObject.getLong("cutattitem.id")).build();
            cutConfigs.add(cutConfig);
        }
        TimeCut timeCut = TimeCut.builder().setId(ottimecutDy.getLong("id")).setNumber(ottimecutDy.getString("number")).setTimeCutConfigs(cutConfigs).build();
        return timeCut;
    }

    private static TimeCut getTimeCut(DynamicObject planDy, Map<Long, List<DynamicObject>> timecutDyMap) {
        TimeCut timeCut = null;
        List<DynamicObject> timecutDys = timecutDyMap.get(planDy.getLong("timecut.id"));
        if (WTCCollections.isNotEmpty(timecutDys) && timecutDys.size() > 0) {
            timeCut = OtCalcHelper.getTimeCut(timecutDys.get(0));
        }
        return timeCut;
    }

    public static TimeSeqAvailableBo<OtRulePackage> getRule(Long ruleId, Map<Long, List<DynamicObject>> ruleHisListMap, LocalDate startDate, LocalDate endDate) {
        List<DynamicObject> ruleEntityList = ruleHisListMap.get(ruleId);
        if (CollectionUtils.isEmpty(ruleEntityList)) {
            logger.debug("ruleId={} ruleEntityList is null", (Object)ruleId);
            return new TimeSeqAvailableBo();
        }
        ArrayList rulePackageList = Lists.newArrayListWithExpectedSize((int)ruleEntityList.size());
        for (DynamicObject object : ruleEntityList) {
            OtRulePackage.Builder builder = OtRulePackage.getRule();
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(object);
            builder.setTimeSeqEntity((TimeSeqInfo)timeSeqEntity);
            ArrayList<OtRuleCalConfig> otRuleCalConfigList = new ArrayList<OtRuleCalConfig>(16);
            DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("overworkcalentry");
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                for (DynamicObject entry : dynamicObjectCollection) {
                    ArrayList compenConfigBuilders = Lists.newArrayListWithExpectedSize((int)16);
                    entry.getDynamicObjectCollection("overworkcaldetail").stream().forEach(item -> {
                        DynamicObject[] otSubHisList = InitHelper.getHisDyArr("wtp_otsub", Sets.newHashSet((Object[])new Long[]{item.getLong("overtimesub.id")}), startDate, endDate);
                        compenConfigBuilders.add(OtRuleCalCompenConfig.getBuilder().setOtSubConfig(OtCalcHelper.buildOtSub(Arrays.asList(otSubHisList))).setBaseDataId(item.getLong("id")).setBfroundingRule(item.getLong("bfroundingrule.id")).setOriginalCalPrjSet(Collections.singleton(item.getLong("originalcalprj.id"))).setOriginalconf(item.getBigDecimal("originalconf")).setOriginalPrjSet(Collections.singleton(item.getLong("originalprj.id"))).setResultPrjSet(Collections.singleton(item.getLong("resultprj.id"))).setSubPrjSet(Collections.singleton(item.getLong("subprj.id"))).setOtcompenmode(item.getLong("otcompenmode.id")).build());
                    });
                    OtRuleCalConfig otRuleCalConfig = OtCalcHelper.makeOtRuleCalConfigByEntry(entry, compenConfigBuilders);
                    otRuleCalConfigList.add(otRuleCalConfig);
                }
            }
            builder.setOtRuleCalConfigList(otRuleCalConfigList);
            rulePackageList.add(builder.build());
        }
        return new TimeSeqAvailableBo((Collection)rulePackageList);
    }

    public static Set<Long> otSubIdSet(DynamicObject otrulDy) {
        HashSet otSubIdSet = Sets.newHashSetWithExpectedSize((int)16);
        Set dynamicObjectCollections = otrulDy.getDynamicObjectCollection("overworkcalentry").stream().map(entry -> entry.getDynamicObjectCollection("overworkcaldetail")).collect(Collectors.toSet());
        for (DynamicObjectCollection dycollection : dynamicObjectCollections) {
            otSubIdSet.addAll(dycollection.stream().map(dy -> dy.getLong("overtimesub.id")).collect(Collectors.toSet()));
        }
        return otSubIdSet;
    }

    private static OtRuleCalConfig makeOtRuleCalConfigByEntry(DynamicObject entry, List<OtRuleCalCompenConfig> otRuleCalCompenConfigs) {
        OtRuleCalConfig otRuleCalConfig = new OtRuleCalConfig.Builder().setDataSources(entry.getLong("datasource.id")).setOtType(entry.getLong("ottype.id")).setBaseDataId(entry.getLong("id")).setIsempchoice(entry.getBoolean("isempchoice")).setLimitscope(entry.getString("limitscope")).setDateRangeCondition(entry.getString("daterangecondition")).setOtRuleCalCompenConfig(otRuleCalCompenConfigs).build();
        return otRuleCalConfig;
    }

    private static String getOtCompenMode(String otCompenModeNum) {
        String result = HRStringUtils.equals((String)otCompenModeNum, (String)"A01") ? "2" : (HRStringUtils.equals((String)otCompenModeNum, (String)"A02") ? "3" : (HRStringUtils.equals((String)otCompenModeNum, (String)"A03") ? "4" : "1"));
        return result;
    }
}

