/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.datanode.TieDataNodeCore;
import kd.wtc.wtes.business.executor.common.CalTimeCutHelper;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCalcHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCommonEvaluator;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.DasoConf;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.retrieval.BillRetrievalDimensionResult;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalCompenConfig;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.service.IAccessService;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.BillTieRetrievalUtil;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.enums.CardViewDesignerEnum;
import kd.wtc.wtes.common.pairtime.SourceCode;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;
import kd.wtc.wtes.common.util.LabelSet;

public class OtCompensationEvaluator
extends OtCommonEvaluator
implements TieEvaluatorStd {
    private static final Label workHolidLabel = Label.of((String)OverworkAttendanceEnum.OT_WORKHOLIDATTID.toString(), (String)OverworkAttendanceEnum.OT_WORKHOLIDATTID.getBid().toString());
    private static final Label hoildWorkLabel = Label.of((String)OverworkAttendanceEnum.OT_HOILDWORKATTID.toString(), (String)OverworkAttendanceEnum.OT_HOILDWORKATTID.getBid().toString());
    private static final Label workRestLabel = Label.of((String)OverworkAttendanceEnum.OT_WORKRESTATTID.toString(), (String)OverworkAttendanceEnum.OT_WORKRESTATTID.getBid().toString());
    private static final Label RestWorkLabel = Label.of((String)OverworkAttendanceEnum.OT_RESTWORKATTID.toString(), (String)OverworkAttendanceEnum.OT_RESTWORKATTID.getBid().toString());
    private final Set<Label> labels = Sets.newHashSet((Object[])new Label[]{workHolidLabel, hoildWorkLabel, workRestLabel, RestWorkLabel});
    Map<String, TimeBucket> attAttItems = Maps.newHashMapWithExpectedSize((int)4);
    private static final Log logger = LogFactory.getLog(OtCompensationEvaluator.class);

    private static OtRuleCalConfig filterEmpchoice(TieContextStd context, OtRuleCalConfig otRuleCalConfig, ITimeBucket next) {
        boolean isOTBill;
        boolean bl = isOTBill = CardViewDesignerEnum.from((Long)otRuleCalConfig.getDataSources()) == CardViewDesignerEnum.WORKBILL || CardViewDesignerEnum.from((Long)otRuleCalConfig.getDataSources()) == CardViewDesignerEnum.WORKMIXEDCARD || CardViewDesignerEnum.from((Long)otRuleCalConfig.getDataSources()) == CardViewDesignerEnum.WORKUNIONOFFMIXEDWORK;
        if (isOTBill && otRuleCalConfig.getIsempchoice().booleanValue()) {
            AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
            List<OtRuleCalCompenConfig> otRuleCalCompenConfigs = otRuleCalConfig.getOtRuleCalCompenConfigs();
            long otBillId = next.getAttendanceBillTag().getOtBillId();
            for (OtRuleCalCompenConfig compenConfig : otRuleCalCompenConfigs) {
                attBillTimeBucketData.getBillTimeBucketById(otBillId);
                AttBillTimeBucket attBillTimeBucket = attBillTimeBucketData.getBillTimeBucketById(otBillId);
                if (compenConfig.getOtcompenmode() == null || attBillTimeBucket == null || !compenConfig.getOtcompenmode().equals(attBillTimeBucket.getCompenTypeId())) continue;
                return OtRuleCalConfig.builder().setDataSources(otRuleCalConfig.getDataSources()).setBaseDataId(otRuleCalConfig.getId()).setOtType(otRuleCalConfig.getOtType()).setBaseDataId(otRuleCalConfig.getEntryId()).setIsempchoice(otRuleCalConfig.getIsempchoice()).setLimitConditionAccessDto(otRuleCalConfig.getLimitConditionAccessDto()).setLimitscope(otRuleCalConfig.getLimitscope()).setDateRangeCondition(otRuleCalConfig.getDateRangeCondition()).setDateConditionAccessDto(otRuleCalConfig.getDateConditionAccessDto()).setOtRuleCalCompenConfig(otRuleCalConfig.getOtRuleCalCompenConfigs()).setMatchOtRuleCalCompenConfig(compenConfig).build();
            }
        } else {
            return OtRuleCalConfig.builder().setBaseDataId(otRuleCalConfig.getId()).setDataSources(otRuleCalConfig.getDataSources()).setOtType(otRuleCalConfig.getOtType()).setBaseDataId(otRuleCalConfig.getEntryId()).setIsempchoice(otRuleCalConfig.getIsempchoice()).setLimitscope(otRuleCalConfig.getLimitscope()).setLimitConditionAccessDto(otRuleCalConfig.getLimitConditionAccessDto()).setDateRangeCondition(otRuleCalConfig.getDateRangeCondition()).setDateConditionAccessDto(otRuleCalConfig.getDateConditionAccessDto()).setOtRuleCalCompenConfig(otRuleCalConfig.getOtRuleCalCompenConfigs()).setMatchOtRuleCalCompenConfig(WTCCollections.isNotEmpty(otRuleCalConfig.getOtRuleCalCompenConfigs()) ? otRuleCalConfig.getOtRuleCalCompenConfigs().get(0) : null).build();
        }
        return null;
    }

    private static boolean filter(TieContextStd context, Long dataSource, ITimeBucket next, Long otType) {
        CardViewDesignerEnum cardViewDesignerEnum = CardViewDesignerEnum.from((Long)dataSource);
        switch (cardViewDesignerEnum) {
            case WORKBILL: {
                if (CalTimeCutHelper.dateAttributeIsChange(context, next)) {
                    return next.getAttendanceBillTag().isOverTime();
                }
                return next.getAttendanceBillTag().isOverTime() && next.getAttendanceBillTag().getOtBillTypeId() == otType.longValue();
            }
            case CARDPOINT: {
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code);
            }
            case WORKMIXEDCARD: {
                if (CalTimeCutHelper.dateAttributeIsChange(context, next)) {
                    return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) && next.getAttendanceBillTag().isOverTime();
                }
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) && next.getAttendanceBillTag().isOverTime() && next.getAttendanceBillTag().getOtBillTypeId() == otType.longValue();
            }
            case WORKUNIONOFF: {
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) || next.getAttendanceBillTag().isOnBusiness();
            }
            case WORKUNIONOFFMIXEDWORK: {
                if (CalTimeCutHelper.dateAttributeIsChange(context, next)) {
                    return (next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) || next.getAttendanceBillTag().isOnBusiness()) && next.getAttendanceBillTag().isOverTime();
                }
                return (next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) || next.getAttendanceBillTag().isOnBusiness()) && next.getAttendanceBillTag().isOverTime() && next.getAttendanceBillTag().getOtBillTypeId() == otType.longValue();
            }
        }
        return true;
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        logger.debug("start otcal {} context.getAttPersonId():{} context.getRawTimeBuckets().isEmpty():{}", new Object[]{this.getClass().getSimpleName(), context.getAttPersonId(), context.getRawTimeBuckets().isEmpty()});
        if (OtCalcHelper.checkEmpty(context)) {
            return this.otExclusion;
        }
        List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
        return this.doEvaluate(context, rawTimeBuckets);
    }

    private DasoConf otDasoConf() {
        ConfigMix configMix = ContextUtil.getConfigMix(this.context);
        BizDataSource dataSource = configMix != null ? configMix.getDataSource(BizTypeEnum.OT) : null;
        TimeSeqBo<DasoConf> dasoConfTimeSeqBo = dataSource != null ? dataSource.getDasoConfTimeSeqBo() : null;
        return dasoConfTimeSeqBo != null ? (DasoConf)dasoConfTimeSeqBo.getVersionByDate(this.chainDate) : null;
    }

    private List<TimeBucket> filterByDataSource(List<TimeBucket> dataNodes) {
        DasoConf dasoConf = this.otDasoConf();
        IAccessService accessService = (IAccessService)WTCAppContextHelper.getBean(AccessServiceImpl.class);
        if (dasoConf == null || ":".equals(dasoConf.getCoditionStr())) {
            logger.debug("OtCompensationEvaluator.doEvaluate otDataSource is null");
            return Collections.EMPTY_LIST;
        }
        List<TimeBucket> timeBucketList = accessService.accessFilterByConditionI(dataNodes, dasoConf.getCondition()).stream().collect(Collectors.toList());
        logger.debug("OtCompensationEvaluator.doEvaluate after dataSource filter,TieDataNodeStd collect size = {}", (Object)timeBucketList.size());
        return timeBucketList;
    }

    private boolean isNightShift(ShiftSpec shiftSpec) {
        if (shiftSpec.getOffNonPlan()) {
            return false;
        }
        return shiftSpec.getFirstRefDateType() != shiftSpec.getLastRefDateType() && shiftSpec.getLastShiftTime().isAfter(LocalTime.MIN);
    }

    private List<TimeBucket> splidByZeroPoints(TimeBucket timeBucket) {
        ArrayList res = Lists.newArrayListWithCapacity((int)2);
        TimeBucket bucket = timeBucket.clone();
        if (bucket.getStartTime() != null && bucket.getStartTime().toLocalDate().compareTo(bucket.getEndTime().toLocalDate()) != 0 && bucket.getEndTime().toLocalDate().atStartOfDay().compareTo(bucket.getEndTime()) != 0) {
            TimeBucket bucketStart = bucket.clone();
            bucketStart.setEndTime(bucket.getEndTime().toLocalDate().atStartOfDay());
            bucketStart.setDateAttribute(this.shiftTableSingle.getDateAttribute(bucketStart.getStartTime().toLocalDate()));
            bucketStart.setEndTimePointSource(SourceCode.NONE);
            TimeBucket bucketEnd = bucket.clone();
            bucketEnd.setStartTime(bucket.getEndTime().toLocalDate().atStartOfDay());
            bucketEnd.setDateAttribute(this.shiftTableSingle.getDateAttribute(bucketStart.getEndTime().toLocalDate()));
            bucketEnd.setStartTimePointSource(SourceCode.NONE);
            res.add(bucketStart);
            res.add(bucketEnd);
        } else {
            if (bucket.getStartTime() != null) {
                bucket.setDateAttribute(this.shiftTableSingle.getDateAttribute(bucket.getStartTime().toLocalDate()));
            }
            res.add(bucket);
        }
        return res;
    }

    private List<TimeBucket> splidByZeroPointsAddLabel(TimeBucket bucket) {
        ShiftSenceEnum shiftSenceEnum = ShiftSenceEnum.getDateSenceEnum(bucket, this.shiftTableSingle);
        List<TimeBucket> timeBucketList = this.splidByZeroPoints(bucket);
        for (TimeBucket timeBucket : timeBucketList) {
            if (!ShiftSenceEnum.DateAttributeList.contains(timeBucket.getDateAttribute())) continue;
            timeBucket.setLabelSet((LabelSet<ILabel>)LabelSet.singleton((ILabel)shiftSenceEnum.label));
        }
        return timeBucketList;
    }

    private boolean timeBucketneedSplid(TimeBucket bucket) {
        boolean need = false;
        ShiftSenceEnum shiftSenceEnum = ShiftSenceEnum.getDateSenceEnum(bucket, this.shiftTableSingle);
        switch (shiftSenceEnum) {
            case WORKRESTATTID: {
                if (!this.otsceneSet.contains("3")) break;
                need = true;
                break;
            }
            case WORKHOLIDATTID: {
                if (!this.otsceneSet.contains("2")) break;
                need = true;
                break;
            }
            case HOILDWORKATTID: {
                if (!this.otsceneSet.contains("1")) break;
                need = true;
                break;
            }
            case RESTWORKATTID: {
                if (!this.otsceneSet.contains("4")) break;
                need = true;
                break;
            }
        }
        return need;
    }

    private List<TimeBucket> splidDateAttribute(List<TieDataNodeStd> dataNodes) {
        ArrayList res = Lists.newArrayListWithCapacity((int)(dataNodes.size() * 2));
        for (TieDataNodeStd dataNode : dataNodes) {
            TimeBucketStd timeBucket = (TimeBucketStd)dataNode;
            TimeBucket bucket = timeBucket.unwrapAndCopy();
            List<Object> timeBucketList = Lists.newArrayListWithCapacity((int)2);
            if (this.timeBucketneedSplid(bucket)) {
                timeBucketList = this.splidByZeroPointsAddLabel(bucket);
            } else {
                timeBucketList.add(bucket);
            }
            res.addAll(timeBucketList);
        }
        return res;
    }

    private List<OtRuleCalConfig> limitScopeFilter(Set<BillRetrievalDimensionResult> billRetrievalResultOfDate) {
        ArrayList<OtRuleCalConfig> otRuleCalConfigResultList;
        AttfileLimitScopeServiceImpl AttfileLimitScopeService = new AttfileLimitScopeServiceImpl();
        logger.debug("OtCompensationEvaluator.doEvaluate before scopeLimit filter,ruleCalConfig  size = {}", (Object)this.ruleConfig.getOtRuleCalConfigList().size());
        Map<Long, AttfileLimitScope> limitScopeMap = ContextUtil.getLimitScopeMap(this.context);
        if (logger.isDebugEnabled()) {
            logger.debug("List<OtRulePackage> ruleConfigList={}", (Object)this.ruleConfig);
            logger.debug("OtCompensationEvaluator.doEvaluate limitScopeMap={}", limitScopeMap);
            logger.debug("OtCompensationEvaluator.doEvaluate context.getAttSubjectEntry()={}", (Object)this.context.getAttSubjectEntry());
        }
        WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(this.context, "kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin");
        AttfileLimitScope attfileLimitScope = limitScopeMap.get(this.context.getAttSubjectEntry().getAttFileVid());
        List<OtRuleCalConfig> otRuleCalConfigList = this.ruleConfig.getOtRuleCalConfigList();
        if (WTCCollections.isNotEmpty(otRuleCalConfigList)) {
            otRuleCalConfigResultList = new ArrayList(otRuleCalConfigList.size());
            for (OtRuleCalConfig otRuleCalConfig : otRuleCalConfigList) {
                boolean matchResult = false;
                if (WTCCollections.isEmpty(billRetrievalResultOfDate)) {
                    matchResult = AttfileLimitScopeService.matchLimit(attfileLimitScope, otRuleCalConfig.getLimitscope(), new LimitConditionExpBundle("OT", pluginProxy, Long.valueOf(this.context.getAttSubjectEntry().getAttFileVid())));
                } else {
                    for (BillRetrievalDimensionResult dimensionResult : billRetrievalResultOfDate) {
                        RuleConditionValues retrievalDimension = dimensionResult.getRetrievalDimension();
                        matchResult = AttfileLimitScopeService.matchLimit(attfileLimitScope, otRuleCalConfig.getLimitscope(), new LimitConditionExpBundle("OT", pluginProxy, Long.valueOf(this.context.getAttSubjectEntry().getAttFileVid())), retrievalDimension);
                        if (!matchResult) continue;
                        break;
                    }
                }
                if (!matchResult) continue;
                otRuleCalConfigResultList.add(otRuleCalConfig);
            }
        } else {
            otRuleCalConfigResultList = new ArrayList<OtRuleCalConfig>(0);
        }
        return otRuleCalConfigResultList;
    }

    private TimeBucketStd getTimeBucketStd(TimeBucket timeBucket) {
        TieDataNodeCore<TieDataNodeStd> dataNodeCore = new TieDataNodeCore<TieDataNodeStd>();
        dataNodeCore.setData(timeBucket);
        return new TimeBucketStd(dataNodeCore);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataNodeTieDataResult = super.beforeEvaluator(context, dataNodes);
        if (tieDataNodeTieDataResult != null) {
            return tieDataNodeTieDataResult;
        }
        List<Object> splidDateAttribute = new ArrayList();
        if (logger.isDebugEnabled()) {
            logger.debug("context.getAttPersonId(){},context.getChainDate(){},timeCut:{}", new Object[]{context.getAttPersonId(), context.getChainDate(), this.timeCut});
        }
        if (this.timeCut != null) {
            Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult> tuple3 = BillTieRetrievalUtil.getTimeCutRetrievalResultOfDate(context, this.isDirectSetRule, this.timeCut);
            this.timeCut = tuple3 == null ? CalTimeCutHelper.isMatcheDate(context, this.timeCut) : CalTimeCutHelper.isMatcheDate(context, this.timeCut, tuple3);
            if (logger.isDebugEnabled()) {
                logger.debug("isMatcheDate timeCut:{}", (Object)this.timeCut);
            }
            if (this.timeCut != null) {
                List timeBucketList = dataNodes.stream().map(tb -> ((TimeBucketStd)tb).unwrapAndCopy()).collect(Collectors.toList());
                for (TimeBucket timeBucket : timeBucketList) {
                    splidDateAttribute.addAll(CalTimeCutHelper.splidTimeBucket(context, timeBucket, this.timeCut));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("timeCut  splidDateAttribute:{}", splidDateAttribute);
                }
            } else {
                splidDateAttribute = dataNodes.stream().map(tb -> ((TimeBucketStd)tb).unwrapAndCopy()).collect(Collectors.toList());
            }
        } else if (WTCCollections.isNotEmpty((Collection)this.otsceneSet)) {
            splidDateAttribute = this.splidDateAttribute(dataNodes);
            if (logger.isDebugEnabled()) {
                logger.debug("timeCut  splidDateAttribute:{}", splidDateAttribute);
            }
        } else {
            splidDateAttribute = dataNodes.stream().map(tb -> ((TimeBucketStd)tb).unwrapAndCopy()).collect(Collectors.toList());
        }
        if (WTCCollections.isEmpty(splidDateAttribute)) {
            return this.otExclusion;
        }
        List<TimeBucket> filterByConditions = this.filterByDataSource(splidDateAttribute);
        Set<BillRetrievalDimensionResult> billRetrievalResultOfDate = BillTieRetrievalUtil.getBillRetrievalResultOfDate(context, this.isDirectSetRule, this.ruleConfig);
        List<OtRuleCalConfig> otRuleCalConfigList = this.limitScopeFilter(billRetrievalResultOfDate);
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        for (OtRuleCalConfig otRuleCalConfig : otRuleCalConfigList) {
            for (TimeBucket filterByCondition : filterByConditions) {
                ArrayList timeBucketsDateRange;
                OtRuleCalConfig calConfigEmpchoice = OtCompensationEvaluator.filterEmpchoice(context, otRuleCalConfig, filterByCondition);
                if (calConfigEmpchoice == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("OtCompensationEvaluator.doEvaluate bucketStds has no CompenType\uff0c{}", (Object)filterByCondition);
                    continue;
                }
                boolean filterResult = OtCompensationEvaluator.filter(context, calConfigEmpchoice.getDataSources(), filterByCondition, calConfigEmpchoice.getOtType());
                if (!filterResult) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("OtCompensationEvaluator.doEvaluate bucketStds loop timeSource and type  filterResult = false, bucketStd.getStartTime()={},otRuleCalConfig.getBaseDataId={},otRuleCalConfig.getOtType()={}", new Object[]{filterByCondition.getStartTime(), calConfigEmpchoice.getEntryId(), calConfigEmpchoice.getOtType()});
                    continue;
                }
                if (WTCCollections.isEmpty(billRetrievalResultOfDate)) {
                    timeBucketsDateRange = dateRangeService.filterDataNode(WTCDateRangeSource.OTP, context, this.getTimeBucketStd(filterByCondition), calConfigEmpchoice.getDateConditionAccessDto());
                } else {
                    HashSet timeBucketSet = Sets.newHashSetWithExpectedSize((int)16);
                    for (BillRetrievalDimensionResult dimensionResult : billRetrievalResultOfDate) {
                        RuleConditionValues retrievalDimension = dimensionResult.getRetrievalDimension();
                        List<TimeBucket> timeBucketList = dateRangeService.filterDataNode(WTCDateRangeSource.OTP, context, this.getTimeBucketStd(filterByCondition), calConfigEmpchoice.getDateConditionAccessDto(), retrievalDimension);
                        if (!WTCCollections.isNotEmpty(timeBucketList)) continue;
                        timeBucketSet.addAll(timeBucketList);
                        break;
                    }
                    timeBucketsDateRange = Lists.newArrayList((Iterable)timeBucketSet);
                }
                if (timeBucketsDateRange.isEmpty()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("OtCompensationEvaluator.doEvaluate bucketStds loop dateRangeService filterDataNodes  result = false, bucketStd.getStartTime()={},otRuleCalConfig.getBaseDataId()={}", (Object)filterByCondition.getStartTime(), (Object)calConfigEmpchoice.getEntryId());
                    continue;
                }
                for (TimeBucket timeBucket : timeBucketsDateRange) {
                    timeBucket.setMatchedRule(calConfigEmpchoice);
                    timeBucket.setEvaluationRule(EvaluationRuleModel.of(this.ruleConfig.getId(), "wtp_overworkrule"));
                    timeBucket.setAttItemInstances(this.getFilterList(calConfigEmpchoice.getMatchOtRuleCalCompenConfig().getOriginalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(timeBucket.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList()));
                    timeBucket.setParentDataNodes(dataNodes);
                    this.tieDataNodeList.add(timeBucket);
                    if (this.timeCut == null) {
                        this.creatAttItem(timeBucket);
                        continue;
                    }
                    this.creatAttItemTimeCut(context, timeBucket);
                }
            }
        }
        this.tieDataNodeList.addAll(this.attAttItems.values());
        return TieDataResultStd.success(this.tieDataNodeList);
    }

    private void creatAttItemTimeCut(TieContextStd context, TimeBucket timeBucket) {
        boolean iscutattitem = this.timeCut.isIscutattitemPre() || this.timeCut.isIscutattitemAfter();
        boolean dateAttributeIsChange = CalTimeCutHelper.dateAttributeIsChange(context, timeBucket);
        if (iscutattitem && dateAttributeIsChange && (timeBucket.getShiftTimeBucketProperty() == ShiftTimeBucketPropertyEnum.ATTENDANCE || timeBucket.getShiftTimeBucketProperty() == ShiftTimeBucketPropertyEnum.CORE_ATT)) {
            for (Long attItemBid : this.timeCut.getCutattitems()) {
                if (attItemBid == null || attItemBid.equals(0L)) continue;
                TimeBucket bucketClone = timeBucket.clone();
                bucketClone.setParentDataNodes(timeBucket.parentDataNodes());
                bucketClone.setMatchedRule(null);
                bucketClone.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, bucketClone.getDurationOfSecond(), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(attItemBid, this.chainDate))));
                this.attAttItems.put(bucketClone.getStartTime().toString() + bucketClone.getEndTime(), bucketClone);
            }
        }
    }

    private void creatAttItem(TimeBucket timeBucket) {
        ILabel label = null;
        for (ILabel iLabel : timeBucket.getLabelSet()) {
            if (!this.labels.contains(iLabel)) continue;
            label = iLabel;
        }
        if (label == null) {
            return;
        }
        if (!timeBucket.getLabelSet().contains(label)) {
            return;
        }
        TimeBucket bucketClone = timeBucket.clone();
        bucketClone.setParentDataNodes(timeBucket.parentDataNodes());
        bucketClone.setMatchedRule(null);
        if (label.getValue() != null && this.isNightShift(timeBucket.getShiftSpec()) && (timeBucket.getShiftTimeBucketProperty() == ShiftTimeBucketPropertyEnum.ATTENDANCE || timeBucket.getShiftTimeBucketProperty() == ShiftTimeBucketPropertyEnum.CORE_ATT) && timeBucket.getLabelSet().contains((Object)label)) {
            long attItemBid = Long.parseLong(label.getValue());
            bucketClone.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, bucketClone.getDurationOfSecond(), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(attItemBid, this.chainDate))));
            this.attAttItems.put(bucketClone.getStartTime().toString() + bucketClone.getEndTime(), bucketClone);
        }
    }

    static /* synthetic */ Label access$200() {
        return workHolidLabel;
    }

    static /* synthetic */ Label access$300() {
        return hoildWorkLabel;
    }

    static /* synthetic */ Label access$400() {
        return workRestLabel;
    }

    static /* synthetic */ Label access$500() {
        return RestWorkLabel;
    }

    private static enum ShiftSenceEnum {
        WORKHOLIDATTID(OtCompensationEvaluator.access$200(), OverworkAttendanceEnum.OT_WORKHOLIDATTID.getBid()),
        HOILDWORKATTID(OtCompensationEvaluator.access$300(), OverworkAttendanceEnum.OT_HOILDWORKATTID.getBid()),
        WORKRESTATTID(OtCompensationEvaluator.access$400(), OverworkAttendanceEnum.OT_WORKRESTATTID.getBid()),
        RESTWORKATTID(OtCompensationEvaluator.access$500(), OverworkAttendanceEnum.OT_RESTWORKATTID.getBid()),
        UNKNOWN(null, null);

        DateAttribute dateAttribute;
        Label label;
        Long itemId;
        private static final List<DateAttribute> DateAttributeList;

        private ShiftSenceEnum(Label label, Long itemId) {
            this.label = label;
            this.itemId = itemId;
        }

        private static ShiftSenceEnum getDateSenceEnum(TimeBucket bucket, ShiftTableSingle shiftTableSingle) {
            DateAttribute startDateAttribute = shiftTableSingle.getDateAttribute(bucket.getShiftDate());
            DateAttribute endDateAttribute = shiftTableSingle.getDateAttribute(bucket.getShiftDate().plusDays(1L));
            if (startDateAttribute != null) {
                switch (startDateAttribute) {
                    case WORKDAY: {
                        if (endDateAttribute == DateAttribute.HOLIDAY) {
                            return WORKHOLIDATTID;
                        }
                        if (endDateAttribute != DateAttribute.OFFDAY) break;
                        return WORKRESTATTID;
                    }
                    case HOLIDAY: {
                        if (endDateAttribute != DateAttribute.WORKDAY) break;
                        return HOILDWORKATTID;
                    }
                    case OFFDAY: {
                        if (endDateAttribute != DateAttribute.WORKDAY) break;
                        return RESTWORKATTID;
                    }
                    default: {
                        return UNKNOWN;
                    }
                }
            }
            return UNKNOWN;
        }

        static {
            DateAttributeList = Lists.newArrayList((Object[])new DateAttribute[]{DateAttribute.HOLIDAY, DateAttribute.OFFDAY});
        }
    }
}

