/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCommonEvaluator;
import kd.wtc.wtes.business.executor.rlotcal.OtCompensationEvaluator;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class OtDeductEvaluator
extends OtCommonEvaluator
implements TieEvaluatorStd {
    private static final Log logger = LogFactory.getLog(OtCompensationEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return super.evaluate(context, this);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataNodeTieDataResult = this.beforeEvaluator(context, dataNodes);
        if (tieDataNodeTieDataResult != null) {
            return tieDataNodeTieDataResult;
        }
        List timeBucketList = RawTimeBucket.sorted(this.tieDataNodeStdList).getTimeBuckets().stream().map(std -> {
            TimeBucket timeBucket = std.unwrapAndCopy();
            timeBucket.setParentDataNodes(Collections.singletonList(std));
            return timeBucket;
        }).collect(Collectors.toList());
        List dataNodes1 = dataNodes.stream().filter(item -> item.getMatchedRule() != null).collect(Collectors.toList());
        Map<IEntity, List<TieDataNodeStd>> groupByRules = dataNodes1.stream().collect(Collectors.groupingBy(TieDataNodeStd::getMatchedRule));
        timeBucketList = timeBucketList.stream().filter(item -> item.getMatchedRule() != null).collect(Collectors.toList());
        Map<IEntity, List<TimeBucket>> groupByRule = timeBucketList.stream().collect(Collectors.groupingBy(TieDataNode::getMatchedRule));
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        logger.debug("\u52a0\u73ed\u8d77\u7b97\u8ba1\u7b97timeBucketList\uff1a{}\uff0cshiftTableSingle:{},shiftSpec\uff1a{}", new Object[]{timeBucketList, shiftTableSingle, this.shiftSpec});
        for (Map.Entry<IEntity, List<TimeBucket>> entry : groupByRule.entrySet()) {
            OtRuleCalConfig ruleConfig = (OtRuleCalConfig)entry.getKey();
            BigDecimal originalConf = ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalconf();
            BigDecimal oriConfSecond = originalConf.multiply(BigDecimal.valueOf(3600L));
            for (TimeBucket timeBucket : entry.getValue()) {
                List<AttItemInstance> attItemInstances;
                LocalDateTime timeBucketStart = timeBucket.getStartTime();
                LocalDateTime timeBucketEnd = timeBucket.getEndTime();
                if (timeBucketStart == null || this.shiftSpec.isOff() && this.shiftSpec.getOffNonPlan()) {
                    List<AttItemInstance> attItemInstances2 = this.getFilterList(ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalCalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(timeBucket.getDurationOfSecond()), shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList());
                    timeBucket.setAttItemInstances(attItemInstances2);
                    this.tieDataNodeList.add(timeBucket);
                    continue;
                }
                LocalDateTime realLastShiftTime = this.shiftSpec.getRealLastShiftTime(this.chainDate);
                LocalDateTime startPointTime = realLastShiftTime.plusSeconds(oriConfSecond.intValue());
                if (timeBucketStart.compareTo(realLastShiftTime) >= 0 && timeBucketStart.compareTo(startPointTime) < 0) {
                    if (timeBucketEnd.compareTo(startPointTime) <= 0) {
                        timeBucket.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(timeBucketStart, timeBucketEnd).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                        this.tieDataNodeList.add(timeBucket);
                        continue;
                    }
                    TimeBucket deductTimeBucket = timeBucket.clone();
                    deductTimeBucket.setEndTime(startPointTime);
                    deductTimeBucket.setParentDataNodes(groupByRules.get(entry.getKey()));
                    deductTimeBucket.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(timeBucketStart, startPointTime).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                    this.tieDataNodeList.add(deductTimeBucket);
                    timeBucket.setStartTime(startPointTime);
                    timeBucket.setStartTimePointSource(SourceCode.NONE);
                    List<AttItemInstance> attItemInstances3 = this.getFilterList(ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalCalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(startPointTime, timeBucketEnd).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList());
                    timeBucket.setAttItemInstances(attItemInstances3);
                    this.tieDataNodeList.add(timeBucket);
                    continue;
                }
                if (timeBucketStart.compareTo(realLastShiftTime) < 0 && timeBucketEnd.compareTo(realLastShiftTime) > 0) {
                    TimeBucket deductTimeBucket;
                    attItemInstances = this.getFilterList(ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalCalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(timeBucketStart, realLastShiftTime).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList());
                    timeBucket.setAttItemInstances(attItemInstances);
                    timeBucket.setEndTime(realLastShiftTime);
                    timeBucket.setEndTimePointSource(SourceCode.NONE);
                    this.tieDataNodeList.add(timeBucket);
                    if (startPointTime.compareTo(timeBucketEnd) < 0) {
                        deductTimeBucket = timeBucket.clone();
                        deductTimeBucket.setStartTime(realLastShiftTime);
                        deductTimeBucket.setEndTime(startPointTime);
                        deductTimeBucket.setParentDataNodes(groupByRules.get(entry.getKey()));
                        deductTimeBucket.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(realLastShiftTime, startPointTime).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                        this.tieDataNodeList.add(deductTimeBucket);
                        TimeBucket startTimeBucket = timeBucket.clone();
                        startTimeBucket.setStartTime(startPointTime);
                        startTimeBucket.setParentDataNodes(groupByRules.get(entry.getKey()));
                        List<AttItemInstance> startAttItemInstances = this.getFilterList(ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalCalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(startPointTime, timeBucketEnd).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList());
                        startTimeBucket.setAttItemInstances(startAttItemInstances);
                        this.tieDataNodeList.add(startTimeBucket);
                        continue;
                    }
                    deductTimeBucket = timeBucket.clone();
                    deductTimeBucket.setParentDataNodes(groupByRules.get(entry.getKey()));
                    deductTimeBucket.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(realLastShiftTime, timeBucketEnd).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                    this.tieDataNodeList.add(deductTimeBucket);
                    continue;
                }
                attItemInstances = this.getFilterList(ruleConfig.getMatchOtRuleCalCompenConfig().getOriginalCalPrjSet()).stream().map(itemId -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(Duration.between(timeBucketStart, timeBucketEnd).getSeconds()), shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate))).collect(Collectors.toList());
                timeBucket.setAttItemInstances(attItemInstances);
                timeBucket.setParentDataNodes(groupByRules.get(entry.getKey()));
                this.tieDataNodeList.add(timeBucket);
            }
        }
        return TieDataResultStd.success(this.tieDataNodeList);
    }
}

