/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.executor.rlotcal.OtCommonEvaluator;
import kd.wtc.wtes.business.executor.rlotcal.OtExtHelper;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.RoundRuleService;

public class OtRoundEvaluator
extends OtCommonEvaluator
implements TieEvaluatorStd {
    private static final Log logger = LogFactory.getLog(OtCommonEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return super.evaluate(context, this);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataNodeTieDataResult = this.beforeEvaluator(context, dataNodes);
        if (tieDataNodeTieDataResult != null) {
            return tieDataNodeTieDataResult;
        }
        Map<IEntity, List<TieDataNodeStd>> groupByMatchedRule = this.tieDataNodeStdList.stream().collect(Collectors.groupingBy(TieDataNodeStd::getMatchedRule));
        logger.debug("attPersonId={},chainDate={}", (Object)this.attPersonId, (Object)this.chainDate);
        ArrayList lItems = new ArrayList();
        for (TieDataNodeStd std : this.tieDataNodeStdList) {
            lItems.addAll(std.getAttItemInstances().stream().map(attItemInstance -> new AttItem(attItemInstance.getSecondDecimal(), std.getMatchedRule(), std.getEvaluationRule())).collect(Collectors.toList()));
        }
        Map<IEntity, List<AttItem>> as = lItems.stream().collect(Collectors.groupingBy(AttItem::getRule));
        ArrayList<AttItemValue> allAttItemVal = new ArrayList<AttItemValue>(10);
        for (Map.Entry<IEntity, List<AttItem>> asEntry : as.entrySet()) {
            List<AttItemValue> attItemValueList = this.mergeAttItemValueStdToAttItem(asEntry.getKey(), asEntry.getValue());
            for (AttItemValue itemValue : attItemValueList) {
                itemValue.setParentDataNodes(groupByMatchedRule.get(asEntry.getKey()));
            }
            allAttItemVal.addAll(attItemValueList);
        }
        List<AttItemValue> attItemValues = OtExtHelper.afterExecOvertime(context, allAttItemVal, this.ruleConfig);
        allAttItemVal.addAll(attItemValues);
        return TieDataResultStd.success(allAttItemVal);
    }

    private List<AttItemValue> mergeAttItemValueStdToAttItem(IEntity rul, List<AttItem> attItems) {
        BigDecimal roundSecResult;
        OtRuleCalConfig otRuleCalConfig = (OtRuleCalConfig)rul;
        BigDecimal totalDeductionSecResult = BigDecimal.ZERO;
        BigDecimal totalSec = BigDecimal.ZERO;
        for (AttItem attItem : attItems) {
            totalSec = totalSec.add(attItem.getSeconds());
        }
        Long roundRule = otRuleCalConfig.getMatchOtRuleCalCompenConfig().getBfroundingRule();
        if (roundRule == null || roundRule.equals(0L)) {
            roundSecResult = totalSec;
        } else {
            List<AttItemSpec> specs = this.genAttItemSpec(otRuleCalConfig.getMatchOtRuleCalCompenConfig().getResultPrjSet());
            if (WTCCollections.isEmpty(specs)) {
                logger.debug("otRuleCalConfig.getResultPrjSet():{}", otRuleCalConfig.getMatchOtRuleCalCompenConfig().getResultPrjSet());
                return Lists.newArrayList();
            }
            AttItemSpec roundSpec = specs.get(0);
            Map<Long, RoundWrapper> roundWrapperMap = ContextUtil.getRoundWrapperMap(this.context);
            RoundWrapper roundWrapper = roundWrapperMap.get(otRuleCalConfig.getMatchOtRuleCalCompenConfig().getBfroundingRule());
            roundSecResult = RoundRuleService.roundValue(roundWrapper, totalSec, roundSpec, ContextUtil.getShiftSpec(this.context));
            logger.debug("attPersonId={},chainDate={}, totalSec={}, roundSecResult={}", new Object[]{this.attPersonId, this.chainDate, totalSec, roundSecResult});
            totalDeductionSecResult = totalSec.subtract(roundSecResult);
        }
        List<AttItemInstance> attItemInstances = this.genAttItemInstances(otRuleCalConfig.getMatchOtRuleCalCompenConfig().getResultPrjSet(), roundSecResult);
        if (totalDeductionSecResult.compareTo(BigDecimal.ZERO) != 0) {
            List<AttItemInstance> invalidAttItemInstances = this.genAttItemInstances(Lists.newArrayList((Object[])new Long[]{OverworkAttendanceEnum.OT_INVALID.getBid()}), totalDeductionSecResult);
            attItemInstances.addAll(invalidAttItemInstances);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("attPersonId={},chainDate={}, ", (Object)this.attPersonId, (Object)this.chainDate);
        }
        return attItemInstances.stream().map(attItemInstance -> (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().evaluationRule(((AttItem)attItems.get(0)).geteRuleModel())).attItemInstance((AttItemInstance)attItemInstance)).build()).collect(Collectors.toList());
    }

    private List<AttItemSpec> genAttItemSpec(Collection<Long> attItemList) {
        ArrayList<AttItemSpec> specs = new ArrayList<AttItemSpec>(10);
        List<Long> dropAttItemIds = this.getFilterList(attItemList);
        for (Long dropAttItemId : dropAttItemIds) {
            specs.add(this.attItemSpecData.getByBidAndDate(dropAttItemId, this.chainDate));
        }
        return specs;
    }

    static class AttItem {
        BigDecimal seconds;
        private IEntity rule;
        private EvaluationRuleModel eRuleModel;

        public AttItem(BigDecimal seconds, IEntity rule, EvaluationRuleModel eRuleModel) {
            this.seconds = seconds;
            this.rule = rule;
            this.eRuleModel = eRuleModel;
        }

        public BigDecimal getSeconds() {
            return this.seconds;
        }

        public void setSeconds(BigDecimal seconds) {
            this.seconds = seconds;
        }

        public IEntity getRule() {
            return this.rule;
        }

        public void setRule(IEntity rule) {
            this.rule = rule;
        }

        public EvaluationRuleModel geteRuleModel() {
            return this.eRuleModel;
        }

        public void seteRuleModel(EvaluationRuleModel eRuleModel) {
            this.eRuleModel = eRuleModel;
        }
    }
}

