/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigData;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigEntity;
import kd.wtc.wtes.business.service.IAttStatusConfigService;
import kd.wtc.wtes.business.service.impl.AttStatusConfigServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerAttStatusRelation
implements TieParamInitializer {
    protected IAttStatusConfigService attStatusConfigService;

    public TieInitializerAttStatusRelation(IAttStatusConfigService attStatusConfigService) {
        this.attStatusConfigService = attStatusConfigService;
    }

    public TieInitializerAttStatusRelation() {
        this.attStatusConfigService = new AttStatusConfigServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        Map<Long, List<AttStatusConfigEntity>> bo2His = this.getAttStatusConfigMap(initRequest);
        List<TimeSeqBo<AttStatusConfigEntity>> attStatusConfigBo = this.listTimeSeqBo(bo2His, warnInfoList);
        AttStatusConfigData attStatusConfigData = AttStatusConfigData.of(attStatusConfigBo);
        if (CollectionUtils.isNotEmpty(warnInfoList)) {
            String warnInfo = this.getWarnInfo(warnInfoList);
            return InitParamResult.partial(attStatusConfigData, new TieMessageStd(TieMsgLevel.WARNING, warnInfo));
        }
        return InitParamResult.success(attStatusConfigData);
    }

    @Override
    public String category() {
        return "ATT_STATUS_RELATION";
    }

    private Map<Long, List<AttStatusConfigEntity>> getAttStatusConfigMap(InitParam initRequest) {
        List<AttStatusConfigEntity> attStatusConfigEntityList = this.attStatusConfigService.listValidHisVersionsInRangeDate(initRequest.getStartDate(), initRequest.getEndDate());
        if (attStatusConfigEntityList.isEmpty()) {
            return Collections.emptyMap();
        }
        return attStatusConfigEntityList.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
    }

    private List<TimeSeqBo<AttStatusConfigEntity>> listTimeSeqBo(Map<Long, List<AttStatusConfigEntity>> bo2His, List<Long> warnInfoList) {
        ArrayList<TimeSeqBo<AttStatusConfigEntity>> attStatusConfigBo = new ArrayList<TimeSeqBo<AttStatusConfigEntity>>(bo2His.size());
        bo2His.forEach((bid, attStatusConfig) -> {
            try {
                AttStatusConfigEntity attStatusConfigEntity = (AttStatusConfigEntity)((Object)((Object)attStatusConfig.get(0)));
                TimeSeqBo timeSeqBo = attStatusConfigEntity.hasTimeSeqInfo() ? TimeSeqBo.ofMultiTimeSeq((Collection)attStatusConfig) : TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)attStatusConfigEntity);
                attStatusConfigBo.add(timeSeqBo);
            }
            catch (Exception e) {
                warnInfoList.add((Long)bid);
            }
        });
        return attStatusConfigBo;
    }

    private String getWarnInfo(List<Long> warnInfoList) {
        return "attStatusConfigEntity happen exception, key:[" + StringUtils.join(warnInfoList, (String)",") + "]";
    }
}

