/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.rlra.PunchCardTagData;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEntity;
import kd.wtc.wtes.business.service.IPunchCardTagService;
import kd.wtc.wtes.business.service.impl.PunchCardTagServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerPunchCardTagRelation
implements TieParamInitializer {
    protected IPunchCardTagService punchCardTagService;

    public TieInitializerPunchCardTagRelation(IPunchCardTagService punchCardTagService) {
        this.punchCardTagService = punchCardTagService;
    }

    public TieInitializerPunchCardTagRelation() {
        this.punchCardTagService = new PunchCardTagServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        Map<Long, List<PunchCardTagEntity>> bo2His = this.getPunchCardTag(initRequest);
        List<TimeSeqBo<PunchCardTagEntity>> punchCardTagBo = this.listTimeSeqBo(bo2His, warnInfoList);
        PunchCardTagData punchCardTagData = PunchCardTagData.of(punchCardTagBo);
        if (CollectionUtils.isNotEmpty(warnInfoList)) {
            String warnInfo = this.getWarnInfo(warnInfoList);
            return InitParamResult.partial(punchCardTagData, new TieMessageStd(TieMsgLevel.WARNING, warnInfo));
        }
        return InitParamResult.success(punchCardTagData);
    }

    @Override
    public String category() {
        return "CHECKPOINT_TAG";
    }

    private Map<Long, List<PunchCardTagEntity>> getPunchCardTag(InitParam initRequest) {
        List<PunchCardTagEntity> punchCardTagEntityList = this.punchCardTagService.listValidHisVersionsInRangeDate(initRequest.getStartDate(), initRequest.getEndDate());
        if (punchCardTagEntityList.isEmpty()) {
            return Collections.emptyMap();
        }
        return punchCardTagEntityList.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
    }

    private List<TimeSeqBo<PunchCardTagEntity>> listTimeSeqBo(Map<Long, List<PunchCardTagEntity>> bo2His, List<Long> warnInfoList) {
        ArrayList<TimeSeqBo<PunchCardTagEntity>> punchCardTagBo = new ArrayList<TimeSeqBo<PunchCardTagEntity>>(bo2His.size());
        bo2His.forEach((bid, punchCardTag) -> {
            try {
                PunchCardTagEntity punchCardTagEntity = (PunchCardTagEntity)((Object)((Object)punchCardTag.get(0)));
                TimeSeqBo timeSeqBo = punchCardTagEntity.hasTimeSeqInfo() ? TimeSeqBo.ofMultiTimeSeq((Collection)punchCardTag) : TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)punchCardTagEntity);
                punchCardTagBo.add(timeSeqBo);
            }
            catch (Exception e) {
                warnInfoList.add((Long)bid);
            }
        });
        return punchCardTagBo;
    }

    private String getWarnInfo(List<Long> warnInfoList) {
        return "punchCardTagEntity happen exception, key:[" + StringUtils.join(warnInfoList, (String)",") + "]";
    }
}

