/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.pairtime.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.model.evaluation.ShiftInfoVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.NonTimeHandler;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawPara;
import kd.wtc.wtes.business.model.AbsenceBillState;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.TravelBillState;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigData;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.CardExceptionTypeEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.ShouldPunchCardSeqCounter;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPunchCardRelationEnum;
import kd.wtc.wtes.business.model.rlra.TimeSeqCounter;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.enums.BillTimeBucketType;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;
import kd.wtc.wtes.common.pairtime.PairTimeSplitWrapper;
import kd.wtc.wtes.common.pairtime.SourceCode;

public abstract class AbstractSplitTimeBucket
implements NonTimeHandler {
    private static final Log logger = LogFactory.getLog(AbstractSplitTimeBucket.class);
    protected static final Date NON_TIME_POINT = WTCDateUtils.toDate((LocalDate)LocalDate.of(4000, 1, 1));
    protected static final int ON_DUTY = 1;
    protected static final int ONDUTYSTATUS_INDEX = 0;
    protected static final int TIMESEQINDEX_INDEX = 1;
    protected static final int EFFECTCARDSTATUS_INDEX = 0;
    protected static final int ATTSTATUS_INDEX = 1;
    protected static final int OFF_DUTY = 2;
    private static final int[] TIME_SEQ_ATT = new int[]{1, 2, 3, 4, 5};
    private static final int[] TIME_SEQ_REST = new int[]{6, 7, 8, 9};
    private static final int NON_TIME_SEQ = 0;

    public List<TimeBucket> calculate(TieContextStd context, RawPara para) {
        ArrayList<TimeBucket.Builder> timeBucketBuilderList = new ArrayList<TimeBucket.Builder>(16);
        List<AbstractCardPoint> allTimePoint = this.getAllTimePoint(context, para, this.getPairTimeSplitWrappers(para));
        logger.debug("allTimePoint = {}", allTimePoint);
        if (allTimePoint.isEmpty()) {
            return Collections.emptyList();
        }
        AbstractCardPoint previousPoint = null;
        ArrayList<TimeBucket.Builder> rawTimeBucketTempList = new ArrayList<TimeBucket.Builder>(10);
        ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum = ShiftTimeBucketPropertyEnum.BEFORE_SHIFT;
        ShiftTimeBucketPropertyEnum preShiftTimeBucketPropertyEnum = null;
        AttendanceBillTag billTag = AttendanceBillTag.NOSTATUSTAG;
        int effectCardStatus = 0;
        int preEffectCardStatus = 0;
        int attStatus = 0;
        int onDutyStatus = 0;
        int timeSeqIndex = 0;
        TimeSeqCounter timeSeqCounter = new TimeSeqCounter(context);
        ShouldPunchCardSeqCounter shouldPunchCardSeqCounter = new ShouldPunchCardSeqCounter(context);
        TimeBucketPunchCardRelationEnum timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY;
        TravelBillState travelBillState = new TravelBillState();
        AbsenceBillState absenceBillState = new AbsenceBillState();
        List<TimeBucket> nonTimeBucketList = this.dealNonTimePoint(allTimePoint, context, para);
        for (int i = 0; i < allTimePoint.size(); ++i) {
            AbstractCardPoint cardPoint = allTimePoint.get(i);
            if (previousPoint == null || previousPoint.getTimePoint().equals(cardPoint.getTimePoint())) {
                if (previousPoint != null) {
                    previousPoint.merge(cardPoint);
                }
                preShiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum;
                shiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum.switchShiftTimeBucketPropertyStatus(cardPoint, para.roster.getShiftSpec().getOffNonPlan());
                billTag = billTag.switchAttendanceBillTag(cardPoint);
                Tuple<Integer, Integer> stateAndIndex = this.switchTimeSeqIndex(cardPoint, onDutyStatus, timeSeqIndex);
                onDutyStatus = (Integer)stateAndIndex.item1;
                timeSeqIndex = (Integer)stateAndIndex.item2;
                timeSeqCounter.switchTimeSeqIndex(cardPoint);
                shouldPunchCardSeqCounter.switchShouldPunchCardSeqIndex(cardPoint);
                Tuple<Integer, Integer> status = this.switchEffectCardStatus(effectCardStatus, attStatus, cardPoint);
                preEffectCardStatus = effectCardStatus;
                effectCardStatus = (Integer)status.item1;
                attStatus = (Integer)status.item2;
                previousPoint = cardPoint;
                absenceBillState.checkBillState(null, i == allTimePoint.size() - 1);
                travelBillState.checkBillState(null, i == allTimePoint.size() - 1);
                this.dealBeforeDuty(rawTimeBucketTempList, effectCardStatus, attStatus);
                continue;
            }
            if (16 == cardPoint.getPointType() && ShiftTimeBucketPropertyEnum.AFTER_SHIFT == preShiftTimeBucketPropertyEnum) {
                shiftTimeBucketPropertyEnum = ShiftTimeBucketPropertyEnum.AFTER_SHIFT;
            }
            TimeBucketPositionEnum timeBucketPositionEnum = shiftTimeBucketPropertyEnum.genTimeBucketPosition();
            Object rawTimeBucketBuilder = ((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)TimeBucket.builder().startTime(WTCDateUtils.toLocalDateTime((Date)previousPoint.getTimePoint()))).endTime(WTCDateUtils.toLocalDateTime((Date)cardPoint.getTimePoint()))).shiftTimeBucketProperty(shiftTimeBucketPropertyEnum)).timeBucketPosition(timeBucketPositionEnum)).attendanceBillTag(billTag)).absenceBillStateToBuilder(absenceBillState)).travelBillStateToBuilder(travelBillState)).startTimePointSourceToBuilder(previousPoint.getSource())).endTimePointSourceToBuilder(cardPoint.getSource());
            ((TimeBucket.Builder)rawTimeBucketBuilder).shiftTimeBucketSeqId(timeSeqCounter.getTimeSeqId(shiftTimeBucketPropertyEnum));
            ((TimeBucket.Builder)rawTimeBucketBuilder).shouldPunchCardSeqId(shouldPunchCardSeqCounter.getShouldPunchCardSeqId(timeBucketPositionEnum));
            timeCardRelation = this.getTimeBucketPunchCardRelationEnum(allTimePoint, (List<TimeBucket.Builder>)rawTimeBucketTempList, (TimeBucket.Builder)rawTimeBucketBuilder, shiftTimeBucketPropertyEnum, effectCardStatus, attStatus, timeCardRelation, i, cardPoint, preEffectCardStatus, preShiftTimeBucketPropertyEnum, previousPoint);
            ((TimeBucket.Builder)rawTimeBucketBuilder).timeBucketPunchCardRelation(timeCardRelation);
            CardExceptionTypeEnum cardExceptionTypeEnum = timeCardRelation.genCardExceptionType();
            ((TimeBucket.Builder)rawTimeBucketBuilder).cardExceptionType(cardExceptionTypeEnum);
            this.setOtherAttr((TimeBucket.Builder)rawTimeBucketBuilder, para);
            absenceBillState.checkBillState((TimeBucket.Builder)rawTimeBucketBuilder, i == allTimePoint.size() - 1);
            travelBillState.checkBillState((TimeBucket.Builder)rawTimeBucketBuilder, i == allTimePoint.size() - 1);
            preShiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum;
            shiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum.switchShiftTimeBucketPropertyStatus(cardPoint, para.roster.getShiftSpec().getOffNonPlan());
            billTag = billTag.switchAttendanceBillTag(cardPoint);
            Tuple<Integer, Integer> stateAndIndex = this.switchTimeSeqIndex(cardPoint, onDutyStatus, timeSeqIndex);
            onDutyStatus = (Integer)stateAndIndex.item1;
            timeSeqIndex = (Integer)stateAndIndex.item2;
            timeSeqCounter.switchTimeSeqIndex(cardPoint);
            shouldPunchCardSeqCounter.switchShouldPunchCardSeqIndex(cardPoint);
            Tuple<Integer, Integer> status = this.switchEffectCardStatus(effectCardStatus, attStatus, cardPoint);
            preEffectCardStatus = effectCardStatus;
            effectCardStatus = (Integer)status.item1;
            attStatus = (Integer)status.item2;
            previousPoint = cardPoint;
            timeBucketBuilderList.add((TimeBucket.Builder)rawTimeBucketBuilder);
        }
        List<TimeBucket> timeBuckets = this.buildForRaw(timeBucketBuilderList);
        timeBuckets.addAll(nonTimeBucketList);
        this.afterCalculate(timeBuckets, para);
        return timeBuckets;
    }

    protected abstract void afterCalculate(List<TimeBucket> var1, RawPara var2);

    protected List<TimeBucket> dealNonTimePoint(List<AbstractCardPoint> allTimePoint, TieContextStd context, RawPara para) {
        return Collections.emptyList();
    }

    protected List<TimeBucket> buildForRaw(List<TimeBucket.Builder> timeBucketBuilderList) {
        return timeBucketBuilderList.stream().map(TimeBucket.Builder::buildForRaw).collect(Collectors.toList());
    }

    private TimeBucketPunchCardRelationEnum getTimeBucketPunchCardRelationEnum(List<AbstractCardPoint> allTimePoint, List<TimeBucket.Builder> rawTimeBucketTempList, TimeBucket.Builder rawTimeBucketBuilder, ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum, int effectCardStatus, int attStatus, TimeBucketPunchCardRelationEnum timeCardRelation, int index, AbstractCardPoint cardPoint, int preEffectCardStatus, ShiftTimeBucketPropertyEnum preShiftTimeBucketPropertyEnum, AbstractCardPoint previousPoint) {
        if (attStatus == 0) {
            rawTimeBucketTempList.add(rawTimeBucketBuilder);
        } else {
            timeCardRelation = this.doGetTimeBucketPunchCardRelationEnum(allTimePoint, shiftTimeBucketPropertyEnum, effectCardStatus, attStatus, timeCardRelation, index, cardPoint);
            if (!rawTimeBucketTempList.isEmpty()) {
                TimeBucketPunchCardRelationEnum preTimeCardRelation = this.doGetTimeBucketPunchCardRelationEnum(allTimePoint, preShiftTimeBucketPropertyEnum, preEffectCardStatus, attStatus, timeCardRelation, index, previousPoint);
                this.dealTempList(rawTimeBucketTempList, preTimeCardRelation);
            }
        }
        return timeCardRelation;
    }

    private void dealBeforeDuty(List<TimeBucket.Builder> rawTimeBucketTempList, int effectCardStatus, int attStatus) {
        if (attStatus == 0 || rawTimeBucketTempList.isEmpty()) {
            return;
        }
        TimeBucket.Builder builder = rawTimeBucketTempList.get(0);
        TimeBucketPunchCardRelationEnum timeBucketPunchCardRelation = builder.getTimeBucketPunchCardRelation();
        if (timeBucketPunchCardRelation == TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY && attStatus == 1 && effectCardStatus == 1) {
            this.dealTempList(rawTimeBucketTempList, timeBucketPunchCardRelation);
        }
    }

    private void dealTempList(List<TimeBucket.Builder> rawTimeBucketTempList, TimeBucketPunchCardRelationEnum timeCardRelation) {
        rawTimeBucketTempList.forEach(temp -> {
            temp.timeBucketPunchCardRelation(timeCardRelation);
            temp.cardExceptionType(timeCardRelation.genCardExceptionType());
        });
        rawTimeBucketTempList.clear();
    }

    private TimeBucketPunchCardRelationEnum doGetTimeBucketPunchCardRelationEnum(List<AbstractCardPoint> allTimePoint, ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum, int effectCardStatus, int attStatus, TimeBucketPunchCardRelationEnum timeCardRelation, int index, AbstractCardPoint cardPoint) {
        if (attStatus == 1) {
            if (effectCardStatus == 0) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY;
            } else if (effectCardStatus == 1) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.IN_DUTY;
            } else if (effectCardStatus == 2) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.AFTER_OFF_DUTY;
                if (shiftTimeBucketPropertyEnum == ShiftTimeBucketPropertyEnum.REST) {
                    int res = this.continueToConfirm(allTimePoint, index);
                    if (res == 1) {
                        timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY_ABSENT;
                    } else if (res == 2) {
                        timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY;
                    }
                }
                if (this.isHaveOnDutyCard(cardPoint)) {
                    timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY;
                }
            }
        } else if (attStatus == 2) {
            if (effectCardStatus == 0) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.NON_CARD_ABSENT;
            } else if (effectCardStatus == 1) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.NON_CARD_ABSENT;
            } else if (effectCardStatus == 2) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.NON_CARD_ABSENT;
            }
        } else if (attStatus == 3) {
            if (effectCardStatus == 0) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_OFF_DUTY_ABSENT;
            } else if (effectCardStatus == 2) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.AFTER_OFF_DUTY_ABSENT;
            }
        } else if (attStatus == 4) {
            if (effectCardStatus == 0) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.BEFORE_ON_DUTY_ABSENT;
            } else if (effectCardStatus == 1) {
                timeCardRelation = TimeBucketPunchCardRelationEnum.AFTER_ON_DUTY_ABSENT;
            }
        }
        return timeCardRelation;
    }

    private boolean isHaveOnDutyCard(AbstractCardPoint cardPoint) {
        return cardPoint.getPointType() == 4 || cardPoint.getPointType() == 5 || cardPoint.getPointType() == 6 || cardPoint.getPointType() == 19 || cardPoint.getPointType() == 41 || cardPoint.getPointType() == 22 || cardPoint.getPointType() == 25 || cardPoint.getPointType() == 36 || cardPoint.getPointType() == 37;
    }

    protected int continueToConfirm(List<AbstractCardPoint> allTimePoint, int index) {
        for (int i = index + 1; i < allTimePoint.size(); ++i) {
            AbstractCardPoint cardPoint = allTimePoint.get(i);
            int pointType = cardPoint.getPointType();
            switch (pointType) {
                case 2: 
                case 3: {
                    return 0;
                }
                case 25: {
                    return 1;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 19: 
                case 21: 
                case 22: 
                case 41: {
                    return 2;
                }
            }
        }
        return 0;
    }

    protected List<String> getAttStatusListByTags(TieContextStd context, RawPara para, String punchCardTag, List<String> attendanceBillTagList) {
        ConfigMix configMix = ContextUtil.getConfigMix(context);
        AttStatusConfigData attStatusConfigData = ContextUtil.getAttStatusConfigData(context);
        return attStatusConfigData.getAttStatusListByTags(configMix.getAttstsmap(), WTCDateUtils.toLocalDate((Date)para.caculDate), punchCardTag, attendanceBillTagList);
    }

    protected Tuple<Integer, Integer> switchEffectCardStatus(int effectCardStatus, int attStatus, AbstractCardPoint cardPoint) {
        int effectCardStatusNew = effectCardStatus;
        int attStatusNew = attStatus;
        attStatusNew = this.getAttStatusNew(cardPoint, attStatusNew);
        effectCardStatusNew = this.getEffectCardStatusNew(cardPoint, effectCardStatusNew);
        return Tuple.create((Object)effectCardStatusNew, (Object)attStatusNew);
    }

    private int getEffectCardStatusNew(AbstractCardPoint cardPoint, int effectCardStatusNew) {
        switch (cardPoint.getPointType()) {
            case 2: 
            case 3: 
            case 22: {
                effectCardStatusNew = 0;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 19: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 48: {
                effectCardStatusNew = 1;
                break;
            }
            case 14: 
            case 15: {
                if (!cardPoint.getSource().getSourceCode().hasStatus(SourceCode.EFFECT_CARD)) break;
                if (cardPoint.getInCardTag() == 1) {
                    effectCardStatusNew = 1;
                    break;
                }
                if (cardPoint.getInCardTag() != 2) break;
                effectCardStatusNew = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                effectCardStatusNew = 2;
                break;
            }
            case 25: {
                if (effectCardStatusNew != 2) break;
                effectCardStatusNew = 0;
                break;
            }
        }
        return effectCardStatusNew;
    }

    private int getAttStatusNew(AbstractCardPoint cardPoint, int attStatusNew) {
        switch (cardPoint.getPointType()) {
            case 3: 
            case 11: {
                attStatusNew = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                attStatusNew = 1;
                break;
            }
            case 2: 
            case 38: 
            case 39: 
            case 40: {
                attStatusNew = 3;
                break;
            }
            case 25: 
            case 35: 
            case 36: 
            case 37: 
            case 48: {
                attStatusNew = 4;
                break;
            }
        }
        return attStatusNew;
    }

    protected Tuple<Integer, Integer> switchTimeSeqIndex(AbstractCardPoint cardPoint, int onDutyStatus, int timeSeqIndex) {
        int statusNew = onDutyStatus;
        int timeSeqIndexNew = timeSeqIndex;
        switch (cardPoint.getPointType()) {
            case 2: 
            case 3: 
            case 19: 
            case 21: 
            case 22: 
            case 25: {
                statusNew = 1;
                timeSeqIndexNew = onDutyStatus == 0 ? 0 : timeSeqIndex + 1;
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                statusNew = 2;
                break;
            }
            case 14: {
                statusNew = 3;
                break;
            }
            case 15: {
                statusNew = 1;
                break;
            }
        }
        return Tuple.create((Object)statusNew, (Object)timeSeqIndexNew);
    }

    protected int getTimeSeq(ShiftTimeBucketPropertyEnum shiftTimeBucketProperty, int onDutyStatus, int timeSeqIndex) {
        boolean bool;
        boolean bl = bool = ShiftTimeBucketPropertyEnum.BEFORE_SHIFT == shiftTimeBucketProperty || ShiftTimeBucketPropertyEnum.AFTER_SHIFT == shiftTimeBucketProperty;
        if (bool) {
            return 0;
        }
        int seq = 0;
        switch (onDutyStatus) {
            case 1: 
            case 2: {
                seq = TIME_SEQ_ATT[timeSeqIndex];
                break;
            }
            case 3: {
                seq = TIME_SEQ_REST[timeSeqIndex];
                break;
            }
        }
        return seq;
    }

    public List<AbstractCardPoint> getAllTimePoint(TieContextStd context, RawPara rawPara, List<PairTimeSplitWrapper> pairTimeSplitWrapperList) {
        ArrayList<AbstractCardPoint> cardPointList = new ArrayList<AbstractCardPoint>(10);
        this.addShiftAndDutyCardPoint(rawPara, pairTimeSplitWrapperList, cardPointList);
        this.addShiftAndNonDutyCardPoint(cardPointList, rawPara);
        this.addBillPoint(cardPointList, context, rawPara);
        List nonTimeCollect = cardPointList.stream().filter(cardPoint -> cardPoint.getTimePoint() == null).collect(Collectors.toList());
        List<AbstractCardPoint> timeCollect = cardPointList.stream().filter(cardPoint -> cardPoint.getTimePoint() != null).collect(Collectors.toList());
        timeCollect.sort(Comparator.comparing(AbstractCardPoint::getTimePoint));
        timeCollect.addAll(nonTimeCollect);
        return timeCollect;
    }

    private void checkShiftChanged(RawPara rawPara) {
        long shiftId = rawPara.getRoster().getShiftSpec().getId();
        List<LogicCard> logicCardDataList = rawPara.getLogicCardDataList();
        if (logicCardDataList.isEmpty()) {
            return;
        }
        LogicCard logicCard = logicCardDataList.get(0);
        Long shiftIdOnLogicCard = logicCard.getShiftId();
        if (shiftIdOnLogicCard == null || shiftIdOnLogicCard == 0L) {
            return;
        }
        if (shiftId != shiftIdOnLogicCard) {
            throw new WtesBizException(ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u5728{0}\u7684\u73ed\u6b21\u4fe1\u606f\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u53d6\u5361\u5339\u914d\uff0c\u518d\u8fdb\u884c\u8003\u52e4\u6838\u7b97\u3002", (String)"AbstractSplitTimeBucket_0", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.toLocalDate((Date)rawPara.caculDate)}));
        }
    }

    protected void addShiftAndDutyCardPoint(RawPara rawPara, List<PairTimeSplitWrapper> pairTimeSplitWrapperList, List<AbstractCardPoint> cardPointList) {
        this.checkShiftChanged(rawPara);
        for (int i = 0; i < pairTimeSplitWrapperList.size(); ++i) {
            PairTimeSplitWrapper pairTimeSplitWrapper = pairTimeSplitWrapperList.get(i);
            pairTimeSplitWrapper.setFirst(i == 0);
            pairTimeSplitWrapper.setLast(i == pairTimeSplitWrapperList.size() - 1);
            this.addCardPointCustom(pairTimeSplitWrapper, cardPointList, rawPara);
        }
    }

    protected abstract void addShiftAndNonDutyCardPoint(List<AbstractCardPoint> var1, RawPara var2);

    protected abstract void addCardPointCustom(PairTimeSplitWrapper var1, List<AbstractCardPoint> var2, RawPara var3);

    protected void addBillPoint(List<AbstractCardPoint> cardPointList, TieContextStd context, RawPara rawPara) {
        cardPointList.addAll(this.dealBill(context, rawPara));
    }

    protected List<AbstractCardPoint> dealBill(TieContextStd context, RawPara rawPara) {
        ShiftSpec shift = rawPara.roster.getShiftSpec();
        Date checkDay = rawPara.caculDate;
        List<AttBillTimeBucket> leaveBills = this.getLeaveBills(context.getAttPersonId(), checkDay, context);
        if (logger.isDebugEnabled()) {
            logger.debug("bills size={},day={}", (Object)leaveBills.size(), (Object)WTCDateUtils.toLocalDate((Date)checkDay));
            logger.debug("day={},billIds={}", (Object)WTCDateUtils.toLocalDate((Date)checkDay), (Object)leaveBills.stream().map(bill -> String.valueOf(bill.getId())).collect(Collectors.joining(",")));
        }
        leaveBills.sort((o1, o2) -> {
            if (o1.getStartTime() == null || o2.getStartTime() == null) {
                return 0;
            }
            return o1.getStartTime().compareTo(o2.getStartTime());
        });
        ArrayList<AbstractCardPoint> cardPointList = new ArrayList<AbstractCardPoint>(10);
        for (AttBillTimeBucket leaveBill : leaveBills) {
            this.doDealBill(shift, checkDay, cardPointList, leaveBill);
        }
        return cardPointList;
    }

    protected void doDealBill(ShiftSpec shift, Date checkDay, List<AbstractCardPoint> cardPointList, AttBillTimeBucket attBill) {
        if (attBill.isNonTime()) {
            this.dealNonTimeBill(cardPointList, attBill);
        } else {
            this.dealHaveTimeBill(shift, checkDay, cardPointList, attBill);
        }
    }

    protected void dealHaveTimeBill(ShiftSpec shift, Date checkDay, List<AbstractCardPoint> cardPointList, AttBillTimeBucket attBill) {
        AbstractCardPoint endPoint;
        AbstractCardPoint startPoint;
        Date endDateOfBill;
        Date startDateOfBill;
        BillTimeBucketType billType = attBill.getType();
        if (billType != null && billType == BillTimeBucketType.BILL_MIDDLE) {
            startDateOfBill = WTCDateUtils.toDate((LocalDateTime)shift.generateShiftStartTime(WTCDateUtils.toLocalDate((Date)checkDay)));
            endDateOfBill = WTCDateUtils.toDate((LocalDateTime)shift.generateShiftEndTime(WTCDateUtils.toLocalDate((Date)checkDay)));
        } else {
            startDateOfBill = WTCDateUtils.toDate((LocalDateTime)attBill.getStartTime());
            endDateOfBill = WTCDateUtils.toDate((LocalDateTime)attBill.getEndTime());
        }
        if ("BT".equals(attBill.getBillTypeBig())) {
            startPoint = new AbstractCardPoint(33, startDateOfBill, SourceCode.BILL);
            endPoint = new AbstractCardPoint(34, endDateOfBill, SourceCode.BILL);
        } else if ("VA".equals(attBill.getBillTypeBig())) {
            startPoint = new AbstractCardPoint(31, startDateOfBill, SourceCode.BILL);
            endPoint = new AbstractCardPoint(32, endDateOfBill, SourceCode.BILL);
        } else if ("OT".equals(attBill.getBillTypeBig())) {
            startPoint = new AbstractCardPoint(27, startDateOfBill, SourceCode.BILL);
            endPoint = new AbstractCardPoint(28, endDateOfBill, SourceCode.BILL);
        } else {
            return;
        }
        long billTypeId = attBill.getBillType();
        long billId = "OT".equals(attBill.getBillTypeBig()) ? attBill.getId() : attBill.getBillId();
        startPoint.setBillId(billId);
        startPoint.setBillType(billTypeId);
        startPoint.setBillEntryId(attBill.getId());
        endPoint.setBillId(billId);
        endPoint.setBillType(billTypeId);
        endPoint.setBillEntryId(attBill.getId());
        cardPointList.add(startPoint);
        cardPointList.add(endPoint);
    }

    protected List<AttBillTimeBucket> getLeaveBills(long attPersonId, Date checkDay, TieContextStd context) {
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        return attBillTimeBucketData.getBillTimeBuckets(attPersonId, WTCDateUtils.toLocalDate((Date)checkDay));
    }

    protected List<PairTimeSplitWrapper> getPairTimeSplitWrappers(RawPara para) {
        List<LogicCard> logicCardDataList = para.logicCardDataList;
        HashMap<Date, LogicCard> cardPointToDataMap = new HashMap<Date, LogicCard>(logicCardDataList.size() * 4 / 3 + 1);
        for (LogicCard logicCardData : logicCardDataList) {
            cardPointToDataMap.put(WTCDateUtils.toDate((LocalDateTime)logicCardData.getCardPointSupposed()), logicCardData);
        }
        List<ShiftInfoVo> shiftInfoVoList = this.getShiftInfoVoList(para);
        ArrayList<PairTimeSplitWrapper> pairTimeSplitWrapperList = new ArrayList<PairTimeSplitWrapper>();
        PairTimeSplitWrapper pairTimeSplitWrapper = null;
        boolean hasEffectCardOfShift = !logicCardDataList.isEmpty();
        int index = 1;
        for (ShiftInfoVo infoVo : shiftInfoVoList) {
            ShiftInfoVo shiftInfoVo = infoVo;
            if (!shiftInfoVo.getIsCardPoint()) continue;
            if (index % 2 == 0 && pairTimeSplitWrapper != null) {
                pairTimeSplitWrapper.setCardPointSupposedEnd(shiftInfoVo.getAbsoluteShiftDate());
                pairTimeSplitWrapper.setTimePointEnd(this.getEffectiveCardPoint((LogicCard)cardPointToDataMap.get(shiftInfoVo.getAbsoluteShiftDate())));
            } else {
                pairTimeSplitWrapper = new PairTimeSplitWrapper();
                pairTimeSplitWrapper.setHasEffectCardOfShift(hasEffectCardOfShift);
                pairTimeSplitWrapper.setCardPointSupposedStart(shiftInfoVo.getAbsoluteShiftDate());
                pairTimeSplitWrapper.setTimePointStart(this.getEffectiveCardPoint((LogicCard)cardPointToDataMap.get(shiftInfoVo.getAbsoluteShiftDate())));
                pairTimeSplitWrapperList.add(pairTimeSplitWrapper);
            }
            ++index;
        }
        return pairTimeSplitWrapperList;
    }

    protected List<ShiftInfoVo> getShiftInfoVoList(RawPara para) {
        ShiftSpec shift = para.roster.getShiftSpec();
        Date checkDay = para.caculDate;
        ArrayList<ShiftInfoVo> shiftInfoVoList = new ArrayList<ShiftInfoVo>(10);
        List<ShiftSession> shiftSessions = shift.getShiftSessions();
        for (ShiftSession shiftSession : shiftSessions) {
            ShiftInfoVo shiftInfoVo1 = new ShiftInfoVo();
            shiftInfoVo1.setAbsoluteShiftDate(WTCDateUtils.toDate((LocalDateTime)shiftSession.getAbsoluteShiftStartDate(WTCDateUtils.toLocalDate((Date)checkDay))));
            shiftInfoVo1.setIsCardPoint(shiftSession.isRequiredPunchIn());
            shiftInfoVo1.setOutWorkType(shiftSession.getOutWorkType().code);
            shiftInfoVoList.add(shiftInfoVo1);
            ShiftInfoVo shiftInfoVo2 = new ShiftInfoVo();
            shiftInfoVo2.setAbsoluteShiftDate(WTCDateUtils.toDate((LocalDateTime)shiftSession.getAbsoluteShiftEndDate(WTCDateUtils.toLocalDate((Date)checkDay))));
            shiftInfoVo2.setIsCardPoint(shiftSession.isRequiredPunchOut());
            shiftInfoVo2.setOutWorkType(shiftSession.getOutWorkType().code);
            shiftInfoVoList.add(shiftInfoVo2);
        }
        return shiftInfoVoList;
    }

    private Date getEffectiveCardPoint(LogicCard logicCardData) {
        if (null == logicCardData) {
            return null;
        }
        return WTCDateUtils.toDate((LocalDateTime)logicCardData.getEffectiveCardPoint());
    }

    protected List<AbstractCardPoint> dealAbsent(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        return this.getCardPointListOfAbsent(pairTimeSplitWrapper, rawPara);
    }

    protected List<AbstractCardPoint> getCardPointListOfAbsent(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        throw new UnsupportedOperationException();
    }

    protected List<AbstractCardPoint> dealNormal(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        return this.getCardPointList(pairTimeSplitWrapper, rawPara);
    }

    protected List<AbstractCardPoint> getCardPointList(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        throw new UnsupportedOperationException();
    }

    protected int getSupposedPointType(Date cardPointSupposed, Date timePoint, int tag) {
        if (1 == tag) {
            if (cardPointSupposed.getTime() == timePoint.getTime()) {
                return 19;
            }
            if (cardPointSupposed.before(timePoint)) {
                return 22;
            }
            if (cardPointSupposed.after(timePoint)) {
                return 21;
            }
        } else if (2 == tag) {
            if (cardPointSupposed.getTime() == timePoint.getTime()) {
                return 20;
            }
            if (cardPointSupposed.before(timePoint)) {
                return 24;
            }
            if (cardPointSupposed.after(timePoint)) {
                return 23;
            }
        }
        logger.warn("wrongzw sence,cardPointSupposed->{},timePoint->{},tag->{}", new Object[]{cardPointSupposed, timePoint, tag});
        return -1;
    }

    protected int getPointType(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper, int tag) {
        if (timePoint.before(pairTimeSplitWrapper.getCardPointSupposedStart())) {
            if (pairTimeSplitWrapper.isFirst()) {
                return 1;
            }
            return 13;
        }
        if (timePoint.getTime() == pairTimeSplitWrapper.getCardPointSupposedStart().getTime()) {
            return 41;
        }
        if (!pairTimeSplitWrapper.hasRestTime() && timePoint.after(pairTimeSplitWrapper.getCardPointSupposedStart()) && timePoint.before(pairTimeSplitWrapper.getCardPointSupposedEnd())) {
            if (tag == 1) {
                return 4;
            }
            if (tag == 2) {
                return 7;
            }
        } else if (this.timePointBetweenStartSupposedAndRestTimeFlag(timePoint, pairTimeSplitWrapper)) {
            if (tag == 1) {
                return 5;
            }
            if (tag == 2) {
                return 8;
            }
        } else {
            if (this.timePointInRestStart(timePoint, pairTimeSplitWrapper)) {
                return 14;
            }
            if (this.timePointBetweenRestTimeFlag(timePoint, pairTimeSplitWrapper)) {
                if (tag == 1) {
                    return 13;
                }
                if (tag == 2) {
                    return 12;
                }
            } else if (this.timePointBetweenOffDutyRestTimeFlag(timePoint, pairTimeSplitWrapper)) {
                if (tag == 1) {
                    return 13;
                }
                if (tag == 2) {
                    return 12;
                }
            } else {
                if (this.timePointInRestEnd(timePoint, pairTimeSplitWrapper)) {
                    return 15;
                }
                if (this.timePointAfterRestEndAndBeforeSupposedEnd(timePoint, pairTimeSplitWrapper)) {
                    if (tag == 1) {
                        return 6;
                    }
                    if (tag == 2) {
                        return 9;
                    }
                } else {
                    if (timePoint.getTime() == pairTimeSplitWrapper.getCardPointSupposedEnd().getTime()) {
                        return 42;
                    }
                    if (timePoint.after(pairTimeSplitWrapper.getCardPointSupposedEnd())) {
                        if (pairTimeSplitWrapper.isLast()) {
                            return 16;
                        }
                        return 12;
                    }
                }
            }
        }
        logger.warn("\u6f0f\u6389\u4e86\u573a\u666f,timePoint->{}", (Object)timePoint);
        throw new RuntimeException("wrong scene");
    }

    private boolean timePointAfterRestEndAndBeforeSupposedEnd(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return pairTimeSplitWrapper.getRestTimeEnd() != null && timePoint.after(pairTimeSplitWrapper.getRestTimeEnd()) && timePoint.before(pairTimeSplitWrapper.getCardPointSupposedEnd());
    }

    private boolean timePointInRestStart(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return pairTimeSplitWrapper.getRestTimeStart() != null && timePoint.getTime() == pairTimeSplitWrapper.getRestTimeStart().getTime();
    }

    private boolean timePointInRestEnd(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return pairTimeSplitWrapper.getRestTimeEnd() != null && timePoint.getTime() == pairTimeSplitWrapper.getRestTimeEnd().getTime();
    }

    private boolean timePointBetweenStartSupposedAndRestTimeFlag(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return timePoint.after(pairTimeSplitWrapper.getCardPointSupposedStart()) && pairTimeSplitWrapper.getRestTimeStart() != null && timePoint.before(pairTimeSplitWrapper.getRestTimeStart());
    }

    private boolean timePointBetweenOffDutyRestTimeFlag(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return pairTimeSplitWrapper.getOffDutyRestTimeStart() != null && timePoint.after(pairTimeSplitWrapper.getOffDutyRestTimeStart()) && pairTimeSplitWrapper.getOffDutyRestTimeEnd() != null && timePoint.before(pairTimeSplitWrapper.getOffDutyRestTimeEnd());
    }

    private boolean timePointBetweenRestTimeFlag(Date timePoint, PairTimeSplitWrapper pairTimeSplitWrapper) {
        return pairTimeSplitWrapper.getRestTimeStart() != null && timePoint.after(pairTimeSplitWrapper.getRestTimeStart()) && pairTimeSplitWrapper.getRestTimeEnd() != null && timePoint.before(pairTimeSplitWrapper.getRestTimeEnd());
    }

    public int getSupposedPointTypeOfAbsent(Date timePointStart, Date timePointEnd, int tag) {
        if (null == timePointStart) {
            if (null == timePointEnd) {
                return tag == 1 ? 3 : 11;
            }
            return tag == 1 ? 2 : 26;
        }
        if (null == timePointEnd) {
            return tag == 1 ? 25 : 10;
        }
        logger.warn("wrong sence,timePointStart->{},timePointEnd->{},tag->{}", new Object[]{timePointStart, timePointEnd, tag});
        return -1;
    }

    public int getPointTypeOfAbsent(Date timePoint, Date cardPointSupposed, int tag) {
        if (tag == 1) {
            if (timePoint.getTime() < cardPointSupposed.getTime()) {
                return 35;
            }
            if (timePoint.getTime() > cardPointSupposed.getTime()) {
                return 36;
            }
            return 37;
        }
        if (timePoint.getTime() < cardPointSupposed.getTime()) {
            return 40;
        }
        if (timePoint.getTime() > cardPointSupposed.getTime()) {
            return 39;
        }
        return 38;
    }

    private void setOtherAttr(TimeBucket.Builder rawTimeBucketBiulder, RawPara para) {
        rawTimeBucketBiulder.roster(para.roster);
        rawTimeBucketBiulder.attMode(para.attMode);
    }

    public List<TimeBucket> calculateForBillTrial(TieContextStd context, RawPara para) {
        ArrayList timeBucketBuilderList = new ArrayList(16);
        List<AbstractCardPoint> allTimePoint = this.getAllTimePoint(context, para, this.getPairTimeSplitWrappers(para));
        if (allTimePoint.isEmpty()) {
            return Collections.emptyList();
        }
        AbstractCardPoint previousPoint = null;
        ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum = ShiftTimeBucketPropertyEnum.BEFORE_SHIFT;
        for (AbstractCardPoint cardPoint : allTimePoint) {
            if (previousPoint == null || previousPoint.getTimePoint().equals(cardPoint.getTimePoint())) {
                shiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum.switchShiftTimeBucketPropertyStatus(cardPoint, para.roster.getShiftSpec().getOffNonPlan());
                previousPoint = cardPoint;
                continue;
            }
            Object rawTimeBucketBuilder = ((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)TimeBucket.builder().startTime(WTCDateUtils.toLocalDateTime((Date)previousPoint.getTimePoint()))).endTime(WTCDateUtils.toLocalDateTime((Date)cardPoint.getTimePoint()))).shiftTimeBucketProperty(shiftTimeBucketPropertyEnum)).timeBucketPosition(shiftTimeBucketPropertyEnum.genTimeBucketPosition());
            shiftTimeBucketPropertyEnum = shiftTimeBucketPropertyEnum.switchShiftTimeBucketPropertyStatus(cardPoint, para.roster.getShiftSpec().getOffNonPlan());
            previousPoint = cardPoint;
            timeBucketBuilderList.add(rawTimeBucketBuilder);
        }
        return timeBucketBuilderList.stream().map(CleanableBuilder::build).map(TimeBucket.class::cast).collect(Collectors.toList());
    }
}

