/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawTimeBucketService;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;

public class RawTimeUtils {
    private static final Log logger = LogFactory.getLog(RawTimeUtils.class);
    private static final RawTimeBucketService RAW_TIME_BUCKET_CALCULATOR = new RawTimeBucketService();
    private static final int DUTY_DATE_RADIUS = 1;
    private static final int SHIFT_DATES = 3;
    private static final String CONTEXT_SHIFT_TIME_BUCKETS = "contextShiftTimeBuckets";

    public static List<TimeBucket> rawTimeCal(TieContextStd context) {
        List<TimeBucket> timeBucketList = RawTimeUtils.isBeginDate(context) ? RawTimeUtils.calculateRawTimeBucketMulti(context) : RawTimeUtils.calculateNextRawTimeBucket(context);
        return timeBucketList;
    }

    private static List<TimeBucket> calculateNextRawTimeBucket(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        LocalDate shiftDate = chainDate.plusDays(1L);
        List<TimeBucket> timeBucketList = RAW_TIME_BUCKET_CALCULATOR.calculate(context, shiftDate);
        RawTimeUtils.printOut(timeBucketList);
        Deque<List<TimeBucket>> contextShiftTimeBuckets = RawTimeUtils.getContextShiftTimeBuckets(context);
        contextShiftTimeBuckets.removeFirst();
        contextShiftTimeBuckets.addLast(timeBucketList);
        ArrayList<TimeBucket> allTimeBuckets = new ArrayList<TimeBucket>(16);
        contextShiftTimeBuckets.forEach(allTimeBuckets::addAll);
        return allTimeBuckets;
    }

    private static List<TimeBucket> calculateRawTimeBucketMulti(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        LocalDate shiftDate = chainDate.plusDays(-1L);
        Deque<List<TimeBucket>> contextShiftTimeBuckets = RawTimeUtils.getContextShiftTimeBuckets(context);
        contextShiftTimeBuckets.clear();
        for (int i = 0; i < 3; ++i) {
            List<TimeBucket> timeBucketList = RAW_TIME_BUCKET_CALCULATOR.calculate(context, shiftDate);
            contextShiftTimeBuckets.addLast(timeBucketList);
            RawTimeUtils.printOut(timeBucketList);
            shiftDate = shiftDate.plusDays(1L);
        }
        ArrayList<TimeBucket> allTimeBuckets = new ArrayList<TimeBucket>(16);
        contextShiftTimeBuckets.forEach(allTimeBuckets::addAll);
        return allTimeBuckets;
    }

    private static Deque<List<TimeBucket>> getContextShiftTimeBuckets(TieContextStd context) {
        LinkedList contextShiftTimeBuckets = (LinkedList)context.getVariable(CONTEXT_SHIFT_TIME_BUCKETS, VScope.LINE);
        if (contextShiftTimeBuckets == null) {
            contextShiftTimeBuckets = new LinkedList();
            context.setVariable(CONTEXT_SHIFT_TIME_BUCKETS, contextShiftTimeBuckets, VScope.LINE);
        }
        return contextShiftTimeBuckets;
    }

    public static boolean isBeginDate(TieContextStd context) {
        AttSubject.AttSubjectEntry attSubjectEntry = context.getAttSubjectEntry();
        AttSubject.AttSubjectEntry preEntry = attSubjectEntry.getPreEntry();
        return preEntry == null || !attSubjectEntry.getCurrentDate().plusDays(-1L).equals(preEntry.getCurrentDate());
    }

    public static boolean isEndDate(TieContextStd context) {
        AttSubject.AttSubjectEntry attSubjectEntry = context.getAttSubjectEntry();
        AttSubject.AttSubjectEntry nextEntry = attSubjectEntry.getNextEntry();
        return nextEntry == null || !attSubjectEntry.getCurrentDate().plusDays(1L).equals(nextEntry.getCurrentDate());
    }

    private static void printOut(List<TimeBucket> timeBucketList) {
        logger.debug("----------------start----------------");
        timeBucketList.forEach(timeBucket -> logger.debug("{} ---> {} | \u65f6\u70b9\u6765\u6e90(s):{} | \u65f6\u70b9\u6765\u6e90(e):{} | \u65f6\u6bb5\u5c5e\u6027:{} | \u65f6\u6bb5\u4f4d\u7f6e:{} | \u65f6\u6bb5\u5361\u70b9(\u4f4d\u7f6e)\u5173\u7cfb:{} | \u5355\u636e\u72b6\u6001:{} | \u65f6\u6bb5\u5e8f\u53f7id:{} | \u65f6\u957f:{}\u79d2 | \u6253\u5361\u5f02\u5e38\u72b6\u6001:{}", new Object[]{timeBucket.getStartTime(), timeBucket.getEndTime(), timeBucket.getStartTimePointSource().getName(), timeBucket.getEndTimePointSource().getName(), timeBucket.getShiftTimeBucketProperty().name, timeBucket.getTimeBucketPosition().name, timeBucket.getTimeBucketPunchCardRelation().name, timeBucket.getAttendanceBillTag().getStatus(), timeBucket.getShiftTimeBucketSeqId(), timeBucket.getDurationOfSecond(), timeBucket.getCardExceptionType().name}));
        logger.debug("-----------------end-----------------");
    }

    public static String getBillTypeName(String billTypeBig) {
        String name = "OT".equals(billTypeBig) ? ResManager.loadKDString((String)"\u52a0\u73ed\u5355", (String)"RawTimeUtils_0", (String)"wtc-wtes-business", (Object[])new Object[0]) : ("VA".equals(billTypeBig) ? ResManager.loadKDString((String)"\u4f11\u5047\u5355", (String)"RawTimeUtils_1", (String)"wtc-wtes-business", (Object[])new Object[0]) : ("BT".equals(billTypeBig) ? ResManager.loadKDString((String)"{0}\u5355", (String)"RawTimeUtils_2", (String)"wtc-wtes-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}) : "nonType"));
        return name;
    }
}

