/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlva;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.rlva.DeductionRulePackage;
import kd.wtc.wtes.business.model.rlva.VaBaseSetPackage;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.model.rlva.VaRulePackage;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VaCalHelper {
    private static final Log LOG = LogFactory.getLog(VaCalHelper.class);

    @Deprecated
    public static List<VaAttPackage> getPlanHisList(List<DynamicObject> ofCurrPlanHisList, Map<Long, List<DynamicObject>> ruleHisListMap) {
        return VaCalHelper.getPlanHisList(ofCurrPlanHisList, ruleHisListMap, Maps.newHashMap());
    }

    @Deprecated
    public static List<VaAttPackage> getPlanHisList(List<DynamicObject> ofCurrPlanHisList, Map<Long, List<DynamicObject>> ruleHisListMap, Map<Long, String> ruleSetMap) {
        return VaCalHelper.getPlanHisList(ofCurrPlanHisList, ruleHisListMap, ruleSetMap, Maps.newHashMapWithExpectedSize((int)16));
    }

    public static List<VaAttPackage> getPlanHisList(List<DynamicObject> ofCurrPlanHisList, Map<Long, List<DynamicObject>> ruleHisListMap, Map<Long, String> ruleSetMap, Map<String, Map<Long, List<DynamicObject>>> f7Maps) {
        ArrayList planHisList = Lists.newArrayListWithExpectedSize((int)ofCurrPlanHisList.size());
        for (DynamicObject planHis : ofCurrPlanHisList) {
            VaAttPackage vaAttPackage = new VaAttPackage(VaCalHelper.getTimeSeqEntity(planHis));
            String ruleWay = ruleSetMap.get(planHis.getLong("id"));
            vaAttPackage.setRuleWay(ruleWay);
            if (!HRStringUtils.equalsIgnoreCase((String)"2", (String)ruleWay) && planHis.get("varule") != null) {
                DynamicObject vaRule = planHis.getDynamicObject("varule");
                TimeSeqAvailableBo<VaRulePackage> ruleBo = VaCalHelper.dealOneRule(ruleHisListMap, vaRule.getLong("id"), f7Maps);
                vaAttPackage.setVaRule((TimeSeqBo<VaRulePackage>)ruleBo);
            }
            planHisList.add(vaAttPackage);
        }
        return planHisList;
    }

    @Deprecated
    public static TimeSeqAvailableBo<VaRulePackage> dealOneRule(Map<Long, List<DynamicObject>> ruleHisListMap, long ruleId) {
        return VaCalHelper.dealOneRule(ruleHisListMap, ruleId, Maps.newHashMapWithExpectedSize((int)16));
    }

    public static TimeSeqAvailableBo<VaRulePackage> dealOneRule(Map<Long, List<DynamicObject>> ruleHisListMap, long ruleId, Map<String, Map<Long, List<DynamicObject>>> f7Maps) {
        List vaRuleHisList = ruleHisListMap.getOrDefault(ruleId, new ArrayList());
        ArrayList<VaRulePackage> rulePackageList = new ArrayList<VaRulePackage>(10);
        for (DynamicObject vaRuleHis : vaRuleHisList) {
            TimeSeqInfoImpl timeSeqEntity = VaCalHelper.getTimeSeqEntity(vaRuleHis);
            long id = vaRuleHis.getLong("id");
            String number = vaRuleHis.getString("number");
            rulePackageList.add(new VaRulePackage(id, number).setTimeSeqEntity(timeSeqEntity).setVaCalculateRules(VaCalHelper.buildVaRule(vaRuleHis, f7Maps)));
        }
        return new TimeSeqAvailableBo(rulePackageList);
    }

    private static List<VaCalculateRule> buildVaRule(DynamicObject vaRuleHis, Map<String, Map<Long, List<DynamicObject>>> f7Maps) {
        DynamicObjectCollection calculateRules = vaRuleHis.getDynamicObjectCollection("entryentity");
        return calculateRules.stream().map(calculateRule -> VaCalHelper.createCalCulRule(vaRuleHis, calculateRule, f7Maps)).collect(Collectors.toList());
    }

    private static VaCalculateRule createCalCulRule(DynamicObject vaRuleHis, DynamicObject dy, Map<String, Map<Long, List<DynamicObject>>> f7Maps) {
        Map<Long, List<DynamicObject>> vaBaseSetMap = f7Maps.get("vabasesetid");
        Map<Long, List<DynamicObject>> deductionRuleMap = f7Maps.get("deductrule");
        String condition = dy.getString("daterangecondition");
        AccessDto accessDto = VaCalHelper.getAccessDto(condition);
        long deductionRuleId = dy.getLong("deductrule.id");
        VaCalculateRule vaCalculateRule = new VaCalculateRule().setId((Long)vaRuleHis.getPkValue()).setNumber(vaRuleHis.getString("number")).setOriginId(VaCalHelper.getValueIFNonNull(dy.getDynamicObject("vaitem"))).setVaTypeId(VaCalHelper.getValueIFNonNull(dy.getDynamicObject("vatype"))).setLimitJson(dy.getString("limitscope")).setDateRangeId(dy.getLong("basedataid")).setDateConditionAccessDto(accessDto).setResultId(VaCalHelper.getValueIFNonNull(dy.getDynamicObject("resultitem"))).setRoundAttId(VaCalHelper.getValueIFNonNull(dy.getDynamicObject("roundruleitem"))).setRoundRuleId(VaCalHelper.getValueIFNonNull(dy.getDynamicObject("roundrule"))).setDeductionRuleId(deductionRuleId).setQuota(dy.getBoolean("isquota")).setTimeByDayItemId(dy.getLong("timebydayitem.id")).setTimeByShiftItemId(dy.getLong("timebyshiftitem.id"));
        long vaBaseSetId = dy.getLong("vabasesetid.id");
        if (MapUtils.isNotEmpty(vaBaseSetMap)) {
            List vaBaseSetHisList = vaBaseSetMap.getOrDefault(vaBaseSetId, new ArrayList());
            vaCalculateRule.setVaBaseSetPackageTimeSeqBo((TimeSeqBo<VaBaseSetPackage>)VaCalHelper.dealOneBaseSet(vaBaseSetHisList));
        }
        if (MapUtils.isNotEmpty(deductionRuleMap)) {
            List deductionRuleHisList = deductionRuleMap.getOrDefault(deductionRuleId, new ArrayList());
            vaCalculateRule.setVaDeductionRulePackageTimeSeqBo((TimeSeqBo<DeductionRulePackage>)VaCalHelper.dealOneDeductionRule(deductionRuleHisList));
        }
        return vaCalculateRule;
    }

    private static TimeSeqAvailableBo<VaBaseSetPackage> dealOneBaseSet(List<DynamicObject> vaBaseSetHisList) {
        ArrayList<VaBaseSetPackage> vaBaseSetPackageList = new ArrayList<VaBaseSetPackage>(10);
        for (DynamicObject vaBaseSetHis : vaBaseSetHisList) {
            TimeSeqInfoImpl timeSeqEntity = VaCalHelper.getTimeSeqEntity(vaBaseSetHis);
            long id = vaBaseSetHis.getLong("id");
            String number = vaBaseSetHis.getString("number");
            VaBaseSetPackage vaBaseSetPackage = new VaBaseSetPackage(id, number);
            vaBaseSetPackage.setTimeSeqInfo(timeSeqEntity);
            vaBaseSetPackage.setHalfDayType(vaBaseSetHis.getString("halfdaytype"));
            vaBaseSetPackage.setTimeCalcType(vaBaseSetHis.getString("timecalctype"));
            vaBaseSetPackage.setContainOverTime(vaBaseSetHis.getBoolean("iscontainovertime"));
            vaBaseSetPackageList.add(vaBaseSetPackage);
        }
        return new TimeSeqAvailableBo(vaBaseSetPackageList);
    }

    private static TimeSeqAvailableBo<DeductionRulePackage> dealOneDeductionRule(List<DynamicObject> deductionRuleHisList) {
        ArrayList<DeductionRulePackage> vaBaseSetPackageList = new ArrayList<DeductionRulePackage>(10);
        for (DynamicObject deductionRuleHis : deductionRuleHisList) {
            TimeSeqInfoImpl timeSeqEntity = VaCalHelper.getTimeSeqEntity(deductionRuleHis);
            long id = deductionRuleHis.getLong("id");
            String number = deductionRuleHis.getString("number");
            DeductionRulePackage deductionRulePackage = new DeductionRulePackage(id, number);
            deductionRulePackage.setTimeSeqInfo(timeSeqEntity);
            vaBaseSetPackageList.add(deductionRulePackage);
        }
        return new TimeSeqAvailableBo(vaBaseSetPackageList);
    }

    private static long getValueIFNonNull(DynamicObject target) {
        return target == null ? 0L : (Long)target.getPkValue();
    }

    private static AccessDto getAccessDto(String condition) {
        AccessDto dateConditionAccessDto = null;
        if (HRStringUtils.isNotEmpty((String)condition)) {
            try {
                dateConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return dateConditionAccessDto;
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject entity) {
        LocalDate bsed = VaCalHelper.getLocalDate(entity.getDate("bsed"));
        LocalDate bsled = VaCalHelper.getLocalDate(entity.getDate("bsled"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).number(entity.getString("number"))).id(entity.getLong("id"))).bid(entity.getLong("boid")).build();
    }

    private static LocalDate getLocalDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
    }

    public static DynamicObject[] getHisDyArr(String number, Set<Long> planIdSet, LocalDate startDate, LocalDate endDate) {
        Set newSet = planIdSet.stream().filter(key -> key != 0L).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(newSet)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(number);
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(planIdSet, startDate, endDate);
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static boolean checkEmpty(TieContextStd context) {
        return context.getRawTimeBuckets().isEmpty();
    }

    public static Set<Long> getBaseSetIdList(DynamicObject[] vaRuleHisList) {
        HashSet baseSetIdList = Sets.newHashSetWithExpectedSize((int)16);
        if (ArrayUtils.isNotEmpty((Object[])vaRuleHisList)) {
            for (DynamicObject vaPlanHis : vaRuleHisList) {
                DynamicObjectCollection vaRuleEntity = vaPlanHis.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isNotEmpty((Collection)vaRuleEntity)) continue;
                baseSetIdList.addAll(vaRuleEntity.stream().map(entryEntity -> entryEntity.getLong("vabasesetid.id")).collect(Collectors.toSet()));
            }
        }
        return baseSetIdList;
    }

    public static Map<String, Set<Long>> getF7IdMaps(DynamicObject[] vaRuleHisList) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet deductionRuleSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet baseSetIdList = Sets.newHashSetWithExpectedSize((int)16);
        resultMap.put("deductrule", deductionRuleSet);
        resultMap.put("vabasesetid", baseSetIdList);
        if (ArrayUtils.isEmpty((Object[])vaRuleHisList)) {
            return resultMap;
        }
        for (DynamicObject vaRuleHis : vaRuleHisList) {
            DynamicObjectCollection vaRuleEntities = vaRuleHis.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)vaRuleEntities)) continue;
            for (DynamicObject vaRuleEntity : vaRuleEntities) {
                baseSetIdList.add(vaRuleEntity.getLong("vabasesetid.id"));
                if (!vaRuleEntity.getBoolean("isquota")) continue;
                deductionRuleSet.add(vaRuleEntity.getLong("deductrule.id"));
            }
        }
        return resultMap;
    }
}

