/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlva;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.RoundRuleService;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VaRoundEvaluator
implements TieEvaluatorStd {
    private static final Log log = LogFactory.getLog(VaRoundEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        log.debug("\u8fdb\u5165\u4f11\u5047\u820d\u5165\u89c4\u5219\u8ba1\u7b97\u903b\u8f91{}", (Object)context.getRawTimeBuckets().size());
        if (VaCalHelper.checkEmpty(context)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaRoundEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaRoundEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        ShiftSpec shiftSpec = ContextUtil.getShiftSpec(context);
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        VaAttPackage attVaPackage = attFileModel.getAttVaPackage(chainDate);
        Map<Long, RoundWrapper> roundWrapperMap = ContextUtil.getRoundWrapperMap(context);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        if (attVaPackage != null) {
            if (log.isDebugEnabled()) {
                log.debug("\u4f11\u5047\u820d\u5165\u89c4\u5219\u8ba1\u7b97\u903b\u8f91,\u5165\u53c2\u65f6\u95f4\u5bf9{},\u6838\u7b97\u4eba{},\u6838\u7b97\u65f6\u95f4{}", new Object[]{dataNodes.toString(), attPersonId, chainDate});
            }
            List<TieDataNode> timeBuckets = this.dealRound(chainDate, dataNodes, roundWrapperMap, attItemSpecData, shiftSpec);
            if (log.isDebugEnabled()) {
                log.debug("\u4f11\u5047\u820d\u5165\u89c4\u5219\u8ba1\u7b97\u903b\u8f91\u7ed3\u675f\uff0c\u8fd4\u56de\u65f6\u95f4\u5bf9{},\u6838\u7b97\u4eba{},\u6838\u7b97\u65f6\u95f4{}", new Object[]{timeBuckets.toString(), attPersonId, chainDate});
            }
            return TieDataResultStd.success(timeBuckets);
        }
        return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaRoundEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
    }

    public List<TieDataNode> dealRound(LocalDate chainDate, List<TieDataNodeStd> rawTimeBucket, Map<Long, RoundWrapper> roundWrapperMap, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        Map<VaCalculateRule, List<TieDataNodeStd>> ruleTimeBucket = rawTimeBucket.stream().collect(Collectors.groupingBy(std -> std.getMatchedRule(VaCalculateRule.class)));
        if (log.isDebugEnabled()) {
            log.debug("\u820d\u5165\u89c4\u5219\u5904\u7406\u5f00\u59cb,\u820d\u5165\u89c4\u5219\u5206\u7ec4\u7684\u65f6\u95f4\u5bf9={}", (Object)ruleTimeBucket.size());
        }
        if (CollectionUtils.isEmpty(ruleTimeBucket)) {
            return result;
        }
        for (Map.Entry<VaCalculateRule, List<TieDataNodeStd>> entry : ruleTimeBucket.entrySet()) {
            VaCalculateRule vaCalculateRule = entry.getKey();
            List<TieDataNodeStd> byBillId = entry.getValue();
            BigDecimal sumSeconds = BigDecimal.ZERO;
            for (TieDataNodeStd timeBucketStd : byBillId) {
                List<AttItemInstance> attItemInstances = timeBucketStd.getAttItemInstances();
                sumSeconds = sumSeconds.add(attItemInstances.stream().map(AttItemInstance::getSecondDecimal).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            if (vaCalculateRule == null) continue;
            RoundWrapper roundWrapper = roundWrapperMap.get(vaCalculateRule.getRoundRuleId());
            if (roundWrapper != null) {
                AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(vaCalculateRule.getRoundAttId(), chainDate);
                BigDecimal roundSeconds = RoundRuleService.roundValue(roundWrapper, sumSeconds, attItemSpec, shiftSpec);
                BigDecimal roundDays = shiftSpec.secondsToDays(roundSeconds);
                AttItemInstance newItemInstance = new AttItemInstance(attItemSpec, roundSeconds, roundDays, roundSeconds, null);
                EvaluationRuleModel evaluationRule = EvaluationRuleModel.of(vaCalculateRule.getRoundRuleId(), "wtbd_roundrule");
                AttItemValue attItemValue = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(new ArrayList<TieDataNodeStd>((Collection)entry.getValue()))).attItemInstance(newItemInstance)).matchedRule(entry.getKey())).evaluationRule(evaluationRule)).build();
                result.add(attItemValue);
                BigDecimal roundedValueSeconds = sumSeconds.subtract(roundSeconds);
                BigDecimal roundedValueDays = shiftSpec.secondsToDays(roundedValueSeconds);
                if (roundedValueSeconds.compareTo(BigDecimal.ZERO) == 0) continue;
                AttItemSpec roundedAttItemSpec = attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.VA_ROUNDED_DIFF.getBid(), chainDate);
                AttItemInstance roundedItemInstance = new AttItemInstance(roundedAttItemSpec, roundedValueSeconds, roundedValueDays, roundedValueSeconds, null);
                AttItemValue roundedCopy = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(new ArrayList<TieDataNodeStd>((Collection)entry.getValue()))).attItemInstance(roundedItemInstance)).matchedRule(entry.getKey())).evaluationRule(evaluationRule)).build();
                result.add(roundedCopy);
                continue;
            }
            for (TieDataNodeStd timeBucketStd : byBillId) {
                List<AttItemInstance> attItemInstances = timeBucketStd.getAttItemInstances();
                for (AttItemInstance attItemInstance : attItemInstances) {
                    AttItemSpec attItemSpec = attItemInstance.getAttItemSpec();
                    AttItemInstance newItemInstance = new AttItemInstance(attItemSpec, attItemInstance.getSecondDecimal(), attItemInstance.getDay(), attItemInstance.getSecondDecimal(), null);
                    EvaluationRuleModel evaluationRule = EvaluationRuleModel.of(entry.getKey().getId(), "wtp_varule");
                    AttItemValue roundedCopy = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(new ArrayList<TieDataNodeStd>((Collection)entry.getValue()))).attItemInstance(newItemInstance)).matchedRule(entry.getKey())).evaluationRule(evaluationRule)).build();
                    result.add(roundedCopy);
                }
            }
        }
        log.debug("\u820d\u5165\u89c4\u5219\u5904\u7406\u7ed3\u675f....");
        return result;
    }
}

