/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.rlra.util.AttendItemUtils;
import kd.wtc.wtes.business.executor.rlra.util.RawTimeUtils;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.executor.timeaffiliation.util.TimeAffiliationUtils;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ContextUtil;

public class TimeAffiliationMergeEvaluator
implements TieEvaluatorStd {
    private static final Log LOGGER = LogFactory.getLog(TimeAffiliationMergeEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, null);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        long startime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{},\u6838\u7b97\u65e5\u671f{}\u7684\u5f00\u59cb\u65e5\u671f\u5f52\u5c5e\u73af\u8282\uff0c\u5f00\u59cb\u70b9{}\u3002", (String)"TimeAffiliationMergeEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{context.getVersion(), chainDate, startime});
        }
        List<TimeBucket> timeBucketList = RawTimeUtils.rawTimeCal(context);
        try (Span initSpan = TaskTracer.newSpan((String)"TimeAffiliationEvaluator");){
            ArrayList<TimeBucket> timeBuckets = new ArrayList<TimeBucket>(timeBucketList);
            initSpan.debug(CalcReportConstants.INIT_RESULT, () -> JSON.toJSONString((Object)timeBuckets));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{},\u6838\u7b97\u65e5\u671f{}\u7684\u65f6\u95f4\u5bf9\u62c6\u5206\u540e\u6709{},\u8017\u65f6\uff1a{}\u3002", (String)"TimeAffiliationMergeEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{context.getVersion(), chainDate, timeBucketList, System.currentTimeMillis() - startime});
        }
        startime = System.currentTimeMillis();
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(context);
        TimeSeqBo<TimeAscriptionRule> timeAscriptionRuleBo = attPeriodTable.getAscriptionBoByAttPersonIdAndDate(attPersonId, chainDate);
        TimeAscriptionRule ascriptionRule = (TimeAscriptionRule)timeAscriptionRuleBo.getVersionByDate(chainDate);
        if (ascriptionRule == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no TimeAscriptionRule exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        timeBucketList = TimeAffiliationUtils.timeAffiliationCal(context, timeBucketList, timeAscriptionRuleBo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{},\u6838\u7b97\u65e5\u671f{}\u7684\u65e5\u671f\u5f52\u5c5e\u5904\u7406\u540e\u6709{}\u4e2a,\u8017\u65f6\uff1a{}\u3002", (String)"TimeAffiliationMergeEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{context.getVersion(), chainDate, timeBucketList.size(), System.currentTimeMillis() - startime});
        }
        startime = System.currentTimeMillis();
        timeBucketList = AttendItemUtils.attendItemCal(context, timeBucketList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{},\u6838\u7b97\u65e5\u671f{}\u7684\u9879\u76ee\u6620\u5c04\u5904\u7406\u540e\u6709{}\u4e2a,\u8017\u65f6\uff1a{}\u3002", (String)"TimeAffiliationMergeEvaluator_6", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{context.getVersion(), chainDate, timeBucketList.size(), System.currentTimeMillis() - startime});
        }
        return TieDataResultStd.success(timeBucketList);
    }
}

