/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.executor.timeaffiliation.model.SecondPeriod;
import kd.wtc.wtes.common.util.Assert;

public class Holiday
extends Entity {
    private static final long serialVersionUID = -6333784128217443102L;
    private DateType dateType;
    private String holidayType;
    private String fixedType;
    private int startTime;
    private int endTime;
    private int dyStartTime;
    private int dyEndTime;
    private transient Map<LocalDate, SecondPeriod> unFixEntry;
    public static final Comparator<Holiday> NUMBER_COMPARATOR = (o1, o2) -> {
        Assert.nonNull((Object)o1.getNumber(), (String)ResManager.loadKDString((String)"Holiday.number\u4e3a\u7a7a\uff1a\u5bf9\u5e94id\u4e3a{0}", (String)"Holiday_0", (String)"wtc-wtes-business", (Object[])new Object[]{o1.getId()}));
        Assert.nonNull((Object)o2.getNumber(), (String)ResManager.loadKDString((String)"Holiday.number\u4e3a\u7a7a\uff1a\u5bf9\u5e94id\u4e3a{0}", (String)"Holiday_0", (String)"wtc-wtes-business", (Object[])new Object[]{o2.getId()}));
        return o1.getNumber().compareTo(o2.getNumber());
    };

    protected Holiday(long id, String number) {
        super(id, number);
    }

    public static Builder of(long id, String number) {
        return new Builder(new Holiday(id, number));
    }

    public int getStartTime(LocalDate date) {
        if ("B".equals(this.holidayType)) {
            return this.unFixEntry.get(date).getStartTime();
        }
        if ("A".equals(this.fixedType)) {
            return this.startTime;
        }
        return this.dyStartTime;
    }

    public int getEndTime(LocalDate date) {
        if ("B".equals(this.holidayType)) {
            return this.unFixEntry.get(date).getEndTime();
        }
        if ("A".equals(this.fixedType)) {
            return this.endTime;
        }
        return this.dyEndTime;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public DateAttribute getDateAttribute() {
        return DateAttribute.HOLIDAY;
    }

    public String toString() {
        return "Holiday{dateType=" + this.dateType + ", holidayType='" + this.holidayType + '\'' + ", fixedType='" + this.fixedType + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", dyStartTime=" + this.dyStartTime + ", dyEndTime=" + this.dyEndTime + ", unFixEntry=" + this.unFixEntry + ", id=" + this.getId() + ", number='" + this.getNumber() + '\'' + '}';
    }

    public static class Builder {
        Holiday holiday;

        public Holiday build() {
            if (this.holiday.unFixEntry == null) {
                this.holiday.unFixEntry = Collections.emptyMap();
            }
            Holiday temp = this.holiday;
            this.holiday = null;
            return temp;
        }

        public Builder(Holiday holiday) {
            this.holiday = holiday;
        }

        public Builder dateType(DateType dateType) {
            this.holiday.dateType = dateType;
            return this;
        }

        public Builder holidayType(String holidayType) {
            this.holiday.holidayType = holidayType;
            return this;
        }

        public Builder fixedType(String fixedType) {
            this.holiday.fixedType = fixedType;
            return this;
        }

        public Builder startTime(int startTime) {
            this.holiday.startTime = startTime;
            return this;
        }

        public Builder endTime(int endTime) {
            this.holiday.endTime = endTime;
            return this;
        }

        public Builder dyStartTime(int dyStartTime) {
            this.holiday.dyStartTime = dyStartTime;
            return this;
        }

        public Builder dyEndTime(int dyEndTime) {
            this.holiday.dyEndTime = dyEndTime;
            return this;
        }

        public Builder unFixEntry(Map<LocalDate, SecondPeriod> unFixEntry) {
            this.holiday.unFixEntry = unFixEntry;
            return this;
        }
    }
}

