/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.stragegy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.AscriptionStrategy;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.SliceMode;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.SplitLine;
import kd.wtc.wtes.business.model.ShiftTableSingle;

public class DefaultAscriptionStrategy
implements AscriptionStrategy {
    private int offset_nh2nh;
    private SliceMode sliceMode_nh2nh;
    private boolean ascriptionPreDay_nh2nh;
    private int offset_nh2h;
    private SliceMode sliceMode_nh2h;
    private boolean ascriptionPreDay_nh2h;
    private int offset_h2nh;
    private SliceMode sliceMode_h2nh;
    private boolean ascriptionPreDay_h2nh;
    private int offset_h2h;
    private SliceMode sliceMode_h2h;
    private boolean ascriptionPreDay_h2h;
    private ShiftTableSingle shiftTableSingle;

    public DefaultAscriptionStrategy(ShiftTableSingle shiftTableSingle, int offset_nh2nh, SliceMode sliceMode_nh2nh, boolean ascriptionPreDay_nh2nh, int offset_nh2h, SliceMode sliceMode_nh2h, boolean ascriptionPreDay_nh2h, int offset_h2nh, SliceMode sliceMode_h2nh, boolean ascriptionPreDay_h2nh, int offset_h2h, SliceMode sliceMode_h2h, boolean ascriptionPreDay_h2h) {
        this.offset_nh2nh = offset_nh2nh;
        this.sliceMode_nh2nh = sliceMode_nh2nh;
        this.ascriptionPreDay_nh2nh = ascriptionPreDay_nh2nh;
        this.offset_nh2h = offset_nh2h;
        this.sliceMode_nh2h = sliceMode_nh2h;
        this.ascriptionPreDay_nh2h = ascriptionPreDay_nh2h;
        this.offset_h2nh = offset_h2nh;
        this.sliceMode_h2nh = sliceMode_h2nh;
        this.ascriptionPreDay_h2nh = ascriptionPreDay_h2nh;
        this.offset_h2h = offset_h2h;
        this.sliceMode_h2h = sliceMode_h2h;
        this.ascriptionPreDay_h2h = ascriptionPreDay_h2h;
        this.shiftTableSingle = shiftTableSingle;
    }

    @Override
    public SplitLine getSplitLineBetweenDateAndNextDate(LocalDate date) {
        LocalDate nextDate = date.plusDays(1L);
        DateAttribute curDateAttribute = this.getDateAttribute(date);
        DateAttribute nextDateAttribute = this.getDateAttribute(nextDate);
        if (curDateAttribute == null || nextDateAttribute == null) {
            return new SplitLine(SliceMode.NO, LocalDateTime.of(date, LocalTime.ofSecondOfDay(0L)).plusSeconds(86400L), true);
        }
        if (curDateAttribute == DateAttribute.HOLIDAY) {
            if (nextDateAttribute == DateAttribute.HOLIDAY) {
                int realOffset4h2h = this.getRealOffset(this.offset_h2h);
                return new SplitLine(this.sliceMode_h2h, LocalDateTime.of(date, LocalTime.ofSecondOfDay(0L)).plusSeconds(realOffset4h2h), this.ascriptionPreDay_h2h);
            }
            int realOffset4h2nh = this.getRealOffset(this.offset_h2nh);
            return new SplitLine(this.sliceMode_h2nh, LocalDateTime.of(date, LocalTime.ofSecondOfDay(0L)).plusSeconds(realOffset4h2nh), this.ascriptionPreDay_h2nh);
        }
        if (nextDateAttribute == DateAttribute.HOLIDAY) {
            int realOffset4nh2h = this.getRealOffset(this.offset_nh2h);
            return new SplitLine(this.sliceMode_nh2h, LocalDateTime.of(date, LocalTime.ofSecondOfDay(0L)).plusSeconds(realOffset4nh2h), this.ascriptionPreDay_nh2h);
        }
        int realOffset4nh2nh = this.getRealOffset(this.offset_nh2nh);
        return new SplitLine(this.sliceMode_nh2nh, LocalDateTime.of(date, LocalTime.ofSecondOfDay(0L)).plusSeconds(realOffset4nh2nh), this.ascriptionPreDay_nh2nh);
    }

    private int getRealOffset(int offset_mark) {
        return 86400 + offset_mark;
    }

    private DateAttribute getDateAttribute(LocalDate curDate) {
        return this.shiftTableSingle.getDateAttribute(curDate);
    }
}

