/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.util;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.lang.NotNull;

public class AscriptionUtils {
    @NotNull
    public static Map<Long, TimeSeqBo<TimeAscriptionRule>> getTimeAscriptionRuleBoMap(Set<Long> ids, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqBo<TimeAscriptionRule>> result = new HashMap<Long, TimeSeqBo<TimeAscriptionRule>>(ids.size());
        HRBaseServiceHelper hisServiceHelper = new HRBaseServiceHelper("wtp_mhsascription");
        DynamicObject[] hisDynArray = hisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(ids, startDate, endDate));
        HashMap<Long, List> hisDynCluster = new HashMap<Long, List>(ids.size());
        for (DynamicObject hisDyn2 : hisDynArray) {
            long fid = hisDyn2.getLong("boid");
            List list = hisDynCluster.getOrDefault(fid, new LinkedList());
            list.add(hisDyn2);
            hisDynCluster.put(fid, list);
        }
        for (Map.Entry entry : hisDynCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(hisDyn -> AscriptionUtils.generateTimeAscriptionRule(hisDyn, true)).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqBo<TimeAscriptionRule>)TimeSeqBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    @NotNull
    private static TimeAscriptionRule generateTimeAscriptionRule(DynamicObject dyn, boolean isTimeSeq) {
        long id = dyn.getLong("id");
        String number = dyn.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(dyn);
        TimeAscriptionRule.Builder builder = isTimeSeq ? TimeAscriptionRule.withTimeSeq(id, number, timeSeqEntity) : TimeAscriptionRule.withUnTimeSeq(id, number);
        builder.noHolidayAscription(dyn.getString("noholidayascription")).noHolidaySplitTime(dyn.getInt("nhbegintime"));
        return builder.build();
    }
}

