/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.rlra.util.RawTimeUtils;
import kd.wtc.wtes.business.executor.timeaffiliation.model.Holiday;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.AscriptionActuator;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.AscriptionStrategy;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.AscriptionStrategyGenerator;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;

public class TimeAffiliationUtils {
    private static final Log LOGGER = LogFactory.getLog(TimeAffiliationUtils.class);
    private static final String BEGIN_ASCRIPTION = "BEGIN_ASCRIPTION";

    public static List<TimeBucket> timeAffiliationCal(TieContextStd context, List<TimeBucket> ascOrderedTimeBucketList, TimeSeqBo<TimeAscriptionRule> timeAscriptionRuleBo) {
        LocalDate chainDate = context.getChainDate();
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        TimeAscriptionRule ascriptionRule = ContextUtil.getTimeAscriptionRuleByDate(context, chainDate);
        Map<Long, Holiday> holidayMap = ContextUtil.getHolidayMap(context);
        boolean beginDate = RawTimeUtils.isBeginDate(context);
        if (!context.containsVariable(BEGIN_ASCRIPTION, VScope.LINE) || beginDate) {
            TimeAffiliationUtils.preProcess(context, shiftTableSingle, holidayMap, ascOrderedTimeBucketList);
            context.setVariable(BEGIN_ASCRIPTION, BEGIN_ASCRIPTION, VScope.LINE);
        }
        AscriptionStrategy ascriptionStrategy = AscriptionStrategyGenerator.generateAscriptionStrategy(ascriptionRule, shiftTableSingle, holidayMap);
        List<TimeBucket> ascriptionTimeBuckets = AscriptionActuator.getTimeBucketsByDate(chainDate, ascOrderedTimeBucketList, ascriptionStrategy, context, shiftTableSingle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{},\u6838\u7b97\u65e5\u671f{}\u7684\u7b56\u7565\u65b9\u6cd5\u83b7\u53d6\u5f52\u5c5e\u5f53\u65e5\u65f6\u95f4\u5bf9\u5904\u7406\u540e\u6709{}\u4e2a\uff1a{}\u3002", (String)"TimeAffiliationUtils_1", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{context.getVersion(), chainDate, ascriptionTimeBuckets.size(), ascriptionTimeBuckets});
        }
        Roster roster = shiftTableSingle.getRoster(chainDate);
        List<TimeBucket> timeBuckets = TimeAffiliationUtils.resetTimeBucketDateByRoster(ascriptionTimeBuckets, roster);
        for (TimeBucket timeBucket : timeBuckets) {
            timeBucket.setEvaluationRule(EvaluationRuleModel.of(ascriptionRule.getId(), "wtp_mhsascription"));
        }
        return timeBuckets;
    }

    private static void preProcess(TieContextStd context, ShiftTableSingle shiftTableSingle, Map<Long, Holiday> holidayMap, List<TimeBucket> ascOrderedTimeBucketList) {
        AscriptionStrategy preDateAscriptionStrategy;
        AscriptionStrategy prePreDateAscriptionStrategy;
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        LocalDate prePreDate = chainDate.plusDays(-2L);
        TimeAscriptionRule prePreAscriptionRule = ContextUtil.getTimeAscriptionRuleByDate(context, prePreDate);
        if (prePreAscriptionRule == null) {
            LOGGER.warn(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5bf9\u4e8e\u8003\u52e4\u4eba[ID={}, \u65e5\u671f={}]\u4e0d\u5b58\u5728\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\uff0c\u8ba1\u7b97\u9700\u8981\u83b7\u53d6\u9996\u65e5\u7684\u524d\u4e24\u5929\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u3002\u6b64\u5904\u5c06\u9ed8\u8ba4\u4f7f\u7528\u65e5\u671f\u5f52\u5c5e\u89c4\u5219[\u975e\u5047\u671f\u65e5\u671f\u5f52\u5c5e=\u73ed\u6b21\u5f00\u59cb\u65e5\uff0c\u5047\u671f\u65e5\u671f\u5f52\u5c5e=\u73ed\u6b21\u5f00\u59cb\u65e5]\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"TimeAffiliationUtils_2", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attPersonId, (Object)prePreDate);
            prePreDateAscriptionStrategy = AscriptionStrategyGenerator.doGenerate4BeginAndBegin(shiftTableSingle);
        } else {
            prePreDateAscriptionStrategy = AscriptionStrategyGenerator.generateAscriptionStrategy(prePreAscriptionRule, shiftTableSingle, holidayMap);
        }
        LocalDate preDate = chainDate.plusDays(-1L);
        TimeAscriptionRule preAscriptionRule = ContextUtil.getTimeAscriptionRuleByDate(context, preDate);
        if (preAscriptionRule == null) {
            LOGGER.warn(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5bf9\u4e8e\u8003\u52e4\u4eba[ID={}, \u65e5\u671f={}]\u4e0d\u5b58\u5728\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\uff0c\u8ba1\u7b97\u9700\u8981\u83b7\u53d6\u9996\u65e5\u7684\u524d\u4e24\u5929\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u3002\u6b64\u5904\u5c06\u9ed8\u8ba4\u4f7f\u7528\u65e5\u671f\u5f52\u5c5e\u89c4\u5219[\u975e\u5047\u671f\u65e5\u671f\u5f52\u5c5e=\u73ed\u6b21\u5f00\u59cb\u65e5\uff0c\u5047\u671f\u65e5\u671f\u5f52\u5c5e=\u73ed\u6b21\u5f00\u59cb\u65e5]\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"TimeAffiliationUtils_2", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attPersonId, (Object)preDate);
            preDateAscriptionStrategy = AscriptionStrategyGenerator.doGenerate4BeginAndBegin(shiftTableSingle);
        } else {
            preDateAscriptionStrategy = AscriptionStrategyGenerator.generateAscriptionStrategy(preAscriptionRule, shiftTableSingle, holidayMap);
        }
        AscriptionActuator.preProcessAscription(chainDate, ascOrderedTimeBucketList, preDateAscriptionStrategy, prePreDateAscriptionStrategy, context, shiftTableSingle);
    }

    public static List<TimeBucket> convert2TimeBuckets(List<TimeBucketStd> timeBucketStdList) {
        return timeBucketStdList.stream().map(tbs -> (TimeBucket)((TimeBucket.Builder)tbs.unwrapAndCopy().toBuilder().parentDataNodes(Collections.singletonList(tbs))).build()).collect(Collectors.toList());
    }

    public static List<TimeBucket> resetTimeBucketDateByRoster(List<TimeBucket> timeBucketList, Roster roster) {
        ArrayList<TimeBucket> result = new ArrayList<TimeBucket>(timeBucketList.size());
        DateType dateType = roster.getDateType();
        DateAttribute dateAttribute = roster.getDateAttribute();
        timeBucketList.forEach(timeBucket -> result.add(TimeAffiliationUtils.generateTimeBucketPropertiesDefault(timeBucket, dateType, dateAttribute)));
        return result;
    }

    private static TimeBucket generateTimeBucketPropertiesDefault(TimeBucket timeBucket, DateType dateType, DateAttribute dateAttribute) {
        return (TimeBucket)((CleanableBuilder)((TimeBucket.Builder)((TimeBucket.Builder)timeBucket.clone().toBuilder().parentDataNodes(timeBucket.parentDataNodes())).dateType(dateType)).dateAttribute(dateAttribute)).build();
    }
}

