/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.exporter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.model.TieLineState;
import kd.wtc.wtes.business.std.AbstractTieExporter;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;

public class TieLineExporterStdImpl
implements ITieLineExporter {
    private static final Log LOGGER = LogFactory.getLog(TieLineExporterStdImpl.class);
    private AbstractTieExporter tieExporter;
    private final TieLineState tieLineState = new TieLineState();
    private final StringBuilder stringBuilder = new StringBuilder();
    private TieMsgLevel level = TieMsgLevel.INFO;
    private final AttSubject attSubject;
    private final Map<AttSubject.AttFileBo, LocalDate> lastTieDateMap;
    private static final int MAX_EXPORT_SIZE = 200;

    public TieLineExporterStdImpl(AbstractTieExporter tieExporter, AttSubject attSubject) {
        this.tieExporter = tieExporter;
        this.tieLineState.setAttPersonId(attSubject.getAttPersonId());
        this.tieLineState.setLineBeginDate(attSubject.getStartDate());
        this.tieLineState.setLineEndDate(attSubject.getEndDate());
        this.attSubject = attSubject;
        this.lastTieDateMap = new HashMap<AttSubject.AttFileBo, LocalDate>(attSubject.getAttFileBos().size());
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.stringBuilder.append((Object)msgLevel).append(WTCSymbolMultiLanguageUtil.getColonSymbol());
        this.stringBuilder.append(msg).append(WTCSymbolMultiLanguageUtil.getSemicolonSymbol());
        if (TieMsgLevel.ERROR == msgLevel) {
            this.level = msgLevel;
        }
        if (TieMsgLevel.WARNING == msgLevel && TieMsgLevel.INFO == this.level) {
            this.level = msgLevel;
        }
        if (TieMsgLevel.ERROR == msgLevel) {
            this.tieExporter.pushSubjectErrorMsg(this.attSubject.getAttPersonId(), msg);
        }
    }

    @Override
    public void stateChanged(TieState oldState, TieState newState) {
        this.tieLineState.setEngineStateId(this.tieExporter.getEngineState().getSubTaskId());
        this.tieLineState.setTaskId(this.tieExporter.getEngineState().getTaskid());
        this.tieLineState.setEndTime(LocalDateTime.now());
        this.tieLineState.setTaskStatusRefreshTime(LocalDateTime.now());
        this.tieLineState.setMessageLevel(this.level.name());
        if (this.stringBuilder.length() > 200) {
            this.tieLineState.setMessage(this.stringBuilder.substring(0, 200) + "...");
        } else {
            this.tieLineState.setMessage(this.stringBuilder.toString());
        }
        this.tieLineState.setStatus(newState.name());
        if (TieState.SUCCESS == newState || TieState.ERROR == newState || TieState.TERMINATED == newState) {
            this.tieExporter.addCacheLine(this.tieLineState, newState);
            if (TieState.ERROR == newState) {
                this.clearAfterErrorDate(null);
            }
        }
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return this.lastTieDateMap;
    }

    @Override
    public void finishOneChain(LocalDate chainDate) {
        this.tieLineState.setChainFinish(this.tieLineState.getChainFinish() + 1);
        LocalDate tieToDate = this.tieLineState.$getTieToDate();
        if (tieToDate == null || chainDate.isAfter(this.tieLineState.$getTieToDate())) {
            this.tieLineState.setTieToDate(chainDate);
        }
    }

    @Override
    public void finishOneChain(AttSubject.AttSubjectEntry attSubjectEntry) {
        LOGGER.debug("finishOneChain:{}", (Object)attSubjectEntry);
        LocalDate currentDate = attSubjectEntry.getCurrentDate();
        this.tieLineState.setChainFinish(this.tieLineState.getChainFinish() + 1);
        if (this.tieLineState.$getTieToDate() == null || currentDate.isAfter(this.tieLineState.$getTieToDate())) {
            this.tieLineState.setTieToDate(currentDate);
        }
        this.pushLastDate(currentDate);
    }

    @Override
    public void errorOneChain(AttSubject.AttSubjectEntry attSubjectEntry) {
        LOGGER.debug(ResManager.loadKDString((String)"\u6d41\u6c34\u7ebf\u51fa\u73b0\u5931\u8d25\uff1aerrorOneChain:{}\u3002", (String)"TieLineExporterStdImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attSubjectEntry);
        this.clearAfterErrorDate(attSubjectEntry.getAttFileBoid());
    }

    private void pushLastDate(LocalDate currentDate) {
        List attFileBos = this.attSubject.getAttFileBos();
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            if (!attFileBo.getStartDate().isEqual(currentDate) && !attFileBo.getStartDate().isBefore(currentDate) || !attFileBo.getEndDate().isAfter(currentDate)) continue;
            this.lastTieDateMap.put(attFileBo, currentDate);
            break;
        }
    }

    @Override
    public void clearAfterErrorDate(Long attFileBoId) {
        DataPackageStoreManager dataPackageStoreManager = DataPackageStoreManager.getInstance();
        if (null == this.tieLineState.getTieToDate() && null != this.tieLineState.getLineBeginDate()) {
            attFileBoId = attFileBoId == null ? this.attSubject.getAttFileBoId(WTCDateUtils.toLocalDate((Date)this.tieLineState.getLineBeginDate())) : attFileBoId;
            dataPackageStoreManager.clearAfterErrorDate(attFileBoId, this.tieLineState.getLineBeginDate());
        } else if (null != this.tieLineState.getTieToDate() && null != this.tieLineState.getLineEndDate() && this.tieLineState.getTieToDate().compareTo(this.tieLineState.getLineEndDate()) < 0) {
            attFileBoId = attFileBoId == null ? this.attSubject.getAttFileBoId(WTCDateUtils.toLocalDate((Date)this.tieLineState.getTieToDate())) : attFileBoId;
            dataPackageStoreManager.clearAfterErrorDate(attFileBoId, this.tieLineState.getTieToDate());
        }
    }
}

