/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.core.chain;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContextExt;
import kd.sdk.wtc.wtes.business.tie.model.attenperson.AttendPersonExt;
import kd.sdk.wtc.wtes.business.tie.model.attfile.AttFileExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.card.LogicCardExt;
import kd.sdk.wtc.wtes.business.tie.model.perattperiod.PerAttPeriodExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExtMap;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.ext.model.attenperson.AttendPersonExtImpl;
import kd.wtc.wtes.business.ext.model.attfile.AttFileExtImpl;
import kd.wtc.wtes.business.ext.model.attitem.AttItemSpecExtImpl;
import kd.wtc.wtes.business.ext.model.perattperiod.PerAttPeriodExtImpl;
import kd.wtc.wtes.business.ext.model.roster.RosterExtImpl;
import kd.wtc.wtes.business.ext.model.roster.RosterExtMapImpl;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.init.LogicCardData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;

public class TieContextExtImpl
implements TieContextExt {
    private LocalDate chainDate;
    private long attFileBoId;
    private long attPersonId;
    private Map<String, Object> initParams;
    private RosterExtMap rosterExtMap;
    private TieContextStd tieContext;

    public TieContextExtImpl(TieContextStd tieContext) {
        this.tieContext = tieContext;
        this.chainDate = tieContext.getDataPackage().getChainDate();
        this.attFileBoId = tieContext.getAttSubjectEntry().getAttFileBoid();
        this.attPersonId = tieContext.getAttSubjectEntry().getAttPersonId();
        this.initParams = tieContext.getInitParams();
        this.rosterExtMap = this.getRosterExtMap();
    }

    public AttItemSpecExt getAttItemSpecExt(Long bid, LocalDate chainDate) {
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(this.tieContext);
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(bid, chainDate);
        return new AttItemSpecExtImpl(attItemSpec);
    }

    public RosterExt getRosterExt(LocalDate chainDate) {
        return this.rosterExtMap.getByDate(chainDate);
    }

    public RosterExt getRosterExt(long attPersonId, LocalDate chainDate) {
        ShiftTable shiftTable = ContextUtil.getShiftTable(this.tieContext);
        ShiftTableSingle shiftTableSingle = shiftTable.getByAttPersonId(attPersonId);
        return new RosterExtImpl(shiftTableSingle.getRoster(chainDate));
    }

    public Map<String, Object> getInitMap() {
        return this.initParams;
    }

    public AttItemInstanceExt genAttItemInstanceExt(Long bid, BigDecimal itemValue, BigDecimal day, BigDecimal secondDecimal) {
        AttItemSpecExt attItemSpec = this.getAttItemSpecExt(bid, this.getCalculateDate());
        return new AttItemInstanceExt(attItemSpec, itemValue, day, secondDecimal);
    }

    public AttFileExt getAttFileByAttPersonIdAndDate(long attPersonId, LocalDate inDate) {
        AttFileCabinet attFileCabinet = ContextUtil.getAttFileCabinet(this.tieContext);
        return new AttFileExtImpl(attFileCabinet.getByAttPersonIdAndDate(attPersonId, inDate));
    }

    public Object getExtInItData() {
        return this.initParams.get("TIE_EXT_PARAM");
    }

    public LocalDate getCalculateDate() {
        return this.chainDate;
    }

    public long getAttPersonId() {
        return this.attPersonId;
    }

    public long getAttFileBoId() {
        return this.attFileBoId;
    }

    private RosterExtMap getRosterExtMap() {
        ShiftTable shiftTable = ContextUtil.getShiftTable(this.tieContext);
        ShiftTableSingle shiftTableSingle = shiftTable.getByAttPersonId(this.attPersonId);
        Map<LocalDate, Roster> rosterSpecMap = shiftTableSingle.getRosterSpecMap();
        return new RosterExtMapImpl(rosterSpecMap);
    }

    public PerAttPeriodExt getPerAttPeriodByAttPersonIdAndDate(long attPersonId, LocalDate chainDate) {
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(this.tieContext);
        Optional<PerAttPeriod> optionalPerAttPeriod = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate(attPersonId, chainDate);
        return optionalPerAttPeriod.map(PerAttPeriodExtImpl::new).orElse(null);
    }

    public List<PerAttPeriodExt> getPerAttPeriodListByAttPerson(long attPersonId) {
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(this.tieContext);
        List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriodList(attPersonId);
        if (WTCCollections.isEmpty(perAttPeriodList)) {
            return Collections.emptyList();
        }
        return perAttPeriodList.stream().map(PerAttPeriodExtImpl::new).collect(Collectors.toList());
    }

    public AttendPersonExt getAttendPersonByAttPersonIdAndDate(long attPersonId, LocalDate chainDate) {
        AttendPersonModel attendPersonData = ContextUtil.getAttendPersonData(this.tieContext, attPersonId, chainDate);
        return new AttendPersonExtImpl(attendPersonData);
    }

    public List<LogicCardExt> getLogicCardDataByPersonIdAndDate(long attPersonId, LocalDate chainDate) {
        LogicCardData logicCardData = ContextUtil.getLogicCardData(this.tieContext);
        List<LogicCard> logicCards = logicCardData.getByAttPersonIdAndDate(attPersonId, chainDate);
        if (WTCCollections.isEmpty(logicCards)) {
            return Collections.emptyList();
        }
        return logicCards.stream().map(ContextExtUtil::covertLogicCardExt).collect(Collectors.toList());
    }
}

