/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.model.attconfig;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.model.attconfig.AttRuleCalExt;
import kd.sdk.wtc.wtes.business.tie.model.attconfig.AttRuleExt;
import kd.sdk.wtc.wtes.business.tie.model.attconfig.AttendConfigExt;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.ext.model.attconfig.AttRuleCalExtImpl;
import kd.wtc.wtes.business.ext.model.attconfig.AttendConfigExtImpl;
import kd.wtc.wtes.business.ext.timeseq.AbstractTimeSeqVersionExt;
import kd.wtc.wtes.business.model.attconfig.AttRule;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.business.model.attconfig.AttendConfig;

public class AttRuleExtImpl
extends AbstractTimeSeqVersionExt
implements AttRuleExt {
    private final AttRule attRule;
    private List<AttRuleCalExt> attRuleCalExts;

    public AttRuleExtImpl(AttRule attRule) {
        super(attRule.getTimeSeqInfo());
        this.attRule = attRule;
    }

    public List<AttRuleCalExt> getAttRuleCal() {
        List<AttRuleCal> attRuleCal = this.attRule.getAttRuleCal();
        if (this.attRuleCalExts == null && WTCCollections.isNotEmpty(attRuleCal)) {
            this.attRuleCalExts = attRuleCal.stream().map(AttRuleCalExtImpl::new).collect(Collectors.toList());
        }
        return WTCCollections.unmodifiableList(this.attRuleCalExts);
    }

    public AttendConfigExt getAttendConfigTimeSeqBo(LocalDate chainDate) {
        TimeSeqBo<AttendConfig> attendConfigTimeSeqBo = this.attRule.getAttendConfigTimeSeqBo();
        if (attendConfigTimeSeqBo == null) {
            return null;
        }
        AttendConfig attendConfig = (AttendConfig)attendConfigTimeSeqBo.getVersionByDate(chainDate);
        if (attendConfig == null) {
            return null;
        }
        return new AttendConfigExtImpl(attendConfig);
    }

    public boolean isContainOverTime() {
        return this.attRule.isContainOverTime();
    }

    public Long getShouldAttendDay() {
        return this.attRule.getShouldAttendDay();
    }

    public Long getShouldAttendHour() {
        return this.attRule.getShouldAttendHour();
    }
}

