/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.model.daily;

import java.time.LocalDate;
import java.util.Map;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContentPersistentExt;
import kd.sdk.wtc.wtes.business.tie.model.attenperson.AttendPersonExt;
import kd.sdk.wtc.wtes.business.tie.model.attfile.AttFileExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExtMap;
import kd.wtc.wtes.business.ext.model.attenperson.AttendPersonExtImpl;
import kd.wtc.wtes.business.ext.model.attfile.AttFileExtImpl;
import kd.wtc.wtes.business.ext.model.attitem.AttItemSpecExtImpl;
import kd.wtc.wtes.business.ext.model.roster.RosterExtMapImpl;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;

public class TieContentPersistentExtImpl
implements TieContentPersistentExt {
    private Map<String, Object> initParams;

    public TieContentPersistentExtImpl(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    public AttItemSpecExt getAttItemSpecExt(Long bid, LocalDate chainDate) {
        try {
            AttItemSpecData attItemSpecData = (AttItemSpecData)this.initParams.get("ATT_ITEM_SPEC");
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(bid, chainDate);
            return new AttItemSpecExtImpl(attItemSpec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RosterExt getRosterExt(long attPersonId, LocalDate chainDate) {
        RosterExtMap rosterExtMap = this.getRosterExtMap(attPersonId);
        return rosterExtMap.getByDate(chainDate);
    }

    public AttFileExt getAttFileByAttPersonIdAndDate(long attPersonId, LocalDate inDate) {
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        return new AttFileExtImpl(attFileCabinet.getByAttPersonIdAndDate(attPersonId, inDate));
    }

    public Object getExtInitData() {
        return this.initParams.get("TIE_EXT_PARAM");
    }

    public AttendPersonExt getAttendPersonByAttPersonIdAndDate(long attPersonId, LocalDate chainDate) {
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
        if (null == attFileModel) {
            return null;
        }
        AttendPersonData attendPersonData = (AttendPersonData)((Object)this.initParams.get("ATT_PERINFO"));
        if (attendPersonData == null) {
            return null;
        }
        AttendPersonModel attendPersonModel = attendPersonData.getByBidAndDate(attFileModel, chainDate);
        return new AttendPersonExtImpl(attendPersonModel);
    }

    private RosterExtMap getRosterExtMap(long attPersonId) {
        ShiftTable shiftTable = (ShiftTable)this.initParams.get("ROSTER");
        ShiftTableSingle shiftTableSingle = shiftTable.getByAttPersonId(attPersonId);
        Map<LocalDate, Roster> rosterSpecMap = shiftTableSingle.getRosterSpecMap();
        return new RosterExtMapImpl(rosterSpecMap);
    }
}

