/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.model.roster;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftMiddleRuleExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSessionExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSpecExt;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.ext.model.roster.ShiftMiddleRuleExtImpl;
import kd.wtc.wtes.business.ext.model.roster.ShiftSessionExtImpl;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;

public class ShiftSpecExtImpl
implements ShiftSpecExt {
    private ShiftSpec shiftSpec;

    public ShiftSpecExtImpl(ShiftSpec shiftSpec) {
        this.shiftSpec = shiftSpec;
    }

    public String getShiftType() {
        return this.shiftSpec.getShiftType().getCode();
    }

    public List<ShiftSessionExt> getShiftSession() {
        return this.transferShiftSession(this.shiftSpec.getShiftSessions());
    }

    public boolean isOff() {
        return this.shiftSpec.isOff();
    }

    public boolean isOffNonPlan() {
        return this.shiftSpec.isOffNonPlan();
    }

    public String getFirstRefDateType() {
        return this.shiftSpec.getFirstRefDateType().code;
    }

    public String getLastRefDateType() {
        return this.shiftSpec.getLastRefDateType().code;
    }

    public LocalTime getEarliestShiftTime() {
        return this.shiftSpec.getEarliestShiftTime();
    }

    public LocalTime getLastShiftTime() {
        return this.shiftSpec.getLastShiftTime();
    }

    public List<ShiftSessionExt> getWorkSession() {
        return this.transferShiftSession(this.shiftSpec.getWorkSession());
    }

    public int getWorkTime() {
        return this.shiftSpec.getWorkTime();
    }

    public int getBreakTime() {
        return this.shiftSpec.getBreakTime();
    }

    public int getOtTime() {
        return this.shiftSpec.getOtTime();
    }

    public int getShiftTime() {
        return this.shiftSpec.getShiftTime();
    }

    public BigDecimal getAllDayHour() {
        return this.shiftSpec.getAlldayhour();
    }

    public Integer getStandardTime() {
        return this.shiftSpec.getStandardTime();
    }

    public ShiftMiddleRuleExt getShiftMiddleRule() {
        return new ShiftMiddleRuleExtImpl(this.shiftSpec.getShiftMiddleRule());
    }

    public BigDecimal secondsToDays(BigDecimal seconds) {
        BigDecimal allDayHour = this.getAllDayHour();
        if (allDayHour == null || allDayHour.compareTo(BigDecimal.ZERO) == 0 || seconds.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal second = seconds;
        BigDecimal allDaySecond = allDayHour.multiply(BigDecimal.valueOf(3600L));
        return second.divide(allDaySecond, 10, 4);
    }

    public BigDecimal daysToSecondDecimal(BigDecimal days) {
        BigDecimal allDayHour = this.getAllDayHour();
        if (days == null || allDayHour.compareTo(BigDecimal.ZERO) == 0 || days.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal allDaySecond = allDayHour.multiply(BigDecimal.valueOf(3600L));
        if (days.compareTo(BigDecimal.ONE) == 0) {
            return allDaySecond;
        }
        return days.multiply(allDaySecond);
    }

    private List<ShiftSessionExt> transferShiftSession(List<ShiftSession> shiftSessions) {
        if (WTCCollections.isEmpty(shiftSessions)) {
            return Collections.emptyList();
        }
        return shiftSessions.stream().map(ShiftSessionExtImpl::new).collect(Collectors.toList());
    }
}

