/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContextExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.card.LogicCardExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSessionExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.AttBillTimeBucketExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.TimeBucketExt;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.chain.TieContext;
import kd.wtc.wtes.business.ext.core.chain.TieContextExtImpl;
import kd.wtc.wtes.business.ext.model.attitem.AttItemSpecExtImpl;
import kd.wtc.wtes.business.ext.model.card.LogicCardExtImpl;
import kd.wtc.wtes.business.ext.model.roster.ShiftSessionExtImpl;
import kd.wtc.wtes.business.ext.model.timebucket.AttBillTimeBucketExtImpl;
import kd.wtc.wtes.business.ext.model.timebucket.TimeBucketExtImpl;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.common.enums.BillNonPlanEnum;
import kd.wtc.wtes.common.enums.BillTimeBucketType;

public final class ContextExtUtil {
    private ContextExtUtil() {
    }

    public static TieContextExt getTieContextExt(TieContextStd tieContext) {
        return new TieContextExtImpl(tieContext);
    }

    public static TimeBucketExt covertTimeBucketExt(TimeBucketStd timeBucket) {
        return new TimeBucketExtImpl(timeBucket);
    }

    public static AttItemValue covertAttItemValue(AttItemInstanceExt attItemInstanceExt) {
        BigDecimal seconds = attItemInstanceExt.getSecondDecimal();
        BigDecimal day = attItemInstanceExt.getDay();
        BigDecimal itemValue = attItemInstanceExt.getItemValue();
        AttItemSpec attItemSpec = (AttItemSpec)((Object)attItemInstanceExt.getAttItemSpecExt().getInstance());
        AttItemInstance attItemInstance = new AttItemInstance(attItemSpec, itemValue, day, seconds, null);
        AttItemValue attItemValue = (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(Lists.newLinkedList())).attItemInstance(attItemInstance)).build();
        return attItemValue;
    }

    public static AttBillTimeBucketExt covertBillTimeBucketExt(AttBillTimeBucket billTimeBucket) {
        return new AttBillTimeBucketExtImpl(billTimeBucket);
    }

    public static LogicCardExt covertLogicCardExt(LogicCard logicCard) {
        return new LogicCardExtImpl(logicCard);
    }

    public static ShiftSessionExt covertShiftSessionExt(ShiftSession shiftSession) {
        return new ShiftSessionExtImpl(shiftSession);
    }

    public static <T> T getExtPlugin(TieContext tieContext, String name) {
        Map extPluginMap = (Map)tieContext.getInitParam("EXT_PLUGIN");
        return (T)extPluginMap.get(name);
    }

    public static <T> T getPeriodExtPlugin(TieAttPeriodContext tieContext, String name) {
        Map extPluginMap = (Map)tieContext.getInitParams().get("EXT_PLUGIN");
        return (T)extPluginMap.get(name);
    }

    public static Map<Long, AttItemInstanceExt> convertToAttItemInstanceMap(Map<Long, AttItemValue> attItemValueMap) {
        HashMap parsedAttItemInstanceExtMap = Maps.newHashMapWithExpectedSize((int)attItemValueMap.size());
        for (Map.Entry<Long, AttItemValue> entryValue : attItemValueMap.entrySet()) {
            AttItemValue value = entryValue.getValue();
            if (value == null) continue;
            AttItemInstance attItemInstance = value.getAttItemInstance();
            AttItemSpec attItemSpec = attItemInstance.getAttItemSpec();
            AttItemInstanceExt instanceExt = new AttItemInstanceExt((AttItemSpecExt)new AttItemSpecExtImpl(attItemSpec), attItemInstance.getItemValue(), attItemInstance.getDay(), attItemInstance.getSecondDecimal());
            parsedAttItemInstanceExtMap.put(entryValue.getKey(), instanceExt);
        }
        return parsedAttItemInstanceExtMap;
    }

    public static AttBillTimeBucket convertAttBillTimeBucketExt(AttBillTimeBucketExt timeBucketExt, Map<Long, DynamicObject> vaDyMap) {
        DynamicObject dynamicObject = vaDyMap.get(timeBucketExt.getBillId());
        AttBillTimeBucket.Builder builder = AttBillTimeBucket.with().id(timeBucketExt.getId()).number(timeBucketExt.getNumber()).attPersonId(timeBucketExt.getAttPersonId()).billId(timeBucketExt.getBillId()).billTypeBig(timeBucketExt.getBillTypeBig()).billType(timeBucketExt.getBillType()).billNonPlanEnum(BillNonPlanEnum.from((String)timeBucketExt.getBillNonPlan())).compenType(timeBucketExt.getCompenType()).compenTypeId(timeBucketExt.getCompenTypeId()).rosterDate(timeBucketExt.getRosterDate()).startTime(timeBucketExt.getStartTime()).endTime(timeBucketExt.getEndTime()).entryRowDy(timeBucketExt.getEntryRowDy()).type(BillTimeBucketType.from((String)timeBucketExt.getType())).vaBillDyn(dynamicObject);
        Long duration = timeBucketExt.getDuration();
        if (duration != null) {
            builder.duration(duration);
        }
        AttBillTimeBucket attBillTimeBucket = builder.build();
        return attBillTimeBucket;
    }
}

