/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.ext.utils.TieInitExtUtil;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.service.LogicCardQueryServiceImpl;

public class LogicCardData {
    Log logger = LogFactory.getLog(LogicCardData.class);
    public static final String KEY_ATT_PERSON = "attperson";
    public static final String KEY_SPECIFIC_TIME = "specifictime";
    private Map<Long, Map<LocalDate, List<LogicCard>>> cache = new HashMap<Long, Map<LocalDate, List<LogicCard>>>();
    private Map<Long, Map<LocalDate, Boolean>> cardMatchMap = new HashMap<Long, Map<LocalDate, Boolean>>();

    public LogicCardData(InitParam initRequest) {
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        LogicCardQueryServiceImpl logicCardQueryService = new LogicCardQueryServiceImpl();
        HashSet multiExtKeys = Sets.newHashSet();
        DynamicObject[] mutiCardDyns = logicCardQueryService.queryEffectiveMutiCard(attPersonIds, WTCDateUtils.toDate((LocalDate)startDate), WTCDateUtils.toDate((LocalDate)endDate), multiExtKeys);
        HashSet onceExtKeys = Sets.newHashSet();
        DynamicObject[] onceCardDyns = logicCardQueryService.queryEffectiveOnceCard(attPersonIds, WTCDateUtils.toDate((LocalDate)startDate), WTCDateUtils.toDate((LocalDate)endDate), onceExtKeys);
        this.cacheEffectiveCardByDynamicObjects(mutiCardDyns, multiExtKeys, true);
        this.cacheEffectiveCardByDynamicObjects(onceCardDyns, onceExtKeys, false);
    }

    private void cacheEffectiveCardByDynamicObjects(DynamicObject[] dynamicObjects, Set<String> extKeys, boolean isMultiCard) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            List<LogicCard> effectiveCarList;
            Date finalCheckDate = dynamicObject.getDate("shiftbelongdate");
            LocalDate finalCheckLocalDate = WTCDateUtils.toLocalDate((Date)finalCheckDate);
            Long personId = dynamicObject.getLong("attperson.id");
            Map singlePersonPunchCardMap = this.cardMatchMap.computeIfAbsent(personId, key -> new HashMap(16));
            singlePersonPunchCardMap.put(finalCheckLocalDate, Boolean.TRUE);
            Date effectiveCardPoint = dynamicObject.getDate(KEY_SPECIFIC_TIME);
            if (effectiveCardPoint == null) continue;
            Map<LocalDate, List<LogicCard>> dateMap = this.cache.get(personId);
            if (null == dateMap) {
                dateMap = new HashMap<LocalDate, List<LogicCard>>(16);
            }
            if ((effectiveCarList = dateMap.get(finalCheckLocalDate)) == null) {
                effectiveCarList = new ArrayList<LogicCard>(10);
            }
            Date worktime = dynamicObject.getDate("worktime");
            LocalDateTime cardPointSupposed = WTCDateUtils.toLocalDateTime((Date)worktime);
            long timeZoneId = dynamicObject.getLong("timezone");
            int timeDiff = dynamicObject.getInt("timeDif");
            Boolean isOnCard = null;
            int seq = 0;
            if (isMultiCard) {
                seq = dynamicObject.getInt("seq");
                isOnCard = seq % 2 == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            LogicCard logicCard = new LogicCard(personId, WTCDateUtils.toLocalDateTime((Date)effectiveCardPoint), cardPointSupposed, timeZoneId, timeDiff, isOnCard, isMultiCard, seq);
            logicCard.setExtAttribute(TieInitExtUtil.buildDataAttribute(dynamicObject, extKeys));
            if (isMultiCard) {
                logicCard.setShiftId(dynamicObject.getLong("shift"));
            }
            effectiveCarList.add(logicCard);
            dateMap.put(finalCheckLocalDate, effectiveCarList);
            this.cache.put(personId, dateMap);
        }
    }

    public List<LogicCard> getByAttPersonIdAndDate(long attPersonId, LocalDate inDate) {
        this.logger.debug("LogicCardData input: attpersonId{}\uff0cinDate{}", (Object)attPersonId, (Object)inDate);
        Map<LocalDate, List<LogicCard>> localDateListMap = this.cache.get(attPersonId);
        if (null == localDateListMap) {
            return Collections.emptyList();
        }
        return localDateListMap.getOrDefault(inDate, Collections.emptyList());
    }

    public Map<Long, Map<LocalDate, List<LogicCard>>> getCache() {
        return this.cache;
    }

    public Map<Long, Map<LocalDate, Boolean>> getCardMatchMap() {
        return this.cardMatchMap;
    }
}

