/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.util.List;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.service.AttBillTimeBucketServiceImpl;
import kd.wtc.wtes.business.service.IAttBillTimeBucketService;

public class TieInitializerAttBillTimeBucket
implements TieParamInitializer {
    protected IAttBillTimeBucketService billTimeBucketService;

    public TieInitializerAttBillTimeBucket(IAttBillTimeBucketService billTimeBucketService) {
        this.billTimeBucketService = billTimeBucketService;
    }

    public TieInitializerAttBillTimeBucket() {
        this.billTimeBucketService = new AttBillTimeBucketServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        ShiftTable shiftTable = (ShiftTable)initRequest.getInitParams().get("ROSTER");
        List<AttBillTimeBucket> billTimeBuckets = this.billTimeBucketService.listByAttPersonIdAndRangeDate(initRequest, shiftTable);
        AttBillTimeBucketData billTimeBucketData = AttBillTimeBucketData.of(billTimeBuckets);
        return InitParamResult.success(billTimeBucketData);
    }

    @Override
    public String category() {
        return "BILL_TIME_BUCKET";
    }

    public void setBillTimeBucketService(IAttBillTimeBucketService billTimeBucketService) {
        this.billTimeBucketService = billTimeBucketService;
    }
}

