/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.retrieval.service.RetrievalAttFileDateDimension;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitException;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.executor.formula.provider.TieProviderConfig;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.util.FormulaEntityUtils;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.formula.adapt.FormulaService;
import kd.wtc.wtp.business.formula.adapt.provider.DataProvider;

public class TieInitializerAttFormula
implements TieParamInitializer {
    private static final Log LOGGER = LogFactory.getLog(TieInitializerAttFormula.class);

    @Override
    public InitParamResult init(InitParam initRequest) throws TieParamInitException {
        TieMessageStd msg;
        List<TimeSeqBo<AttFileModel>> value;
        if (!WTCGrayscaleUtils.isFormulaOpen().booleanValue()) {
            return InitParamResult.exclusion(new TieMessageStd(TieMsgLevel.INFO, "Formula not enable"));
        }
        Map<String, Object> initParams = initRequest.getInitParams();
        AttFileCabinet attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
        HashSet formulaIdList = Sets.newHashSetWithExpectedSize((int)16);
        Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap = attFileCabinet.getAttFileTimeSeqBoMap();
        for (Map.Entry<Long, List<TimeSeqBo<AttFileModel>>> entry : attFileTimeSeqBoMap.entrySet()) {
            List<TimeSeqBo<AttFileModel>> value2 = entry.getValue();
            for (TimeSeqBo<AttFileModel> timeSeqBo : value2) {
                List list = timeSeqBo.getVersions();
                for (Object attFileModel : list) {
                    List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFormulaPlanPackageList = ((AttFileModel)((Object)attFileModel)).getAttFormulaPlanPackageList();
                    List<Long> vidList = FormulaEntityUtils.getConfigIdListFromPlanSeqBoMap(attFormulaPlanPackageList);
                    formulaIdList.addAll(vidList);
                }
            }
        }
        ArrayList<RetrievalAttFileDateDimension> dimensions = new ArrayList<RetrievalAttFileDateDimension>();
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        while (!startDate.isAfter(endDate)) {
            Date date = WTCDateUtils.toDate((LocalDate)startDate);
            for (Map.Entry<Long, List<TimeSeqBo<AttFileModel>>> entry : attFileTimeSeqBoMap.entrySet()) {
                value = entry.getValue();
                if (WTCCollections.isEmpty(value)) continue;
                for (Object tmModel : value) {
                    AttFileModel version = (AttFileModel)tmModel.getVersionByDate(startDate);
                    if (version == null) continue;
                    RetrievalAttFileDateDimension dimension = new RetrievalAttFileDateDimension();
                    dimension.setAttFileBoId(version.getBid());
                    dimension.setAttFileId(version.getId());
                    dimension.setEmployeeBoId(version.getEmployeeId().longValue());
                    dimension.setDepempBoId(version.getDepempBoid().longValue());
                    dimension.setPersonBoId(version.getPersonBoid().longValue());
                    dimension.setAttPersonId(version.getAttPersonId());
                    dimension.setOwnDate(date);
                    dimensions.add(dimension);
                }
            }
            startDate = startDate.plusDays(1L);
        }
        AttPeriodTable attPeriodTable = (AttPeriodTable)initParams.get("ATT_PERIOD");
        for (Map.Entry<Long, List<TimeSeqBo<AttFileModel>>> entry : attFileTimeSeqBoMap.entrySet()) {
            value = entry.getValue();
            if (WTCCollections.isEmpty(value)) continue;
            HashMap<Long, AttFileModel> attfileMap = new HashMap<Long, AttFileModel>(value.size() * 2);
            for (TimeSeqBo tmModel : value) {
                List versions = tmModel.getVersions();
                if (versions == null) continue;
                for (AttFileModel version : versions) {
                    attfileMap.put(version.getId(), version);
                }
            }
            List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriodList(entry.getKey());
            if (WTCCollections.isEmpty(perAttPeriodList)) continue;
            for (PerAttPeriod attPeriodModel : perAttPeriodList) {
                Long fileId;
                AttFileModel version;
                if (attPeriodModel == null || (fileId = attPeriodModel.getFileId()) == null || (version = (AttFileModel)((Object)attfileMap.get(fileId))) == null) continue;
                RetrievalAttFileDateDimension dimension = new RetrievalAttFileDateDimension();
                dimension.setAttFileBoId(attPeriodModel.getFileBoId().longValue());
                dimension.setAttFileId(fileId.longValue());
                dimension.setEmployeeBoId(version.getEmployeeId().longValue());
                dimension.setDepempBoId(version.getDepempBoid().longValue());
                dimension.setPersonBoId(version.getPersonBoid().longValue());
                dimension.setAttPersonId(version.getAttPersonId());
                dimension.setOwnDate(attPeriodModel.getPerAttEndDate());
                dimensions.add(dimension);
            }
        }
        FormulaService formulaService = (FormulaService)WTCAppContextHelper.getBean(FormulaService.class);
        try {
            formulaService.addRetrievalDimension(dimensions);
            Map<String, DataProvider> map = new TieProviderConfig().initProvider();
            formulaService.setDataProviderMap(map);
            if (CollectionUtils.isNotEmpty((Collection)formulaIdList)) {
                formulaService.addFormulaIds((Set)formulaIdList);
            }
        }
        catch (KDException kDException) {
            msg = new TieMessageStd(TieMsgLevel.ERROR, kDException.getMessage());
            return InitParamResult.success(msg);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            msg = new TieMessageStd(TieMsgLevel.ERROR, ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97\u516c\u5f0f\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"TieInitializerAttFormula_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            return InitParamResult.success(msg);
        }
        return InitParamResult.success(formulaService);
    }

    @Override
    public String category() {
        return "ATT_FOUMULA_INSTANCE";
    }
}

